<?php

namespace SearchWP\Dependencies\Ds;

/**
 * A Deque (pronounced "deck") is a sequence of values in a contiguous buffer
 * that grows and shrinks automatically. The name is a common abbreviation of
 * "double-ended queue".
 *
 * While a Deque is very similar to a Vector, it offers constant time operations
 * at both ends of the buffer, ie. shift, unshift, push and pop are all O(1).
 *
 * @package Ds
 */
final class Deque implements \IteratorAggregate, \ArrayAccess, \SearchWP\Dependencies\Ds\Sequence
{
    use Traits\GenericCollection;
    use Traits\GenericSequence;
    use Traits\SquaredCapacity;
    const MIN_CAPACITY = 8;
}
