<?php

declare (strict_types=1);
/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SearchWP\Dependencies\Monolog\Formatter;

use SearchWP\Dependencies\Elastica\Document;
/**
 * Format a log message into an Elastica Document
 *
 * @author Jelle Vink <jelle.vink@gmail.com>
 */
class ElasticaFormatter extends \SearchWP\Dependencies\Monolog\Formatter\NormalizerFormatter
{
    /**
     * @var string Elastic search index name
     */
    protected $index;
    /**
     * @var string Elastic search document type
     */
    protected $type;
    /**
     * @param string $index Elastic Search index name
     * @param string $type  Elastic Search document type
     */
    public function __construct(string $index, string $type)
    {
        // elasticsearch requires a ISO 8601 format date with optional millisecond precision.
        parent::__construct('Y-m-d\\TH:i:s.uP');
        $this->index = $index;
        $this->type = $type;
    }
    /**
     * {@inheritdoc}
     */
    public function format(array $record)
    {
        $record = parent::format($record);
        return $this->getDocument($record);
    }
    public function getIndex() : string
    {
        return $this->index;
    }
    public function getType() : string
    {
        return $this->type;
    }
    /**
     * Convert a log message into an Elastica Document
     * @param  array    $record
     * @return Document
     */
    protected function getDocument(array $record) : \SearchWP\Dependencies\Elastica\Document
    {
        $document = new \SearchWP\Dependencies\Elastica\Document();
        $document->setData($record);
        $document->setType($this->type);
        $document->setIndex($this->index);
        return $document;
    }
}
