<?php
/**
 * @package   Gravity_Forms_Encrypted_Fields
 * @author    PluginOwl <info@pluginowl.com>
 * @link      https://codecanyon.net/user/pluginowl/portfolio
 * @Copyright: 2016 Plugin Owl Software
 *
 * @wordpress-plugin
 * Plugin Name: Gravity Forms Encrypted Fields
 * Plugin URI: https://codecanyon.net/item/gravity-forms-encrypted-fields/18564931
 * Description: Extends Gravity Forms with encryption/decryption and data access controls and tools.
 * Version: 4.4.9
 * Author: Plugin Owl
 * Author URI: https://codecanyon.net/user/pluginowl/portfolio
 * Copyright: 2016 Plugin Owl Software
 */

// Prevent direct access to this file.
if (!defined('ABSPATH')) {
    header('HTTP/1.0 403 Forbidden');
    echo '404 File Not Found';
    exit; // Exit if accessed directly
}
//redundancy with alt instruction
defined('ABSPATH') or die();

//prevent redundant loading if WP is loaded more than once
if (defined('GFEF_PLUGIN_FILE')) {
	exit;
}

// Main file path
define( 'GFEF_PLUGIN_FILE', __FILE__ );

// Set variable for admin page url
define('GFEF_ADMIN', admin_url('options-general.php?page=gravity-forms-encrypted-fields'));

// ADD 'Settings' Link
function gfef_settings_link($links, $file) {
    if($file == plugin_basename(GFEF_PLUGIN_FILE) && function_exists('admin_url') ) {
        $settings_link = '<a href="' . GFEF_ADMIN . '">' . __('Settings') . '</a>';
        array_unshift( $links, $settings_link );
    }
    return $links;
}
add_filter('plugin_action_links', 'gfef_settings_link', 10, 2);

// Load salt
include_once("includes/salt.php");

// Load stylesheet -disabled for now due to injection possibility- keep styles simple and local
/*function wp_gfe_enqueue_scripts(){
	if (isset($_GET['page']) && $_GET['page'] == 'gravity-forms-encrypted-fields') {
		wp_register_style('gfestyle', plugin_dir_url( __FILE__ ) . 'includes/gfe.css');
		//wp_register_style( 'gfestyle', plugins_url( 'gravity-forms-encrypted-fields/includes/gfe.css' ) );
		wp_enqueue_style('gfestyle');
	}
}
add_action('admin_print_styles', 'wp_gfe_enqueue_scripts');*/


// Create the salt key
function gfef_create_salt($seed) {
	$salt 		= md5(wp_salt('nonce'));
	if ($seed != '' || $seed !=  null || $seed != false) {
		$salt 				= $seed;
		$file 				= '<?php
        // This unique salt is generated from your wordpress security keys.
        // Prevent direct access to this file.
        defined( "ABSPATH" ) or die();

        function gfef_get_salt() {
            $salt = "' . $seed . '";
            if (strpos($salt, "%%SALT%%")) {
                $salt = false;
            }
            return $salt;
        }';
		file_put_contents("". plugin_dir_path(__FILE__) . "/includes/salt.php", $file);
	} else {
		$file 	= file_get_contents("". plugin_dir_path(__FILE__) . "/includes/salt.php");
		$file 	= str_replace("[%%SALT%%]", $salt, $file);
		file_put_contents("" . plugin_dir_path(__FILE__) . "/includes/salt.php", $file);
	}
	return $salt;
}

// Check salt
function gfe_get_website_key() {
	if (get_option('gfe_website_key')) {
		return esc_html__(get_option('gfe_website_key'));
	} else {
		return gfef_get_salt();
	}
}

// Create salt backup
function gfef_create_regen_salt($salt) {
	$filename	= 'gfef_recover.php';
	$file 		= file_put_contents(trailingslashit(dirname(plugin_dir_path(__FILE__))) . $filename, gfef_encrypt($salt, false, md5(hash('SHA256', wp_salt('nonce'), true))));
}

// Delete salt backup
function gfef_delete_regen_salt() {
	$filename		= 'gfef_recover.php';
	if (file_exists(trailingslashit(dirname(plugin_dir_path(__FILE__))) . $filename)) {
		$file 		= unlink(trailingslashit(dirname(plugin_dir_path(__FILE__))) . $filename) or die('Failed to delete file:  ' . $filename);
	}
}

// Auto regen salt
function gfef_auto_regen_salt() {
	if (!gfef_get_salt() && get_option('gfe_website_key_regen') && !gfe_get_website_key()) {
		$file 		= false;
		$filename	= 'gfef_recover.php';
		if (file_exists(trailingslashit(dirname(plugin_dir_path(__FILE__))) . $filename)) {
			$file 	= file_get_contents(trailingslashit(dirname(plugin_dir_path(__FILE__))) . $filename);
		}
		if ($file) {
			gfef_create_salt(gfef_decrypt($file, md5(hash('SHA256', wp_salt('nonce'), true))));
		} else {
			gfef_create_salt(false);
		}
	}
}
add_action('wp_loaded', 'gfef_auto_regen_salt');

// Warn salt is missing
function gfef_alert_missing_salt() {
	if (is_admin() && !gfef_get_salt() && get_option('gfe_encryption_method') && get_option('gfe_encryption_key')) {
		function gfef_website_key_notice() {
			?>
			<div class="update-nag notice">
				<?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/GFEFicon80x80.jpg" height="80" width="80" style="display:inline-block; float:left; margin-right: 10px;">'; ?>
				<div style="display:inline-block;"><?php _e('<p style="font-size:20px;">Gravity Forms Encrypted Fields installation has changed.</p><p>If you are using the secure autogenerated Website Key, it will be regenerated for you.<br/>If you are using a custom Website Key that was updated in ver 4.3.9+, it will attempt to regenerate for you.</p><p><strong>Check the Website Key now to be sure it is correct on the <a href="' . GFEF_ADMIN . '/#gfef-website-key">' . __('settings page') . '</a>!</strong></p>', 'gfef_textdomain'); ?></div>
			</div>
			<?php
		}
		add_action( 'admin_notices', 'gfef_website_key_notice' );
	}
}
add_action('wp_loaded', 'gfef_alert_missing_salt');

// Echo the salt key
function gfef_echo_auto_salt() {
	$salt 					= md5(wp_salt('nonce'));
	echo $salt;
}

// GET/CREATE KEY
function gfef_get_key($gfe_key, $operation) {
	$gfe_key_override 		= esc_html__(get_option('gfe_encryption_key_override'));
	if ($operation) {
		if ($operation === 'decrypt') {
			if ($gfe_key_override) {
				$gfe_key = md5($gfe_key_override);
			}
		}
	}
	$password 				= "!c64l?" . trim($gfe_key) . "h4s?09aq-p3x";
	$salt 					= gfef_get_salt() === false ? gfef_create_salt(false) : gfef_get_salt();
	$key 					= md5(hash('SHA256', $salt . $password, true));
	
	return $key;
}

// OPEN SSL Encrypt
function gfef_ssl_encrypt($text, $creatinguser, $key) {
    $ssl_cipher_name = "AES-256-CBC";
	$gfef_search_key = substr(hash('sha256', substr(hash('sha256', md5(substr($key, 12, 4) . $text)),24, 6) . substr(hash('sha256', md5(substr($key, 30, 10) . $text)),54, 6)), 33, 10);
    $key 			 = hash('sha256', $key);
	$iv_size		 = openssl_cipher_iv_length($ssl_cipher_name);  // iv for AES-256-CBC = 16 bytes
	$iv 			 = substr(hash('sha256', base64_encode(openssl_random_pseudo_bytes($iv_size))), 0, $iv_size);
    $text 			 = 'GFEncrypt: ' . $iv . $gfef_search_key . trim(base64_encode(openssl_encrypt($creatinguser . $text, $ssl_cipher_name, $key, 0, $iv)));
	
    return $text;
}

// OPEN SSL Decrypt
function gfef_ssl_decrypt($text, $key) {
    $ssl_cipher_name = "AES-256-CBC";
    $key 			 = hash('sha256', $key);
	$iv_size 		 = openssl_cipher_iv_length($ssl_cipher_name);  // iv for AES-256-CBC = 16 bytes
	$text_decode 	 = substr($text, 11);
    $iv 			 = substr($text_decode, 0, $iv_size);
	$text_decode 	 = substr($text_decode, $iv_size + 10);
    $text			 = trim(openssl_decrypt(base64_decode($text_decode), $ssl_cipher_name, $key, 0, $iv));

    return $text;
}

// Encrypt
function gfef_encrypt($text, $creatinguser = false, $key = false) {
	$use_mcrypt 			= apply_filters('gform_use_mcrypt', function_exists( 'mcrypt_encrypt'));
	$use_openssl			= function_exists('openssl_encrypt') && extension_loaded('openssl');
	$gfe_key 				= false;
	if (get_option('gfe_encryption_key')) {
		$gfe_key 			= md5(esc_html__(get_option('gfe_encryption_key')));
	}
	$gfe_bypass				= esc_html__(get_option('gfe_encryption_bypass'));
	$gfe_type			 	= get_option('gfe_encryption_method');
	$key 					= $key ? $key : gfef_get_key($gfe_key, 'encrypt');
	$gfef_search_key 		= substr(hash('sha256', substr(hash('sha256', md5(substr($key, 12, 4) . $text)),24, 6) . substr(hash('sha256', md5(substr($key, 30, 10) . $text)),54, 6)), 33, 10);
	
	if ($creatinguser) {
		$creatinguser = 'GFEFU[[[' . $creatinguser . ']]]GFEFU';
	}
	
	if ($gfe_type == 2 && $use_mcrypt && $gfe_key && !$gfe_bypass) {
		$mcrypt_cipher_name = MCRYPT_RIJNDAEL_128;
		$iv_size            = mcrypt_get_iv_size($mcrypt_cipher_name, MCRYPT_MODE_CBC);
		//$iv 				= mcrypt_create_iv($iv_size, MCRYPT_RAND);
		$iv					= substr(hash('sha256', base64_encode(mcrypt_create_iv($iv_size, MCRYPT_RAND))), 0, $iv_size);
		$encrypted_value 	= 'GFEncrypt: ' . $iv . $gfef_search_key . trim(base64_encode(mcrypt_encrypt($mcrypt_cipher_name, $key, $creatinguser . $text, MCRYPT_MODE_CBC, $iv)));
	} else if ($gfe_type == 1 && $gfe_key && $use_openssl && !$gfe_bypass) {
		$encrypted_value	= gfef_ssl_encrypt($text, $creatinguser, $key);
	} else {
		$encrypted_value 	= $text;
	}
	return $encrypted_value;
}

// Decrypt
function gfef_decrypt($text, $key = false) {
    $secure_key 			= substr($text, 0, 11);
    if ($secure_key !== 'GFEncrypt: ') {
		return $text;
    }
    
	$use_mcrypt 			= apply_filters('gform_use_mcrypt', function_exists( 'mcrypt_decrypt'));
	$use_openssl			= function_exists('openssl_encrypt') && extension_loaded('openssl');
	$gfe_type			 	= get_option('gfe_encryption_method');
	$gfe_key 				= false;
    
	if (get_option('gfe_encryption_key')) {
		$gfe_key 			= md5(esc_html__(get_option('gfe_encryption_key')));
	}
	$key 					= $key ? $key : gfef_get_key($gfe_key, 'decrypt');

    if ($gfe_type == 2 && $use_mcrypt && $gfe_key) {
        $mcrypt_cipher_name = MCRYPT_RIJNDAEL_128;
        $iv_size            = mcrypt_get_iv_size($mcrypt_cipher_name, MCRYPT_MODE_CBC);
        $text_decode 	 	= substr($text, 11);
        $iv 			 	= substr($text_decode, 0, $iv_size);
        $text_decode 	 	= base64_decode(substr($text_decode, $iv_size + 10));
        $decrypted_value 	= trim(mcrypt_decrypt($mcrypt_cipher_name, $key, $text_decode, MCRYPT_MODE_CBC, $iv));
    } else if ($gfe_type == 1 && $gfe_key && $use_openssl) {
        $decrypted_value	= gfef_ssl_decrypt($text, $key);
    }

	return $decrypted_value;
}

/*GET FIELD HELPER FUNCTION FOR GF 2.3 GFAPI CHANGE*/
function gfef_get_field($form, $field_id) {
	$field = false;
	if (is_numeric($field_id)) {
		if (method_exists('GFAPI', 'get_field')) {
			$field = GFAPI::get_field($form, $field_id);
		} else {
			$field = GFFormsModel::get_field($form, $field_id);
		}
	}
	return $field;
}

/*GET RAW ENTRY FIELD VALUE*/
function gfef_get_raw_field_value($entry_id, $field_id) {
	remove_filter('gform_get_input_value', 'gfef_decrypt_field', 10);
	$entry			 = GFAPI::get_entry($entry_id);
	$raw_field_value = rgar($entry, $field_id);
	add_filter('gform_get_input_value', 'gfef_decrypt_field', 10, 4);
	if ($raw_field_value) {
		return $raw_field_value;
	} else {
		return false;
	}
}

/*PRGORAMATIC ENCRYPT/DECRYPT -DEVELOPER HELPER FUNCTIONS*/
function gfef_text_encrypt($text, $key = false) {
    return gfef_encrypt($text, false, $key);
}
function gfef_text_decrypt($text, $key = false) {
    return gfef_decrypt($text, $key);
}

/*GET PROGRAMATIC DECRYPTED FIELD VALUE -DEVELOPER HELPER FUNCTION*/
function gfef_developer_decrypt($entry_id, $field_id, $format = false) {
	if ($entry_id && $field_id && is_numeric($entry_id) && is_numeric($field_id)) {
		$value = gfef_get_raw_field_value($entry_id, $field_id);
		$value = gfef_decrypt($value);
		if ($value) {
			$value	= strpos($value, ']]]GFEFU') ? explode(']]]GFEFU', $value) : $value;
			$value	= is_array($value) ? $value[1] : $value;
			if ($format) {
				return GFCommon::get_lead_field_display($field, $value, false, true, 'html');
			} else {
				return $value;
			}
		} else {
			return false;
		}
	}
	return false;
}

/*GET USER OWNED FIELD VALUE FROM RAW OR DECRYPTED VALUE*/
function gfef_get_user_owned_value($value) {
	$gfe_current_user 			= wp_get_current_user();
	$gfe_current_username		= $gfe_current_user->user_login;
	$user_logged_in				= is_user_logged_in() ? TRUE : false;
	if ($user_logged_in) {
		$user_exctract			= gfef_decrypt($value);
		$owner_value			= explode(']]]GFEFU', $user_exctract);
		$user_owner		 		= $owner_value[0];
		$user_owner 			= explode('GFEFU[[[', $user_owner);
		$user_owner		 		= $user_owner[1];
		$owner_value			= $owner_value[1];

		if (md5($gfe_current_username . get_current_user_id()) === $user_owner) {
			$value				= $owner_value;
		} else {
			$value				= esc_html__(get_option('gfe_restricted'));
		}
	} else {
		$value					= esc_html__(get_option('gfe_restricted'));
	}
	return $value;
}

/*CONVERT DATES TO dateFormat*/
function gfef_date_format($date, $format) {
	$date_stamp = strtotime($date);
	switch ($format) {
		case 'mdy':
			$date = date('m/d/Y', $date_stamp);
			break;
		case 'dmy':
			$date = date('d/m/Y', $date_stamp);
			break;
		case 'dmy_dash':
			$date = date('d-m-Y', $date_stamp);
			break;
		case 'dmy_dot':
			$date = date('d.m.Y', $date_stamp);
			break;
		case 'ymd_slash':
			$date = date('Y/m/d', $date_stamp);
			break;
		case 'ymd_dash':
			$date = date('Y-m-d', $date_stamp);
			break;
		case 'ymd_dot':
			$date = date('Y.m.d', $date_stamp);
			break;
	}
	return $date;
}

/*FIELD OUTPUT MASKING*/
function gfef_check_masks($form_id, $field_id, $data, $display) {
	if (!get_option('gfe_pluginowl_licensed')) {
		return false;
	}
	$mask_form 	= null;
	$mask_field = null;
	$mask_first = null;
	$mask_last 	= null;
	$masks 		= get_option('gfe_masking') ? get_option('gfe_masking') : '';
	$masks 		= explode(',', $masks);
	$raw_data 	= $data;
	$form 		= GFAPI::get_form($form_id);
	$field_id  = explode('.', $field_id);
	$field_id 	= $field_id[0];
	$field		= gfef_get_field($form, $field_id);
	foreach ($masks as $mask) {
		$mask 			= trim($mask);
		$mask_format 	= explode(':', $mask);
		if (count($mask_format) < 4 || count($mask_format) > 6){
			return false;
		} else {
			$mask_form 	= trim($mask_format[0]);
			$mask_field = trim($mask_format[1]);
			$mask_first = trim($mask_format[2]);
			$mask_last 	= trim($mask_format[3]);
			if ($form_id == $mask_form && $field_id == $mask_field) {
				$data_first = substr($data, 0, $mask_first);
				$data_last 	= substr($data, -$mask_last);
				if ($mask_last == '0') {
					$data_last 	= null;
				}
				$data = $data_first . '***' . $data_last;
				if (!in_array('M', $mask_format, TRUE) && $display == 'M') {
					if ($field->type == 'list') {
						return get_option('gfe_restricted');
					} else {
						return false;
					}
				}
				if (in_array('F', $mask_format, TRUE)) {
					$data = $raw_data;
				} 
				return $data;
			} else if ($field->type == 'list' && ($form_id != $mask_form || $field_id != $mask_field) && $display === 'list_encrypted') {
				return get_option('gfe_restricted');
			} else if ($field->type == 'list' && ($form_id != $mask_form || $field_id != $mask_field) && $display === 'list_hidden') {
				return get_option('gfe_hidevalue');
			} else if ($field->type == 'list' && ($form_id != $mask_form || $field_id != $mask_field) && $display === 'M') {
				return get_option('gfe_restricted');
			} 
		} 
	}
	return false;
}

/*GFORM FIELD DATA ENCRYPTION LOGIC*/
add_filter('gform_save_field_value', 'gfef_encrypt_field_value', 99999999, 4);
function gfef_encrypt_field_value($value, $lead, $field, $form) {
	$tagged = substr($value, 0, 11);
	if (!$field) {
		$delay = false;
	} else {
		$delay = $field->delayedencryptField ? true : false;
	}
	if (($value || $value === 0 || $value === '0') && !$delay && ($tagged !== 'GFEncrypt: ') || ($delay && $tagged === 'GFEncrypD: ')) {
		if ($tagged === 'GFEncrypD: ' && $delay = true) {
			$value = explode('GFEncrypD: ', $value);
			$value = $value[1];
		}
		$decrypt 				= false;
		$gfe_current_user 		= wp_get_current_user();
		$encrypt_decrypt_user	= $gfe_current_user->user_login;
		$form_id				= rgar($form, 'id');
		
		if (is_admin() && $form_id == get_option('gfe_encrypt_decrypt_form') && $encrypt_decrypt_user == get_option('gfe_encrypt_decrypt_user') && isset($_GET['page']) && $_GET['page'] == 'gravity-forms-encrypted-fields'){
			$decrypt = true;
		}
		
		if ($field->encryptField == true && $field->hidevalueField == false && !get_option('gfe_encryption_bypass') && !$decrypt) {
				if ($field->gfedecryptownerField == true && is_user_logged_in() && (get_current_user_id() != 0)) {
					$gfe_created_user 			= null;
					$gfe_created_user_id        = null;
					if (!rgar($lead, 'created_by')) {
						$gfe_created_user_id	= get_current_user_id();
						if ($gfe_created_user_id != 0){
							$gfe_current_user 	= wp_get_current_user();
							$gfe_created_user	= $gfe_current_user->user_login;
						}
					} else {
						$gfe_created_user_id	= rgar($lead, 'created_by');
						$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
						$gfe_created_user		= $gfe_created_user->user_login;
					}
					$gfe_crypt_user 			= md5($gfe_created_user . $gfe_created_user_id);
					return gfef_encrypt($value, $gfe_crypt_user);
				} else {
					return gfef_encrypt($value, false);
				}
		} else {
			return($value);
		}
	} else {
		return($value);
	}
}

/*LIST FIELD DATA RESTRICTION*/
function gfef_list_restrict($value, $owner_value, $restriction_type, $form_id = null, $field_id = null, $masking = false) {
	if ($owner_value) {
		$value = $owner_value;
	} else {
		$value = gfef_decrypt($value);
	}
	$list_values = unserialize($value);
	foreach ($list_values as &$list_values_inner) {
		if (is_array($list_values_inner)) {
			foreach ($list_values_inner as $key => &$the_value) {
				if ($masking) {
					$the_value = gfef_check_masks($form_id, $field_id, $the_value, $masking);
				} else {
					$the_value = esc_html__($restriction_type);
				}
			}
		} else {
			if ($masking) {
				$list_values_inner = gfef_check_masks($form_id, $field_id, $list_values_inner, $masking);
			} else {
				$list_values_inner = esc_html__($restriction_type);
			}
		}
	}
	$list_values = maybe_serialize($list_values);
	return $list_values;
}

/*GFORM FIELD DATA DECRYPTION LOGIC*/
add_filter('gform_get_input_value', 'gfef_decrypt_field', 10, 4);
function gfef_decrypt_field($value, $entry, $field, $input_id) {
	$db_value						= $value;
	if (get_option('gfe_show_encryption')) {
		$secure_key 				= substr($db_value, 0, 11);
		if ($secure_key === 'GFEncrypt: ') {
			return $db_value;
		} 
	}
	if ($value || $value === 0 || $value === '0') {
		$form_id							= $entry['form_id'];
		$field_id							= $field->id;
		$permmision_granted 				= 'no';
		$key								= null;
		$gfe_user_role						= false;
		$gfe_user_access_list_role			= false;
		$gfe_user_role_limit_access_list 	= false;
		$gfe_current_user 					= wp_get_current_user();
		$gfe_current_username				= $gfe_current_user->user_login;
		$gfe_current_user_roles				= $gfe_current_user->roles;
		$gfe_users_list 					= $field->decryptFieldUsers;
		$gfe_user_access_list 				= $gfe_users_list ? array_map('trim', explode(",", $gfe_users_list)) : array();
		$gfe_user_block_list 				= esc_html__(get_option('gfe_user_lockout_list'));
		$gfe_user_block_access_list 		= $gfe_user_block_list ? array_map('trim', explode(",", $gfe_user_block_list)) : array();
		$gfe_user_allow_list 				= esc_html__(get_option('gfe_user_lockout_override_list'));
		$gfe_user_allow_access_list 		= $gfe_user_allow_list ? array_map('trim', explode(",", $gfe_user_allow_list)) : array();
		$gfe_user_limit_list 				= esc_html__(get_option('gfe_limit_user_view_permission_list'));
		$gfe_user_limit_access_list 		= $gfe_user_limit_list ? array_map('trim', explode(",", $gfe_user_limit_list)) : array();
		$secure_key 						= substr($value, 0, 11);
		$user_also							= false;
		$user_owned 						= substr(gfef_decrypt($value), 0, 8);
		$user_access						= false;
		$owner_value						= null;
		$gfe_admin_only						= false;
		$user_logged_in						= is_user_logged_in() ? TRUE : false;
		$encrypt_decrypt					= false;
		
		if (is_admin() && get_option('gfe_encrypt_decrypt') && get_option('gfe_encrypt_decrypt_form') && $gfe_current_username == get_option('gfe_encrypt_decrypt_user') && isset($_GET['page']) && $_GET['page'] == 'gravity-forms-encrypted-fields') {
			$encrypt_decrypt		= true;
		}
		
		if ($secure_key === 'GFEncrypt: ') {
			$key = 'locked';
		} else {
			$key = 'unlocked';
		}
		
		if ($field->gfedecryptowneralsoField == TRUE) {
			if ($gfe_current_user->ID == rgar($entry, 'created_by')) {
				$user_also 				= TRUE;
			}
		}
		
		if ($user_owned === 'GFEFU[[[') {
			$user_owned				= TRUE;
			if ($user_logged_in) {
				$user_exctract			= gfef_decrypt($value);
				$owner_value			= explode(']]]GFEFU', $user_exctract);
				$user_owner		 		= $owner_value[0];
				$user_owner 			= explode('GFEFU[[[', $user_owner);
				$user_owner		 		= $user_owner[1];
				$owner_value			= $owner_value[1];

				if (md5($gfe_current_username . get_current_user_id()) === $user_owner) {
					$user_access		= TRUE;
					
				}
			}
		} else if ($user_owned !== 'GFEFU[[[') {
			$user_owned				= false;
		}
		
		foreach ($gfe_user_access_list as $role) {
			if (in_array($role, $gfe_current_user_roles, TRUE)) {
				$gfe_user_role = true;
			}
		}
		
		foreach ($gfe_user_allow_access_list as $role) {
			if (in_array($role, $gfe_current_user_roles, TRUE)) {
				$gfe_user_access_list_role = true;
			}
		}
		
		foreach ($gfe_user_limit_access_list as $role) {
			if (in_array($role, $gfe_current_user_roles, TRUE)) {
				$gfe_user_role_limit_access_list = true;
			}
		}
		
		if (get_option('gfe_admin_only') && $user_logged_in && is_admin()) {
			$gfe_admin_only = TRUE;
		} else if (!get_option('gfe_admin_only') && $user_logged_in) {
			$gfe_admin_only = TRUE;
		}
	
		//PERMISSIONS FILTERING 
		if (((((($gfe_users_list == '' || $gfe_users_list ==  null) || (in_array($gfe_current_username, $gfe_user_access_list, TRUE) || $gfe_user_role) && !in_array('lockdown', $gfe_user_access_list, TRUE)) && (($gfe_user_limit_list == '' || $gfe_user_limit_list == null) || in_array($gfe_current_username, $gfe_user_limit_access_list, TRUE) || $gfe_user_role_limit_access_list || ($gfe_users_list == '' || $gfe_users_list ==  null))) && !in_array($gfe_current_username, $gfe_user_block_access_list, TRUE) && !in_array('lockdown', $gfe_user_block_access_list, TRUE)) || (in_array($gfe_current_username, $gfe_user_allow_access_list, TRUE) || $gfe_user_access_list_role)) && $user_logged_in && $gfe_admin_only && !$user_owned) {
			$permmision_granted = 'yes';
		} else if ($user_also && !in_array('lockdown', $gfe_user_access_list, TRUE) && !in_array($gfe_current_username, $gfe_user_block_access_list, TRUE) && !in_array('lockdown', $gfe_user_block_access_list, TRUE)){
			$permmision_granted = 'yes';
		} else if ($user_owned && $user_access && $gfe_admin_only) {
			$permmision_granted = 'yes';
			$value 				= $owner_value;
		} else {
			$permmision_granted = 'no';
		}
		if (!is_array(get_option('gfe_pluginowl_licensed'))) {
			$permmision_granted = 'no';
		}
		if (/*$field->encryptField == true  &&*/ $permmision_granted == 'yes' && $key === 'locked') {
			if ($encrypt_decrypt && isset($_GET['page']) && $_GET['page'] == 'gravity-forms-encrypted-fields') {
				return($db_value);
			} else {
				return gfef_decrypt($value);
			}
		} else if (/*$field->encryptField == true &&*/ $permmision_granted == 'no' && $key === 'locked'){
			if ($encrypt_decrypt && isset($_GET['page']) && $_GET['page'] == 'gravity-forms-encrypted-fields') {
				return($db_value);
			}
			if (get_option('gfe_masking') && $_GET['page'] != 'gravity-forms-encrypted-fields' && !$user_owned /*&& $field->type != 'list'*/) {
				$temp_value 		= gfef_decrypt($value);
				$masked_value 		= gfef_check_masks($form_id, $field_id, $temp_value, 'W');
				if ($field->type === 'list') {
					$masked_value 	= gfef_list_restrict($value, $owner_value, get_option('gfe_restricted'), $form_id, $field_id, 'list_encrypted');
				}
				$field_user_owned 	= $field->gfedecryptownerField;
				if ($masked_value && !$field_user_owned) {
					return $masked_value;
				} else {
					return (esc_html__(get_option('gfe_restricted')));
				}
			} else {
				if ($field->type === 'list') {
					$restriction_type = get_option('gfe_restricted');
					return gfef_list_restrict($value, $owner_value, $restriction_type);
				}
				return (esc_html__(get_option('gfe_restricted')));
			}
		} else if (($field->hidevalueField == true || $field->encryptField == true) && $permmision_granted == 'no' && $key === 'unlocked' ){
			if (($encrypt_decrypt && isset($_GET['page']) && $_GET['page'] == 'gravity-forms-encrypted-fields') || $field->delayedencryptField == true) {
				return($db_value);
			}
			if (get_option('gfe_masking') && $_GET['page'] != 'gravity-forms-encrypted-fields' && !$user_owned /*&& $field->type !== 'list'*/) {
				$temp_value 		= gfef_decrypt($value);
				$masked_value 		= gfef_check_masks($form_id, $field_id, $temp_value, 'W');
				if ($field->type === 'list') {
					$masked_value 	= gfef_list_restrict($value, $owner_value, get_option('gfe_hidevalue'), $form_id, $field_id, 'list_hidden');
				}
				$field_user_owned 	= $field->gfedecryptownerField;
				if ($masked_value && !$field_user_owned) {
					return $masked_value;
				} else {
					return (esc_html__(get_option('gfe_hidevalue')));
				}
			} else {
				if ($field->type === 'list') {
					$restriction_type = get_option('gfe_hidevalue');
					return gfef_list_restrict($value, $owner_value, $restriction_type);
				}
				return (esc_html__(get_option('gfe_hidevalue')));
			}
		} else {
			return($value);
		}
	} else {
		return($value);
	}
}

/*ENCRYPT/DECRYPT ADMIN OPTIONS*/
//admin decrypt
function gfef_decrypt_entries_process($entries, $fields, $form){
	echo('<p><b>DECRYPTION REPORT <img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="12" width="12"> :</b><p><p><b>Form ID:</b> ' . get_option('gfe_encrypt_decrypt_form') . '</p><p><b>Processed User Owned Fields Status:</b> Decrypted and User Ownership Removed.</p><p>Below is a list of processed entries and the fields that were decrypted for that entry.<br/>Field IDs with decimal places represent multi part fields.<br/><b>Entry ID:</b> Field IDs</p>');
	if (!$fields && !get_option('gfe_encrypt_decrypt_form_entry_paging')) {
		echo('<p>No "ENTRY IDs" were specified and the "BATCH SIZE" has been left blank or 0.<br/>No entries were processed.<br/>If you are not specifying entries, you must specify a "BATCH SIZE" of 200 or less.</p>');
		return;
	}
	
	foreach($entries as $entry) {
		$value	  		= null;
		$entry_id 		= rgar($entry, 'id');
		$form_id		= rgar($entry, 'form_id');
		
		if ($form_id == $form){
			echo('<p><b>' . $entry_id . '</b>');
			echo(': ');

			foreach($entry as $key => $value) {
				$decyptable_field = false;
				if (substr($value, 0, 11) === 'GFEncrypt: ') {
					$value 			= gfef_decrypt($value);
					$user_owned 	= substr($value, 0, 8);
					if ($user_owned === 'GFEFU[[[') {
						$value	= explode(']]]GFEFU', $value);
						$value	= $value[1];
					}
					$decyptable_field = true;
				}

				if (!$fields){
					$entry[$key] = $value;
					if ($decyptable_field === true){
						echo($key . ', ');
					}
				} 
				if ($fields){
					if (strstr($key, '.')){
						$key_base 	 = explode('.', $key);
						$key_base 	 = $key_base[0];
						if (in_array($key_base, $fields)){
							$entry[$key] = $value;
							if ($decyptable_field === true){
								echo($key . ', ');
							}
							//GFAPI::update_entry_field($entry_id, $key_base, $value);
						}
					} else {
						if (in_array($key, $fields)){
							$entry[$key] = $value;
							if ($decyptable_field === true){
								echo($key . ', ');
							}
							//GFAPI::update_entry_field($entry_id, $key, $value);
						}
					}
				}
			}
			GFAPI::update_entry($entry);
			echo('</p>');
		}
	}
}

//admin encrypt
function gfef_encrypt_entries_process($entries, $fields, $form){
	$encryptable_fields	= array();
	$encryption_on		= array();
	$user_owned_fields	= array();
	echo('<p><b>ENCRYPTION REPORT <img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="12" width="12"> :</b><p><p><b>Form ID:</b> ' . get_option('gfe_encrypt_decrypt_form') . '</p>');
	if (!$fields && !get_option('gfe_encrypt_decrypt_form_entry_paging')) {
		echo('<p>No "ENTRY IDs" were specified and the "BATCH SIZE" has been left blank or 0.<br/>No entries were processed.<br/>If you are not specifying entries, you must specify a "BATCH SIZE" of 200 or less.</p>');
		return;
	}
	
	foreach($entries as $entry) {
		$value	  			= null;
		$entry_id 			= rgar($entry, 'id');
		$form_id			= rgar($entry, 'form_id');
		$form_object		= GFAPI::get_form($form_id);
		$user_original		= rgar($entry, 'created_by');
		
		if ($form_id == $form){
			if (empty($encryptable_fields)){
				echo('<p><b>Encryptable Field IDs: </b> ');
				foreach ($form_object['fields'] as $field) {
				   if ($field->type === 'text' || $field->type === 'textarea' || $field->type === 'date' || $field->type === 'name' || $field->type === 'number' || $field->type === 'email' || $field->type === 'phone' || $field->type === 'website' || $field->type === 'address' || $field->type === 'select' || $field->type === 'radio' || $field->type === 'multiselect' || $field->type === 'checkbox' || $field->type === 'list' || $field->type === 'time') {
					   array_push($encryptable_fields, $field->id);
					   echo($field->id . ', ');
				   }
				}
			}
			if (empty($encryption_on)){
				echo('<p><b>Encryption is Turned ON for Field IDs: </b> ');
				foreach ($form_object['fields'] as $field) {
				   if ($field->encryptField == true) {
					   array_push($encryption_on, $field->id);
					   echo($field->id . ', ');
				   }
				}
			}
			if (empty($user_owned_fields)){
				echo('<p><b>Current User Owned Field IDs: </b>');
				
				foreach ($form_object['fields'] as $field) {
				   if ($field->gfedecryptownerField) {
					   array_push($user_owned_fields, $field->id);
					   echo($field->id . ', ');
				   }
				}
				echo('</p>');
				if (get_option('gfe_encrypt_decrypt_form_ubf')){
					echo('<p><b>Processed User Owned Fields Status:</b> Encrypted and User Owned</p>');
				} else {
					echo('<p><b>Processed User Owned Fields Status:</b> Encrypted Only. Not User Owned</p>');
				}
				
				echo('<p>Below is a list of processed entries and the fields that were encrypted for that entry.<br/>Field IDs with decimal places represent multi part fields.<br/><b>Entry ID:</b> Field IDs</p>');
				array_push($user_owned_fields, 'not empty ');
			}
			echo('<p><b>' . $entry_id . ': </b>');

			foreach($entry as $key => $value) {
				if (substr($value, 0, 11) !== 'GFEncrypt: ') {
					if (!$fields && !get_option('gfe_encrypt_decrypt_form_encrypt_all')){
						if (strstr($key, '.')){
							$key_base 	 = explode('.', $key);
							$key_base 	 = $key_base[0];
							if (in_array($key_base, $encryptable_fields) && in_array($key_base, $encryption_on) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key_base, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key] 	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
							}
						} else {
							if (in_array($key, $encryptable_fields) && in_array($key, $encryption_on) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key]	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
								//GFAPI::update_entry_field($entry_id, $key, $value);
							}
						}
					} 
					else if ($fields && !get_option('gfe_encrypt_decrypt_form_encrypt_all')) {
						if (strstr($key, '.')){
							$key_base 	 = explode('.', $key);
							$key_base 	 = $key_base[0];
							if (in_array($key_base, $encryptable_fields) && in_array($key_base, $encryption_on) && in_array($key_base, $fields) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key_base, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key] 	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
							}
						} else {
							if (in_array($key, $encryptable_fields) && in_array($key, $encryption_on) && in_array($key, $fields) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key]	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
								//GFAPI::update_entry_field($entry_id, $key, $value);
							}
						}
					}
					else if ($fields && get_option('gfe_encrypt_decrypt_form_encrypt_all')){
						if (strstr($key, '.')){
							$key_base 	 = explode('.', $key);
							$key_base 	 = $key_base[0];
							if (in_array($key_base, $encryptable_fields) && in_array($key_base, $fields) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key_base, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key] 	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
							}
						} else {
							if (in_array($key, $encryptable_fields) && in_array($key, $fields) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key]	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
								//GFAPI::update_entry_field($entry_id, $key, $value);
							}
						}
					}
					else if (!$fields && get_option('gfe_encrypt_decrypt_form_encrypt_all')){
						if (strstr($key, '.')){
							$key_base 	 = explode('.', $key);
							$key_base 	 = $key_base[0];
							if (in_array($key_base, $encryptable_fields) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key_base, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key] 	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
							}
						} else {
							if (in_array($key, $encryptable_fields) && ($value || $value === 0 || $value === '0')) {
								if (in_array($key, $user_owned_fields) && get_option('gfe_encrypt_decrypt_form_ubf')) {
									$gfe_created_user_id	= rgar($entry, 'created_by');
									$gfe_created_user		= get_user_by('id', $gfe_created_user_id);
									$gfe_created_user		= $gfe_created_user->user_login;
									$gfe_crypt_user 		= md5($gfe_created_user . $gfe_created_user_id);
									$value					= gfef_encrypt($value, $gfe_crypt_user);
									$entry[$key] 			= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								} else {
									$value 			= gfef_encrypt($value, false);
									$entry[$key]	= $value;
									//GFAPI::update_entry_field($entry_id, $key_base, $value);
								}
								echo($key . ', ');
								//GFAPI::update_entry_field($entry_id, $key, $value);
							}
						}
					}
				}
			}
			GFAPI::update_entry($entry);
			echo('</p>');
		}
	}
}

//admin add or remove encryption processing
function gfef_add_remove_encryption($encrypt_decrypt, $encrypt_decrypt_form, $encrypt_decrypt_entries, $encrypt_decrypt_fields, $encrypt_decrypt_paging, $encrypt_decrypt_paging_offset) {
	$entries 		= null;
	$fields			= null;
	$form			= $encrypt_decrypt_form;
	?>
	<script type='text/javascript'>
		function gfef_remove_report() {
			var e = document.getElementById('add-remove-encryption-report');
			e.style.display = 'none';
		 }
	</script>
	<?php
	if ($encrypt_decrypt === 'decrypt' || $encrypt_decrypt === 'encrypt' && $encrypt_decrypt_form) {
		echo('<div id="add-remove-encryption-report" style="max-width: 790px; background-color: #ffffff; border-left: 4px solid #4ecd33; padding: 15px; margin: 10px 10px 10px 0px; position: relative; -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);"><a href="#" style="position: absolute; top: 10px; right: 15px" onClick="gfef_remove_report();">close</a>');
		if ($encrypt_decrypt_fields){
			$fields = explode(',', $encrypt_decrypt_fields);
		}

		if ($encrypt_decrypt === 'decrypt' && $encrypt_decrypt_entries){
			$entries = array();
			$encrypt_decrypt_entries = explode(',', $encrypt_decrypt_entries);
			foreach($encrypt_decrypt_entries as $specified_entry) {
				$entry = GFAPI::get_entry($specified_entry);
				array_push($entries, $entry);
			}
			gfef_decrypt_entries_process($entries, $fields, $form);
		}
		if ($encrypt_decrypt === 'encrypt' && $encrypt_decrypt_entries){
			$entries = array();
			$encrypt_decrypt_entries = explode(',', $encrypt_decrypt_entries);
			foreach($encrypt_decrypt_entries as $specified_entry) {
				$entry = GFAPI::get_entry($specified_entry);
				array_push($entries, $entry);
			}
			gfef_encrypt_entries_process($entries, $fields, $form);
		}
		
		if (!$encrypt_decrypt_paging){
			$encrypt_decrypt_paging = 0;
		}
		if ($encrypt_decrypt_paging > 200){
			$encrypt_decrypt_paging = 200;
		}
		if (!$encrypt_decrypt_paging_offset){
			$encrypt_decrypt_paging_offset = 0;
		}
		
		$search_criteria 	= array();
		$sorting 			= null;
		$paging 			= array('offset' => $encrypt_decrypt_paging_offset, 'page_size' => $encrypt_decrypt_paging);
		$total_count 		= null;
		
		if ($encrypt_decrypt === 'decrypt' && !$encrypt_decrypt_entries){			
			//$search_criteria['field_filters'][] = array('operator' => 'contains', 'value' => 'GFEncrypt: ');
			$entries = GFAPI::get_entries($encrypt_decrypt_form, $search_criteria, $sorting, $paging, $total_count);
			gfef_decrypt_entries_process($entries, $fields, $form);
		}
		if ($encrypt_decrypt === 'encrypt' && !$encrypt_decrypt_entries){
			$entries = GFAPI::get_entries($encrypt_decrypt_form, $search_criteria, $sorting, $paging, $total_count);
			gfef_encrypt_entries_process($entries, $fields, $form);
		}

		delete_option('gfe_encrypt_decrypt_user');
		delete_option('gfe_encrypt_decrypt');
		//delete_option('gfe_encrypt_decrypt_form');
		//delete_option('gfe_encrypt_decrypt_form_entries');
		//delete_option('gfe_encrypt_decrypt_form_fields');
		//delete_option('gfe_encrypt_decrypt_form_entry_paging');
		//delete_option('gfe_encrypt_decrypt_form_paging_offset');
		//delete_option('gfe_encrypt_decrypt_form_ubf');
		delete_site_option('gfe_encrypt_decrypt_user');
		delete_site_option('gfe_encrypt_decrypt');
		//delete_site_option('gfe_encrypt_decrypt_form');
		//delete_site_option('gfe_encrypt_decrypt_form_entries');
		//delete_site_option('gfe_encrypt_decrypt_form_fields');
		//delete_site_option('gfe_encrypt_decrypt_form_entry_paging');
		//delete_site_option('gfe_encrypt_decrypt_form_paging_offset');
		//delete_site_option('gfe_encrypt_decrypt_form_ubf');
		echo('</div>');
	}
}

/*GLOBAL FORM ENCRYPTION SWITCH*/
function gfef_global_encryption($form_id) {
	?>
	<script type='text/javascript'>
		function gfef_remove_report() {
			var e = document.getElementById('add-remove-global-encryption-report');
			e.style.display = 'none';
		 }
	</script>
	<?php
	if(get_option('gfe_global_encryption_on') && is_numeric(get_option('gfe_global_encryption_on')) && get_option('gfe_global_encryption_encrypt_hide') && get_option('gfe_global_encryption_on_off')) {
		$form_object = GFAPI::get_form($form_id);
		$fields		 = '';
		$report		 = null;
		if ($form_object) {
			foreach ($form_object['fields'] as $field) {
			   if ($field->type === 'text' || $field->type === 'textarea' || $field->type === 'date' || $field->type === 'name' || $field->type === 'number' || $field->type === 'email' || $field->type === 'phone' || $field->type === 'website' || $field->type === 'address' || $field->type === 'select' || $field->type === 'radio' || $field->type === 'multiselect' || $field->type === 'checkbox' || $field->type === 'list' || $field->type === 'time') {
				   if (get_option('gfe_global_encryption_encrypt_hide') == 1) {
					   if (get_option('gfe_global_encryption_on_off') == 1) {
						   $field->hidevalueField 	= false;
						   $field->encryptField		= true;
						   $report		 			= 1;
					   }
					   if (get_option('gfe_global_encryption_on_off') == 2) {
						   $field->encryptField 	= false;
						   $report		 			= 2;
					   }
				   }
				   if (get_option('gfe_global_encryption_encrypt_hide') == 2) {
					   if (get_option('gfe_global_encryption_on_off') == 1) {
						   $field->hidevalueField 	= true;
						   $field->encryptField 	= false;
						   $report		 			= 3;
					   }
					   if (get_option('gfe_global_encryption_on_off') == 2) {
						   $field->hidevalueField 	= false;
						   $report		 			= 4;
					   }
				   }
				   $fields .= $field->id . ', ';
			   }
			}
			$result = GFAPI::update_form($form_object);

			switch ($report) {
				case 1:
					echo('<div id="add-remove-global-encryption-report" style="max-width: 790px; background-color: #ffffff; border-left: 4px solid #4ecd33; padding: 15px; margin: 10px 10px 10px 0px; position: relative; -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1); box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);"><a href="#" style="position: absolute; top: 10px; right: 15px" onClick="gfef_remove_report();">close</a><p><b>ENCRYPTION TURNED ON FOR ALL SUPPORTED FIELDS<img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="12" width="12"> :</b><p><p><b>Form ID:</b> ' . get_option('gfe_global_encryption_on') . '</p><p><b>Supported Field IDs:</b> ' . $fields . '</p></div>');
					break;

				case 2:
					echo('<div id="add-remove-global-encryption-report" style="max-width: 790px; background-color: #ffffff; border-left: 4px solid #4ecd33; padding: 15px; margin: 10px 10px 10px 0px; position: relative; -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1); box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);"><a href="#" style="position: absolute; top: 10px; right: 15px" onClick="gfef_remove_report();">close</a><p><b>ENCRYPTION TURNED OFF FOR ALL SUPPORTED FIELDS<img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="12" width="12"> :</b><p><p><b>Form ID:</b> ' . get_option('gfe_global_encryption_on') . '</p><p><b>Supported Field IDs:</b> ' . $fields . '</p></div>');
					break;

				case 3:
					echo('<div id="add-remove-global-encryption-report" style="max-width: 790px; background-color: #ffffff; border-left: 4px solid #4ecd33; padding: 15px; margin: 10px 10px 10px 0px; position: relative; -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1); box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);"><a href="#" style="position: absolute; top: 10px; right: 15px" onClick="gfef_remove_report();">close</a><p><b>HIDE FIELD VALUE TURNED ON FOR ALL SUPPORTED FIELDS<img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="12" width="12"> :</b><p><p><b>Form ID:</b> ' . get_option('gfe_global_encryption_on') . '</p><p><b>Supported Field IDs:</b> ' . $fields . '</p></div>');
					break;

				case 4:
					echo('<div id="add-remove-global-encryption-report" style="max-width: 790px; background-color: #ffffff; border-left: 4px solid #4ecd33; padding: 15px; margin: 10px 10px 10px 0px; position: relative; -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1); box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);"><a href="#" style="position: absolute; top: 10px; right: 15px" onClick="gfef_remove_report();">close</a><p><b>HIDE FIELD VALUE TURNED OFF FOR ALL SUPPORTED FIELDS<img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="12" width="12"> :</b><p><p><b>Form ID:</b> ' . get_option('gfe_global_encryption_on') . '</p><p><b>Supported Field IDs:</b> ' . $fields . '</p></div>');
					break;
			}
		} else {
			echo ('<div id="add-remove-global-encryption-report" style="max-width: 790px; background-color: #ffffff; border-left: 4px solid #4ecd33; padding: 15px; margin: 10px 10px 10px 0px; position: relative; -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1); box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);"><a href="#" style="position: absolute; top: 10px; right: 15px" onClick="gfef_remove_report();">close</a><p><b>INVALID FORM ID</b></p></div>');
		}
		delete_option('gfe_global_encryption_on');
		delete_option('gfe_global_encryption_encrypt_hide');
		delete_option('gfe_global_encryption_on_off');
		delete_site_option('gfe_global_encryption_on');
		delete_site_option('gfe_global_encryption_encrypt_hide');
		delete_site_option('gfe_global_encryption_on_off');
	}
}

/*MERGE TAG FILTERING*/ // PRE FILTERED VALUE from gform_get_input_value() 
add_filter("gform_merge_tag_filter", "gfe_merge_tag_filter", 11, 5);
function gfe_merge_tag_filter($value, $merge_tag, $options, $field, $raw_value) {
	$intitial_value		= $value;
	$decrypt_all_fields = false;
	$form_id 			= $field->formId;
    $form               = GFAPI::get_form($form_id);
	$field_id 			= $field->id;
	$field_user_owned 	= $field->gfedecryptownerField;
    $review             = false;
    $delete_entries		= get_option('gfe_delete_entry');
	if ($merge_tag == 'all_fields') {
		$include 	= preg_match("/include\[(.*?)\]/", $options, $included);
		$includes 	= explode(',', rgar( $included, 1 ));
		$exclude 	= preg_match("/exclude\[(.*?)\]/", $options, $excluded);
		$excludes 	= explode(',', rgar( $excluded, 1));
		$log 		= "gfe_merge_tag_filter(): {$field->label}({$field->id} - {$field->type}) - ";

		if ($include && in_array($field->id, $includes)) {
			switch ($field->type) {
				case 'html' :
					$value = $field->content;
					break;
				case 'section' :
					$value .= sprintf( '<tr bgcolor="#f6f6f6">
											<td width="20">&nbsp;</td>
											<td><font style="font-family:sans-serif; font-size:12px;">%s</font></td>
									   </tr>', $field->description);
					break;
				case 'signature' :
					$url 	= gf_signature()->get_signature_url($raw_value);
					$value	= "<img alt='signature' src='{$url}'/>";
					break;
			}
			//GFCommon::log_debug($log . 'included.');
		}
        if ($include && in_array('2334h8gfafentryreview', $includes)) {
            $review = true;
        }
		
		if ($exclude && in_array($field->id, $excludes)) {
			//GFCommon::log_debug($log . 'excluded.');
			return false;
		}
	} 
	
	//delete file links if files for deleted files
    if ($field->type === 'fileupload' && $value) {
        $delete_file_uploads 	= get_option('gfe_delete_file_uploads');
        $delete_files			= explode(',', $delete_file_uploads);
        $delete_entry		 	= explode(',', $delete_entries);
        if ((in_array($form_id, $delete_entry) || in_array($form_id, $delete_files))) {
            $value = false;
        }
    }
    //remove signatures if sigantures deleted
    //if ($form['gfafreviewpage'] && !(GFFormDisplay::get_current_page($form['id']) != GFFormDisplay::get_max_page_number($form) + 1)) {
    if ($field->type === 'signature' && $value) {
        $delete_signature       = get_option('gfe_delete_signature');
        $delete_signature_forms = explode(',', $delete_signature);
        $delete_sig_from_forms  = array();
        foreach($delete_signature_forms as $delete_signature_form_id_search) {
            $delete_signature_form_id = explode(':', $delete_signature_form_id_search)[0];
            array_push($delete_sig_from_forms, $delete_signature_form_id);
        }
        $delete_entry		 	= explode(',', $delete_entries);
        if (in_array($form_id, $delete_entry) || in_array($form_id, $delete_sig_from_forms)) {
            $value = false;
        }
    }
    //}


	if (($value || $value === 0 || $value === '0')) {
	// Check if the field is encrypted or hidden and "merge tag filter" is on - currently passes only encrypted restricted display to conceal actual encryption or not
		if (!get_option('gfe_mergefilter')) {
			if ($field->encryptField == true) {
				$value = (esc_html__(get_option('gfe_restricted')));
			} 
			if ($field->hidevalueField == true) {
				$value = (esc_html__(get_option('gfe_restricted')));
			}
		}
		
		$field_mask = gfef_check_masks($form_id, $field_id, $intitial_value, 'M');
		if ($field_mask && !$field_user_owned && $field->type != 'list') {
			$value = $field_mask;
		}
		if ($field->type == 'list' && ($field->encryptField == true || $field->hidevalueField == true)) { //masking is built in from raw_value but returned through to check for merge tag validity
			$value = gfef_list_restrict($raw_value, false, get_option('gfe_restricted'), $form_id, $field_id, 'M');
			return GFCommon::get_lead_field_display($field, $value, false, true, 'html');
		}
		return $value;
	}
}

/*CUSTOM MERGE TAG FULL DECRYPTED AND ENCRYTPTED OUTPUT*/
if (get_option('gfe_pluginowl_licensed')) {
	add_filter('gform_replace_merge_tags', 'gfe_decrypted_merge_tag', 10, 7);
}
function gfe_decrypted_merge_tag($text, $form, $entry, $url_encode, $esc_html, $nl2br, $format) {
	$gfef_decrypted_merge_tags 			= null;
	if (get_option('gfe_decrypt_merge_tags')) {
		$gfef_decrypted_merge_tags 		= get_option('gfe_decrypt_merge_tags');
		$gfef_decrypted_merge_tags 		= explode(',', $gfef_decrypted_merge_tags);
	}
	
	if ($gfef_decrypted_merge_tags && $form && $text) {
		foreach ($gfef_decrypted_merge_tags as $gfef_decrypt_merge_tag) {
            if (!$gfef_decrypt_merge_tag) {
                    continue;
                }
			$value 					= false;
			$gfef_decrypt_merge_tag	= trim($gfef_decrypt_merge_tag);
			$gfef_decrypt_merge_tag	= explode(':', $gfef_decrypt_merge_tag);
			$tag_form_id 			= trim($gfef_decrypt_merge_tag[0]);
			$tag_field_id 			= trim($gfef_decrypt_merge_tag[1]);
			$tag_encrypted_output	= count($gfef_decrypt_merge_tag) > 2 ? trim($gfef_decrypt_merge_tag[2]) : false;
			$form_id 				= rgar($form, 'id');
			$entry_id				= rgar($entry, 'id');
			
			if ($tag_form_id == $form_id || $tag_form_id == 'ALL') {
				if ($tag_field_id === "ALL" || $tag_field_id === "ALL+" || $tag_field_id === 'ANY') {
					$print_value	= '';
					$print_value   .= '<table style="width: 99%;
										border: 1px solid #eeeeee;
										border-collapse: collapse;
										-webkit-border-horizontal-spacing: 0px !important;
										-webkit-border-vertical-spacing: 1px;
										background-color: rgb(234, 234, 234);">
										<tbody style="display: table-row-group;
										vertical-align: middle;
										-webkit-border-horizontal-spacing: 0px !important;">';
					
					foreach ($form['fields'] as $field) {
						if (is_numeric($field->id)) {
							$value 				= null;
							$raw_field_value 	= null;
							$label 				= $field->label ? $field->label : '';
							$field_print 		= null;
							$inputs 			= $field->inputs && ($field->type != 'date' && $field->type != 'time') ? $field->inputs : false;
							$raw_input_values	= array();
                            
                            if (($field->type == 'html' && $field->gfeincludeMergetagField && $tag_field_id === "ALL+" && $tag_field_id !== "ANY") && !GFCommon::is_section_empty($field, $form, $entry)) {
                            $print_value .= '<tr style="-webkit-border-vertical-spacing: 0px;
															padding-left: 5px;
															background-color: rgb(234, 242, 250);
															border: none;
															color: rgb(34, 34, 34);
															direction: ltr;
															display: table-row;
															height: 25px;
															vertical-align: middle;">
												<td style="padding-left:5px;"><font style="font-family:sans-serif; font-size:12px; font-weight:bold;"><strong> ' . esc_html($label) . '</strong></font></td></tr>
												<tr style="display: table-row;
															-webkit-border-horizontal-spacing: 0px;
															direction: ltr;
															display: table-cell;
															vertical-align: inherit;
															border: none;
															background-color: rgb(255, 255, 255);
															width: 100%;
															padding: 5px 5px 5px 25px;">
												<td style="padding-left:20px;"><font style="font-family:sans-serif; font-size:12px;"> ' . $field->content . '</td></tr>
										   </tr>';
                            continue;
                            }
							if (($field->type == 'section' && $tag_field_id === "ALL+" && $tag_field_id !== "ANY") && !GFCommon::is_section_empty($field, $form, $entry)) {
								$print_value .= '<tr style="-webkit-border-vertical-spacing: 0px;
															padding: 5px;
															background-color: #eeeeee;
															border: none;
															color: rgb(34, 34, 34);
															direction: ltr;
															display: table-row;
															height: 25px;
															vertical-align: middle;">
												<td style="padding: 5px; border-bottom: 1px solid #cdcdcd; border-top: 1px solid #cdcdcd;"><font style="font-family:sans-serif; font-size:12px;font-weight:bold;"><strong> ' . esc_html($label) . '</strong></font></td>
												</tr>';
								continue;
							}
                            if (($field->type == 'signature' && $tag_field_id === "ALL+" && $tag_field_id !== "ANY") && rgar($entry, $field->id)) {
                                //remove signatures if sigantures deleted
                                $delete_signature       = get_option('gfe_delete_signature');
                                $delete_signature_forms = explode(',', $delete_signature);
                                $delete_sig_from_forms  = array();
                                foreach($delete_signature_forms as $delete_signature_form_id_search) {
                                    $delete_signature_form_id = explode(':', $delete_signature_form_id_search)[0];
                                    array_push($delete_sig_from_forms, $delete_signature_form_id);
                                }
                                $delete_entry		 	= explode(',', $delete_entries);
                                if (in_array($form_id, $delete_entry) || in_array($form_id, $delete_sig_from_forms)) {
                                    continue;
                                }
                                $url 	        = gf_signature()->get_signature_url(rgar($entry, $field->id));
                                $signaturevalue	= '<a href="' . $url . '" target="_blank" title="Click to view"><img alt="signature" src="' . $url . '" width="100"/></a>';
								$print_value   .= '<tr style="-webkit-border-vertical-spacing: 0px;
															padding-left: 5px;
															background-color: rgb(234, 242, 250);
															border: none;
															color: rgb(34, 34, 34);
															direction: ltr;
															display: table-row;
															height: 25px;
															vertical-align: middle;">
												<td style="padding-left:5px;"><font style="font-family:sans-serif; font-size:12px; font-weight:bold;"><strong> ' . esc_html($label) . '</strong></font></td></tr>
												<tr style="display: table-row;
															-webkit-border-horizontal-spacing: 0px;
															direction: ltr;
															display: table-cell;
															vertical-align: inherit;
															border: none;
															background-color: rgb(255, 255, 255);
															width: 100%;
															padding: 5px 5px 5px 25px;">
												<td style="padding-left:20px;"><font style="font-family:sans-serif; font-size:12px;"> ' . $signaturevalue . '</td></tr>
										   </tr>';
								continue;
							}                                

							if ($inputs) {
								foreach ($inputs as $input) {
									if (rgar($entry, $input['id'])) {
										$raw_field_input_value = gfef_get_raw_field_value($entry_id, $input['id']);
										$raw_input_values[$input['id']] = $raw_field_input_value;
									}
								}
							} else {
								if (rgar($entry, $field->id)) {
									$raw_field_value = gfef_get_raw_field_value($entry_id, $field->id);
								} else if ($tag_field_id !== "ANY") {
									continue;
								}
							}

							if ($raw_input_values) {
								foreach ($raw_input_values as $input_id => $raw_input_value) {
									$add_value 			= null;
									if (($tag_field_id === "ALL" && (substr($raw_input_value, 0, 11) === 'GFEncrypt: ' || $field->hidevalueField == true || $field->encryptField == true)) || $tag_field_id === "ALL+" || $tag_field_id === 'ANY') {
										$add_value 		= gfef_decrypt($raw_input_value);
										$user_owned 	= substr($add_value, 0, 8);
										if ($user_owned === 'GFEFU[[[') {
											$add_value 	= gfef_get_user_owned_value($add_value);
										}
										if ($tag_encrypted_output === 'U') {
											$add_value	= gfef_decrypt_field($raw_input_value, $entry, $field, $field->id);
										}
										if ($tag_encrypted_output === 'X') {
											if (substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
												$add_value	= $raw_field_value;
											} else {
												$add_value	= gfef_encrypt($raw_field_value);
											}
										}
										if ($field->type === 'list') {
											if ($tag_encrypted_output === 'X') {
												if (substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
													$add_value	= $raw_field_value;
												} else {
													$add_value	= gfef_encrypt($raw_field_value);
												}
											} else {
												$add_value 	= GFCommon::get_lead_field_display($field, $add_value, $entry['currency'], true, 'html');
											}
										}
										if ($field->type === 'date') {
											if ($tag_encrypted_output === 'X') {
												if (substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
													$add_value	= $raw_field_value;
												} else {
													$add_value	= gfef_encrypt($raw_field_value);
												}
											} else {
												$format		= $field->dateFormat ? $field->dateFormat : 'mdy';
												$add_value	= gfef_date_format($add_value, $format);
											}
										}
									} 
									if (($value || $value === 0 || $value === '0') && ($add_value || $add_value === 0 || $add_value === '0')) {		
										if ($field->type === 'name' || ($field->type === 'address' && substr($input_id, -1) == 5)) {
											$value .= ' ' . $add_value;
										} elseif ($field->type === 'address' && substr($input_id, -1) == 4) {
											$value .= ', ' . $add_value;									
										} else {
											$value .= '<br/>' . $add_value;
										}
									} else {
										$value .= $add_value;
									}
								}
							}

							if ($raw_field_value) {
								$add_value 			= null;
								if (($tag_field_id === "ALL" && (substr($raw_field_value, 0, 11) === 'GFEncrypt: ' || $field->hidevalueField == true || $field->encryptField == true)) || $tag_field_id === "ALL+" || $tag_field_id === 'ANY') {
									$add_value 		= gfef_decrypt($raw_field_value);
									$user_owned 	= substr($add_value, 0, 8);
									if ($user_owned === 'GFEFU[[[') {
										$add_value	= gfef_get_user_owned_value($add_value);
									}
									if ($tag_encrypted_output === 'U') {
										$add_value	= gfef_decrypt_field($raw_field_value, $entry, $field, $field->id);
									}
									if ($tag_encrypted_output === 'X') {
										if (substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
											$add_value	= $raw_field_value;
										} else {
											$add_value	= gfef_encrypt($raw_field_value);
										}
									}
									if ($field->type === 'list') {
										if ($tag_encrypted_output === 'X') {
											if (substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
												$add_value	= $raw_field_value;
											} else {
												$add_value	= gfef_encrypt($raw_field_value);
											}
										} else {
											$add_value 	= GFCommon::get_lead_field_display($field, $add_value, $entry['currency'], true, 'html');
										}
									}
									if ($field->type === 'date') {
										if ($tag_encrypted_output === 'X') {
											if (substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
												$add_value	= $raw_field_value;
											} else {
												$add_value	= gfef_encrypt($raw_field_value);
											}
										} else {
											$format		= $field->dateFormat ? $field->dateFormat : 'mdy';
											$add_value	= gfef_date_format($add_value, $format);
										}
									}
								} 
								if (($value || $value === 0 || $value === '0') && ($add_value || $add_value === 0 || $add_value === '0')) {								
									$field->type === 'name' ? $value .= ' ' . $add_value : $value .= '<br/>' . $add_value;
								} else {
									$value .= $add_value;
								}
							}

							//delete file links if files for deleted files
							$delete_file_uploads 	= get_option('gfe_delete_file_uploads');
							$delete_entries		 	= get_option('gfe_delete_entry');
							$delete_files			= explode(',', $delete_file_uploads);
							$delete_entry		 	= explode(',', $delete_entries);
							if ((in_array($form_id, $delete_entry) || in_array($form_id, $delete_files)) && $field->type === 'fileupload') {
								continue;
							} else if ($field->type === 'fileupload') {
								$value = GFCommon::get_lead_field_display($field, $value, $entry['currency'], true, 'html');
							}
                
							//FIELD ID = ANY
							if ($tag_field_id === 'ANY') {
								if ($value || $value === 0 || $value === '0') {
									$any_field_value = $value;
								} else {
									$any_field_value = '';
								}
								$gfef_merge_tag = '{gfef_decrypt_' . $field->id . '}';
								if ($tag_encrypted_output === 'U') {
									$gfef_merge_tag = '{gfef_decrypt_user_' . $field->id . '}';
								}
								if ($tag_encrypted_output === 'X') {
									$gfef_merge_tag = '{gfef_encrypt_' . $field->id . '}';
								}
								$text 			= str_replace($gfef_merge_tag, $any_field_value, $text);
								continue;
							}

							if ($value || $value === 0 || $value === '0') {
							$print_value .= '<tr style="-webkit-border-vertical-spacing: 0px;
															padding-left: 5px;
															background-color: rgb(234, 242, 250);
															border: none;
															color: rgb(34, 34, 34);
															direction: ltr;
															display: table-row;
															height: 25px;
															vertical-align: middle;">
												<td style="padding-left:5px;"><font style="font-family:sans-serif; font-size:12px; font-weight:bold;"><strong> ' . $label . '</strong></font></td></tr>
												<tr style="display: table-row;
															-webkit-border-horizontal-spacing: 0px;
															direction: ltr;
															display: table-cell;
															vertical-align: inherit;
															border: none;
															background-color: rgb(255, 255, 255);
															width: 100%;
															padding: 5px 5px 5px 25px;">
												<td style="padding-left:20px;"><font style="font-family:sans-serif; font-size:12px;"> ' . $value . '</td></tr>
										   </tr>';
							}
						}
					}
					
					$print_value .= '</tbody></table>';
					$gfef_merge_tag = '{gfef_decrypt_' . $tag_field_id . '}';
					if ($tag_encrypted_output === 'U') {
						$gfef_merge_tag = '{gfef_decrypt_' . $tag_field_id . '_USER}';
					}
					$text 			= str_replace($gfef_merge_tag, $print_value, $text);
					$print_value	= null;
				}
				
				$raw_field_value 	= null;
				if ($tag_field_id !== "ALL" && $tag_field_id !== "ALL+") {
					$raw_field_value 	= gfef_get_raw_field_value($entry_id, $tag_field_id);
				}
				
				if ($tag_encrypted_output && $tag_encrypted_output === 'X' && substr($raw_field_value, 0, 11) === 'GFEncrypt: ') {
					$value 			= $raw_field_value;
					$gfef_merge_tag = '{gfef_encrypt_' . $tag_field_id . '}';
					$text 			= str_replace($gfef_merge_tag, $value, $text );
				}
				
				if ($tag_encrypted_output && $tag_encrypted_output === 'X' && substr($raw_field_value, 0, 11) !== 'GFEncrypt: ') {
					$value 			= gfef_encrypt($raw_field_value, false);
					$gfef_merge_tag = '{gfef_encrypt_' . $tag_field_id . '}';
					$text 			= str_replace($gfef_merge_tag, $value, $text );
				}
				
				if ($tag_encrypted_output === 'U' && $tag_field_id !== "ALL" && $tag_field_id !== "ALL+") {
					$field 			= gfef_get_field($form, $tag_field_id);
					$value 			= gfef_decrypt_field($raw_field_value, $entry, $field, $tag_field_id);
					if ($field && $field->type === 'list') {
						$value = GFCommon::get_lead_field_display($field, $value, $entry['currency'], true, 'html');
					}
					$gfef_merge_tag = '{gfef_decrypt_user_' . $tag_field_id . '}';
					$text 			= str_replace($gfef_merge_tag, $value, $text );
				}
				
				if (!$tag_encrypted_output && $tag_field_id !== "ALL" && $tag_field_id !== "ALL+") {
					$field 			= gfef_get_field($form, $tag_field_id);
					$value 			= gfef_decrypt($raw_field_value);
					$user_owned 	= substr($value, 0, 8);
					if ($user_owned === 'GFEFU[[[') {
						$value = gfef_get_user_owned_value($value);
					}
					if ($field && $field->type === 'list') {
						$value = GFCommon::get_lead_field_display($field, $value, $entry['currency'], true, 'html');
					}
					if ($field && $field->type === 'date') {
						$format	= $field->dateFormat ? $field->dateFormat : 'mdy';
						$value	= gfef_date_format($value, $format);
					}
					$gfef_merge_tag = '{gfef_decrypt_' . $tag_field_id . '}';
					$text 			= str_replace($gfef_merge_tag, $value, $text );
				}
			}
		}
	}
	return $text;
}

//CUSTOM MERGE TAG ADDITIONS to Gravity Forms Admin
add_action('gform_admin_pre_render', 'gfef_add_decrypted_merge_tags');
function gfef_add_decrypted_merge_tags($form) {
    if (!GFCommon::is_form_editor() && !GFCommon::is_entry_detail() && !GFCommon::is_entry_detail_view() && !GFCommon::is_entry_detail_edit()) {
        $gfef_decrypted_merge_tags 	= false;
        $form_id 					= $form['id'];
        if (get_option('gfe_decrypt_merge_tags')) {
            $gfef_decrypted_merge_tags 		= get_option('gfe_decrypt_merge_tags');
            $gfef_decrypted_merge_tags 		= explode(',', $gfef_decrypted_merge_tags);
        }
        if ($gfef_decrypted_merge_tags && $form) {
            ?>
            <script type="text/javascript">
                gform.addFilter('gform_merge_tags', 'add_merge_tags');
                function add_merge_tags(mergeTags, elementId, hideAllFields, excludeFieldTypes, isPrepop, option) {
            <?php
            $gfef_add_tags = array();
            foreach ($gfef_decrypted_merge_tags as $gfef_decrypt_merge_tag) {
                if (!$gfef_decrypt_merge_tag) {
                    continue;
                }
                $gfef_decrypt_merge_tag	= trim($gfef_decrypt_merge_tag);
                $gfef_decrypt_merge_tag	= explode(':', $gfef_decrypt_merge_tag);
                $tag_form_id 			= trim($gfef_decrypt_merge_tag[0]);
                $tag_field_id 			= $gfef_decrypt_merge_tag[1];
                $tag_field_id_array     = explode('.', $tag_field_id);
                $tag_field_id           = trim($tag_field_id_array[0]);
                $tag_input_id           = isset($tag_field_id_array[1]) ? trim($tag_field_id_array[1]) : false;
                $tag_encrypted_output	= count($gfef_decrypt_merge_tag) > 2 ? trim($gfef_decrypt_merge_tag[2]) : false;
                if ($tag_form_id == $form_id || $tag_form_id == 'ALL') {
                    if (is_numeric($tag_field_id)) {
                        foreach ($form['fields'] as $field) {
                            $tag_input_exists = true;
                            $input_label      = false;
                            if ($tag_input_id && $field->inputs) { 
                                $tag_input_exists = false; 
                                $inputs = $field->inputs;
                                foreach ($inputs as $input) {
                                    if (strval($input['id']) == $tag_field_id . '.' . $tag_input_id) {
                                        $tag_input_exists = true;
                                        $tag_input_id     = '.' . $tag_input_id;
                                        $input_label      = $input['label'] ? $input['label'] : '';
                                    }
                                }
                            }
                            if ($field->id == $tag_field_id && $tag_input_exists) {
                                if (!$tag_encrypted_output) {
                                    ?>
                                    mergeTags["custom"].tags.push({tag: '{gfef_decrypt_<?php echo $tag_field_id; echo $tag_input_id ? $tag_input_id : ''; ?>}', label: 'DECRYPT: <?php echo $tag_field_id; ?> <?php echo $field->label ? $field->label  : ''; echo $input_label ? ' ('  . $input_label . ')' : ''; ?>'});
                                    <?php
                                }
                                if ($tag_encrypted_output === 'U') {
                                    ?>
                                    mergeTags["custom"].tags.push({tag: '{gfef_decrypt_user_<?php echo $tag_field_id; echo $tag_input_id ? $tag_input_id : ''; ?>}', label: 'DECRYPT: <?php echo $tag_field_id; ?> <?php echo $field->label ? $field->label : '';  echo $input_label ? ' ('  . $input_label . ')' : ''; ?>'});
                                    <?php
                                }
                                if ($tag_encrypted_output === 'X') {
                                    ?>
                                    mergeTags["custom"].tags.push({tag: '{gfef_encrypt_<?php echo $tag_field_id; echo $tag_input_id ? $tag_input_id : ''; ?>}', label: 'ENCRYPT: <?php echo $tag_field_id; ?> <?php echo $field->label ? $field->label : '';  echo $input_label ? ' ('  . $input_label . ')' : ''; ?>'});
                                    <?php
                                }
                            }
                        }
                    } else if (($tag_field_id == 'ALL' || $tag_field_id == 'ALL+') && !$tag_encrypted_output) {
                        ?>
                        mergeTags["custom"].tags.push({tag: '{gfef_decrypt_<?php echo $tag_field_id; ?>}', label: 'DECRYPT: <?php echo $tag_field_id == 'ALL' ? 'All Encrypted/Hidden Fields' : 'All Submitted Fields'; ?>'});
                        <?php
                    } else if (($tag_field_id == 'ALL' || $tag_field_id == 'ALL+') && $tag_encrypted_output === "U") {
                        ?>
                        mergeTags["custom"].tags.push({tag: '{gfef_decrypt_<?php echo $tag_field_id; ?>_USER}', label: 'USER DECRYPT:  <?php echo $tag_field_id == 'ALL' ? 'All Encrypted/Hidden Fields' : 'All Submitted Fields'; ?>'});
                        <?php
                    } else if (($tag_field_id == 'ANY') && !$tag_encrypted_output) {
                        foreach ($form['fields'] as $field) {
                            if (is_numeric($field->id) && ($field->type === 'text' || $field->type === 'textarea' || $field->type === 'date' || $field->type === 'name' || $field->type === 'number' || $field->type === 'email' || $field->type === 'phone' || $field->type === 'website' || $field->type === 'address' || $field->type === 'select' || $field->type === 'radio' || $field->type === 'multiselect' || $field->type === 'checkbox' || $field->type === 'list' || $field->type === 'time')) {
                                ?>
                                mergeTags["custom"].tags.push({tag: '{gfef_decrypt_<?php echo $field->id; ?>}', label: 'DECRYPT: <?php echo $field->id; ?> <?php echo $field->label; ?>'});
                                <?php
                            }
                        }
                    } else if (($tag_field_id == 'ANY') && $tag_encrypted_output === 'U') {
                        foreach ($form['fields'] as $field) {
                            if (is_numeric($field->id) && ($field->type === 'text' || $field->type === 'textarea' || $field->type === 'date' || $field->type === 'name' || $field->type === 'number' || $field->type === 'email' || $field->type === 'phone' || $field->type === 'website' || $field->type === 'address' || $field->type === 'select' || $field->type === 'radio' || $field->type === 'multiselect' || $field->type === 'checkbox' || $field->type === 'list' || $field->type === 'time')) {
                                ?>
                                mergeTags["custom"].tags.push({tag: '{gfef_decrypt_user_<?php echo $field->id; ?>}', label: 'USER DECRYPT: <?php echo $field->id; ?> <?php echo $field->label; ?>'});
                                <?php
                            }
                        }
                    } else if (($tag_field_id == 'ANY') && $tag_encrypted_output === 'X') {
                        foreach ($form['fields'] as $field) {
                            if (is_numeric($field->id) && ($field->type === 'text' || $field->type === 'textarea' || $field->type === 'date' || $field->type === 'name' || $field->type === 'number' || $field->type === 'email' || $field->type === 'phone' || $field->type === 'website' || $field->type === 'address' || $field->type === 'select' || $field->type === 'radio' || $field->type === 'multiselect' || $field->type === 'checkbox' || $field->type === 'list' || $field->type === 'time')) {
                                ?>
                                mergeTags["custom"].tags.push({tag: '{gfef_encrypt_<?php echo $field->id; ?>}', label: 'ENCRYPT: <?php echo $field->id; ?> <?php echo $field->label; ?>'});
                                <?php
                            }
                        }
                    }
                }
            }
            ?>
                return mergeTags;
            }
            </script>
            <?php
        }
        return $form;
    } else {
        return $form;
    }
}

//Attach file uploads to notification emails  -set any file upload fields class to "exclude" to remove standard link from notification
add_filter('gform_notification', 'gfef_notification_attachments', 10, 3);
function gfef_notification_attachments($notification, $form, $entry) {
	$gfef_upload_attachments 	 = get_option('gfe_attach_file_uploads');
    $gfef_signature_attatch      = get_option('gfe_delete_signature');
    $form_id 		 	         = rgar($form, 'id');
	if ($gfef_upload_attachments) {
		$upload_attachments 		= explode(',', $gfef_upload_attachments);
		//target specified form:notification names in option
		foreach($upload_attachments as $uploads) {
			$trimmed_uploads = array();
			$uploads 		 = strtolower(trim($uploads));
			array_push($trimmed_uploads, $uploads);
			foreach($trimmed_uploads as $form_notifications) {
				$form_notifications = explode(':', $form_notifications);
				$notification_form	= $form_notifications[0];
				$notification_name	= strtolower($notification["name"]);
				if(in_array($notification_name, $form_notifications) && $form_id == $notification_form) {

					$file_upload_fields = GFCommon::get_fields_by_type($form, array("fileupload"));

					if(!is_array($file_upload_fields)){
						continue;
					}
					$attachments = isset($notification['attachments']) ? $notification['attachments'] : array();
					$upload_root = RGFormsModel::get_upload_root();

					foreach($file_upload_fields as $field) {
						$url = $entry[$field['id']];
						if (empty($url)) {
							continue;
						} elseif ($field['multipleFiles']) {
							$uploaded_files = json_decode(stripslashes($url), true);
							foreach ($uploaded_files as $uploaded_file) {
								$attachment = preg_replace('|^(.*?)/gravity_forms/|', $upload_root, $uploaded_file);
								//GFCommon::log_debug($log . 'attached: ' . print_r($attachment, true));
								$attachments[] = $attachment;
							}
						} else {
							$attachment = preg_replace('|^(.*?)/gravity_forms/|', $upload_root, $url);
							//GFCommon::log_debug($log . 'attached: ' . print_r($attachment, true));
							$attachments[] = $attachment;
						}
					}
					$notification['attachments'] = $attachments;
				}
			}
		}
	}
    if ($gfef_signature_attatch && class_exists('GFSignature')) {
		$upload_attachments 		= explode(',', $gfef_signature_attatch);
		//target specified form:notification names in option
		foreach($upload_attachments as $uploads) {
			$trimmed_uploads = array();
			$uploads 		 = strtolower(trim($uploads));
			array_push($trimmed_uploads, $uploads);
			foreach($trimmed_uploads as $form_notifications) {
				$form_notifications = explode(':', $form_notifications);
				$notification_form	= $form_notifications[0];
				$notification_name	= strtolower($notification["name"]);
				if(in_array($notification_name, $form_notifications) && $form_id == $notification_form) {
                    $signature_fields = GFCommon::get_fields_by_type($form, array("signature"));
                    if(!is_array($signature_fields)){
                        return $notification;
                    }
                    $attachments = isset($notification['attachments']) ? $notification['attachments'] : array();
                    $folder      = GFSignature::get_signatures_folder();
                    foreach($signature_fields as $field) {
                        $url = isset($entry[$field['id']]) ? $entry[$field['id']] : false;
                        if ($url) {
                            $path_info      = pathinfo($url);
                            $filename       = $path_info['basename'];
                            $attachment     = $folder . $filename;
                            $newfilename    = 'Entry-' . $entry['id'] . '_SignatureField-' . $field->id . '.png';
                            rename($attachment, $folder . $newfilename);
                            $attachment     = $folder . $newfilename;
                            $attachments[]  = $attachment;
                        }
                    }
                    $notification['attachments'] = $attachments;
				}
			}
		}
	}
	return $notification;
}

/*AUTO DELETE ENTRY, FIELD DATA, OR FILES  + REMOVE USER IP ADDRESS + DELAYED ENCRYPTION*/
function gfef_delete_form_entry_files_ip($entry) {
	$form_id			 = $entry['form_id'];
	$form				 = GFAPI::get_form($form_id);
	$entry_id			 = rgar($entry, 'id');
	$delete_file_uploads = get_option('gfe_delete_file_uploads');
	$delete_entries		 = get_option('gfe_delete_entry');
	$delete_fields_data	 = get_option('gfe_delete_field_data');
	$delete_files		 = explode(',', $delete_file_uploads);
	$delete_entry		 = explode(',', $delete_entries);
	$delete_field_data	 = explode(',', $delete_fields_data);
	$remove_ip			 = get_option('gfe_delete_ip');
    $delete_signature    = get_option('gfe_delete_signature');
    $signature_fields    = GFCommon::get_fields_by_type($form, array("signature"));

	if (in_array($form_id, $delete_files) && !in_array($form_id, $delete_entry)) {
		$delete = GFFormsModel::delete_files($entry['id']);
		foreach ($entry as $key => &$value) {
			if (strstr($key, '.')){
				$key_base 	 = explode('.', $key);
				$key_base 	 = $key_base[0];
			} else {
				$key_base 	 = $key;
			}
			$field = gfef_get_field($form, $key_base);
			if ($field && $field->type === 'fileupload') {
				$entry[$key] 	= false;
			}
		}
		$removed = GFAPI::update_entry($entry);
		$result  = ($delete) ? "entry {$entry['id']} files deleted." : $delete;
		GFCommon::log_debug("GFAPI::delete_files() - files - form #{$form['id']}: " . print_r($result, true));
	}
	
	if (!function_exists('gfef_delayed_encrypt')) {
		function gfef_delayed_encrypt($form, $entry) {
			foreach ($entry as $key => &$value) {
				$field 			 =	false;
				if (strstr($key, '.')){
					$key_base 	 = explode('.', $key);
					$key_base 	 = $key_base[0];
				} else {
					$key_base 	 = $key;
				}
				$field = gfef_get_field($form, $key_base);
				if ($field && $field->delayedencryptField) {
					$value 			= gfef_encrypt_field_value('GFEncrypD: ' . $value, $entry, $field, $form);
					$entry[$key] 	= $value;
				}
			}
			$encrypt = GFAPI::update_entry($entry);
			$result = ($encrypt) ? "entry {$entry['id']} field data encrypted." : $encrypt;
			GFCommon::log_debug("GFAPI::update_entry() - form #{$form['id']}: " . print_r($result, true));
		}
	}
	gfef_delayed_encrypt($form, $entry);
	
	foreach ($delete_field_data as $field_data_to_delete) {
		$field_data_to_delete = explode(':', trim($field_data_to_delete));
		if ($field_data_to_delete[0] == $form_id) {
			$delete_fields_form_id = array_shift($field_data_to_delete);
			if (!empty($field_data_to_delete)) {
				foreach ($entry as $key => $value) {
					if (strstr($key, '.')){
						$key_base 	 = explode('.', $key);
						$key_base 	 = $key_base[0];
					} else {
						$key_base 	 = $key;
					}
					if (is_numeric($key_base) && in_array($key_base, $field_data_to_delete)) {
						$entry[$key] = '';
					}
				}
			}
			$delete = GFAPI::update_entry($entry);
			$result = ($delete) ? "entry {$entry['id']} field data deleted." : $delete;
			GFCommon::log_debug("GFAPI::update_entry() - form #{$form['id']}: " . print_r($result, true));
		}
	}
	if ($remove_ip) {
		$remove_ip_forms = explode(',', $remove_ip);
		if (in_array($form_id, $remove_ip_forms)) {
			$no_ip = GFAPI::update_entry_property($entry_id, 'ip', 'IP removed');
			$result = ($no_ip) ? "entry {$entry['id']} IP removed." : $no_ip;
			GFCommon::log_debug("GFAPI::update_entry_property() - form #{$form['id']}: " . print_r($result, true));
		}
	}
    //delete signatures
    if ($delete_signature && is_array($signature_fields)) {
		$delete_signature_forms = explode(',', $delete_signature);
        $delete_sig_from_forms  = array();
        foreach($delete_signature_forms as $delete_signature_form_id_search) {
            $delete_signature_form_id_search = trim($delete_signature_form_id_search);
            $delete_signature_form_id        = explode(':', $delete_signature_form_id_search)[0];
            array_push($delete_sig_from_forms, $delete_signature_form_id);
        }
		if (in_array($form_id, $delete_sig_from_forms)) {
            $folder      = GFSignature::get_signatures_folder();
            foreach($signature_fields as $field) {
                $url = isset($entry[$field->id]) ? $entry[$field->id] : false;
                if ($url) {
                    $result         = gf_signature()->delete_signature($entry_id, $field->id);
                    $path_info      = pathinfo($url);
                    $filename       = $path_info['basename'];
                    $newfilename    = 'Entry-' . $entry['id'] . '_SignatureField-' . $field->id . '.png';
                    $signature_file = $folder . $newfilename;
                    unlink($signature_file);
                }
            }
		}
	}
	if (in_array($form_id, $delete_entry)) {
		$delete = GFAPI::delete_entry($entry['id']);
		$result = ($delete) ? "entry {$entry['id']} deleted." : $delete;
		GFCommon::log_debug("GFAPI::delete_entry() - form #{$form['id']}: " . print_r($result, true));
	}
}
add_action('gform_after_submission', 'gfef_delete_active_form_entry_files', 99999999, 2);
function gfef_delete_active_form_entry_files($entry, $form) {
	$config = null;
	if (class_exists('GFUser')) {
		$config = GFUser::get_active_config($form, $entry);
	}
	if (!$config['is_active']) {
		gfef_delete_form_entry_files_ip($entry);
	}
}
add_action('gform_activate_user', 'gfef_delete_form_entry_files_after_activation', 15, 3);
function gfef_delete_form_entry_files_after_activation($user_id, $user_data, $signup_meta) {
	$entry = GFAPI::get_entry($signup_meta['lead_id']);
	gfef_delete_form_entry_files_ip($entry);
}
add_action('gform_user_updated','gfef_delete_form_entry_files_after_update', 15, 3);
function gfef_delete_form_entry_files_after_update($user_id, $config, $lead) {
	gfef_delete_form_entry_files_ip($lead);
}
add_action('gform_after_update_entry', 'gfef_encrypt_after_update_entry', 10, 3);
function gfef_encrypt_after_update_entry($form, $entry_id, $original_entry) {
	$entry = GFAPI::get_entry($entry_id);
    gfef_delete_form_entry_files_ip($entry);
}


/*REMOVE USER IP ADDRESS in PARTIAL AND INCOMPLETE ENTRIES*/
function gfef_partial_incomplete($form, $entry) {
	$entry_id			 = $entry['id'] ? $entry['id'] : '-NO ENTRY ID-' ;
	$remove_ip			 = get_option('gfe_delete_ip');

	if ($remove_ip) {
		$remove_ip_forms = explode(',', $remove_ip);
		if (in_array($form['id'], $remove_ip_forms)) {
			$entry['ip']	= 'IP removed';
			$no_ip 			= GFAPI::update_entry($entry);
			$result 		= ($no_ip) ? "entry {$entry_id} IP removed." : $no_ip;
			GFCommon::log_debug("GFAPI::update_entry() - form #{$form['id']}: " . print_r($result, true));
		}
	}
}

//saved incomplete entries
function gfef_delete_incomplete($submission, $resume_token, $form, $entry) {
	gfef_partial_incomplete($form, $entry);
}
add_action('gform_incomplete_submission_post_save', 'gfef_delete_incomplete', 10, 4);

//partial entries
function gfef_delete_partial($entry, $form) {
	gfef_partial_incomplete($form, $entry);
}
add_action('gform_partialentries_post_entry_saved', 'gfef_delete_partial', 10, 2);
add_action('gform_partialentries_post_entry_updated', 'gfef_delete_partial', 10, 2);

/*ENTRY LIST NATIVE SEARCH*/
add_filter('gform_search_criteria_entry_list', 'gfef_encrypted_search');
function gfef_encrypted_search($search_criteria) {
	if (isset($search_criteria['field_filters'])) {
		if (isset($search_criteria['field_filters']['0']['value']) && $search_criteria['field_filters']['0']['value'] != '') {
			$gfef_key 						= $search_criteria['field_filters']['0']['key'];
			$gfef_operator 					= $search_criteria['field_filters']['0']['operator'];
			$gfef_value 					= $search_criteria['field_filters']['0']['value'];
			$gfef_encryption_type			= get_option('gfe_encryption_method');
			$gfef_search_permission_list 	= get_option('gfe_user_search_permission_list');
			$gfef_search_permission_list	= explode(',', $gfef_search_permission_list);
			$gfe_current_user 				= wp_get_current_user();
			$gfe_current_username			= $gfe_current_user->user_login;
			$gfe_current_user_roles			= $gfe_current_user->roles;
			$gfe_user_role					= false;
			foreach ($gfef_search_permission_list as $role) {
				$role = trim($role);
				if (in_array($role, $gfe_current_user_roles, TRUE)) {
					$gfe_user_role = true;
				}
			}

			if ((in_array($gfe_current_username, $gfef_search_permission_list) || $gfe_user_role) && $gfef_encryption_type == 2) {
				$gfef_mcrypt_search_value 					= gfef_encrypt($gfef_value, false);
				$gfef_mcrypt_search_value_ucwords 			= gfef_encrypt(ucwords($gfef_value), false);			
				$gfef_mcrypt_search_value_ucfirst 			= gfef_encrypt(ucfirst($gfef_value), false);
				$gfef_mcrypt_search_value_strtoupper		= gfef_encrypt(strtoupper($gfef_value), false);
				$gfef_mcrypt_search_value_strtolower		= gfef_encrypt(strtolower($gfef_value), false);
				$mcrypt_cipher_name 						= MCRYPT_RIJNDAEL_128;
				$iv_size          							= mcrypt_get_iv_size($mcrypt_cipher_name, MCRYPT_MODE_CBC);
				$gfef_search_key							= substr($gfef_mcrypt_search_value, 11 + $iv_size, 10);
				$gfef_search_key_ucwords					= substr($gfef_mcrypt_search_value_ucwords, 11 + $iv_size, 10);
				$gfef_search_key_ucfirst					= substr($gfef_mcrypt_search_value_ucfirst, 11 + $iv_size, 10);
				$gfef_search_key_strtoupper					= substr($gfef_mcrypt_search_value_strtoupper, 11 + $iv_size, 10);
				$gfef_search_key_strtolower					= substr($gfef_mcrypt_search_value_strtolower, 11 + $iv_size, 10);
				$search_criteria['field_filters']['mode'] 	= 'any';
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_ucwords);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_ucfirst);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_strtoupper);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_strtolower);
			}

			if ((in_array($gfe_current_username, $gfef_search_permission_list) || $gfe_user_role) && $gfef_encryption_type == 1) {
				$ssl_cipher_name 							= "AES-256-CBC";
				$iv_size 		 							= openssl_cipher_iv_length($ssl_cipher_name);
				$gfef_mcrypt_search_value 					= gfef_encrypt($gfef_value, false);
				$gfef_mcrypt_search_value_ucwords 			= gfef_encrypt(ucwords($gfef_value), false);			
				$gfef_mcrypt_search_value_ucfirst 			= gfef_encrypt(ucfirst($gfef_value), false);
				$gfef_mcrypt_search_value_strtoupper		= gfef_encrypt(strtoupper($gfef_value), false);
				$gfef_mcrypt_search_value_strtolower		= gfef_encrypt(strtolower($gfef_value), false);
				$gfef_search_key							= substr($gfef_mcrypt_search_value, 11 + $iv_size, 10);
				$gfef_search_key_ucwords					= substr($gfef_mcrypt_search_value_ucwords, 11 + $iv_size, 10);
				$gfef_search_key_ucfirst					= substr($gfef_mcrypt_search_value_ucfirst, 11 + $iv_size, 10);
				$gfef_search_key_strtoupper					= substr($gfef_mcrypt_search_value_strtoupper, 11 + $iv_size, 10);
				$gfef_search_key_strtolower					= substr($gfef_mcrypt_search_value_strtolower, 11 + $iv_size, 10);
				$search_criteria['field_filters']['mode'] 	= 'any';
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_ucwords);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_ucfirst);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_strtoupper);
				$search_criteria['field_filters'][] 		= array('key' => $gfef_key, 'operator' => 'contains', 'value' => $gfef_search_key_strtolower);
			}

			return $search_criteria;
		}
		else {
			return $search_criteria;
		}
	} else {
		return $search_criteria;
	}
}

/*GFEF LIST ALL ROLES BY SLUG*/
function gfef_list_all_roles() {
	global $wp_roles;
	$print_output 	= '<div class="gfef-list-roles-slugs">Current available roles / slugs:<br/>';
	$all_roles		= $wp_roles->roles;
	foreach ($all_roles as $key => $value) {
		$role_slug = $key;
		$role_name = $value['name'];
		$print_output .= $role_name . ' / ' . $role_slug . '<br/>';
	}
	$print_output .= '</div>';
	return $print_output;
}

/*GFEF ENTRY LIST PAGE ENCRYPTION VERIFICATION NOTICE*/
add_action( 'gform_pre_entry_list', 'gfef_verification_notice' );
function gfef_verification_notice($form_id) {
	if (get_option('gfe_show_encryption')) {
		echo '<div style="width: auto; margin: 20px; background-color: #FFFFFF; border: 2px solid #00feff; border-radius: 7px; padding: 10px; min-height: 80px;"><img src="' . plugin_dir_url(__FILE__)  . 'images/GFEFicon80x80.jpg" height="80" width="80" style="display:inline-block; float:left; margin-right: 10px;"><p><b>Gravity Forms Encrypted Fields:</b></p>
		<p>"ENCRYPTION VERIFICATION MODE" is ACTIVE.<br/>
		Any encrypted data will display raw.<br/>Turn encryption verification mode off <a href="' . GFEF_ADMIN . '#gfefEVM">here</a> to resume normal operation.</p></div>';
	}
}

/*GFORMS ENCRYPTED FIELDS ADVANCED FIELD OPTIONS*/
add_action('gform_field_advanced_settings', 'gfe_encrypt_settings', 10, 2);
function gfe_encrypt_settings($position, $form_id) {
    //create settings on position 25 (right after Admin Field Label)
    if ($position == 50) {
        ?>
        <li class="encrypt_setting field_setting">
            <label for="field_encrypt_value" class="section_label">
                <?php
					_e('Encryption', 'gravityforms');
					echo ' <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener"><img src="' . plugin_dir_url(__FILE__)  . 'images/owl-small.png" height="13px" width="auto" style="display:inline-block;"></a>';
				?>
            </label>
			<?php
			if (is_array(get_option('gfe_pluginowl_licensed'))) { ?>
            <input type="radio" id="field_encrypt_value" name="encryptOption" onClick="SetFieldProperty('encryptField', this.checked);SetFieldProperty('hidevalueField', this.unchecked);SetFieldProperty('gfeoffvalueField', this.unchecked);" /> Encrypt field value <?php gform_tooltip( 'form_field_encrypt_value' ) ?>
			<?php } ?>
        </li>
        <li class="hidevalue_setting field_setting">
            <input type="radio" id="field_hidevalue_value" name="encryptOption" onClick="SetFieldProperty('hidevalueField', this.checked);SetFieldProperty('encryptField', this.unchecked);SetFieldProperty('gfeoffvalueField', this.unchecked);SetFieldProperty('delayedencryptField', this.unchecked);SetFieldProperty('gfedecryptownerField', this.unchecked);SetFieldProperty('gfedecryptownerField', this.unchecked);" /> Hide field value <?php gform_tooltip( 'form_field_hidevalue_value' ) ?>
        </li>
        <li class="gfeoffvalue_setting field_setting">
            <input type="radio" id="field_gfeoffvalue_value" name="encryptOption" onClick="SetFieldProperty('hidevalueField', this.unchecked);SetFieldProperty('encryptField', this.unchecked);SetFieldProperty('delayedencryptField', this.unchecked);SetFieldProperty('gfedecryptownerField', this.unchecked);SetFieldProperty('gfedecryptownerField', this.unchecked);" /> Off <?php gform_tooltip( 'form_field_gfeoffvalue_value' ) ?>
			<?php if (!is_array(get_option('gfe_pluginowl_licensed'))) {
					echo '<p>Plugin Unlicensed. You may only turn off encryption. <a href="' . GFEF_ADMIN . '">Register License.</a></p>'; 
				}
			?>
        </li>
		<li class="delayedencrypt_setting field_setting">
            <input type="checkbox" id="field_delayedencrypt_value" name="encryptDelayOption" onClick="SetFieldProperty('delayedencryptField', this.checked);SetFieldProperty('encryptField', this.checked);SetFieldProperty('hidevalueField', this.unchecked);SetFieldProperty('gfeoffvalueField', this.unchecked);" /> Process Feeds/Add-Ons before encrypting <?php 			gform_tooltip( 'form_field_delayedencrypt_value' ) ?>
			<div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-top: 12px;"></div>
        </li>
        <li class="decrypt_setting field_setting">
            <label for="field_decrypt_user_value">
                <?php _e('User/Role View Permission', 'gravityforms'); ?>
                <?php gform_tooltip('form_field_decrypt_user_value') ?>
            </label>
            <textarea rows="4" id="field_decrypt_user_value" style="width:100%; max-width: 278px" onKeyUp="SetFieldProperty('decryptFieldUsers', this.value);"/></textarea>
        </li>
        <li class="gfedecryptowneralso_setting field_setting">
            <input type="checkbox" id="field_gfedecryptowneralso_value" name="userOwnedOption" onClick="SetFieldProperty('gfedecryptowneralsoField', this.checked);" /> Original Submitting User View Permission <?php gform_tooltip('form_field_gfedecryptowneralso_value') ?>
            <br/>
            <div style="width: 100%; height: 0px; border-bottom: 1px solid #00feff; margin-top: 12px;"></div>
        </li>
        <li class="gfedecryptowner_setting field_setting">
            <input type="checkbox" id="field_gfedecryptowner_value" name="userOwnedOption" onClick="SetFieldProperty('gfedecryptownerField', this.checked);SetFieldProperty('encryptField', this.checked);SetFieldProperty('hidevalueField', this.unchecked);SetFieldProperty('gfeoffvalueField', this.unchecked);" /> User Owned Field <?php gform_tooltip('form_field_gfedecryptowner_value') ?>
        </li>
		<br/>
        <?php
    }
}
add_action('gform_field_advanced_settings', 'gfef_include_settings', 10, 2);
function gfef_include_settings($position, $form_id) {
    //create settings on position 25 (right after Admin Field Label)
    if ($position == 50) {
        ?>
        <li class="gfe_includeMergtag_setting field_setting">
            <label for="field_encrypt_value" class="section_label">
                <?php
					_e('GFEF Merge Tag Include', 'gravityforms');
					echo ' <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener"><img src="' . plugin_dir_url(__FILE__)  . 'images/owl-small.png" height="13px" width="auto" style="display:inline-block;"></a>';
				?>
            </label>
            <input type="checkbox" id="field_includeMergtag_value" name="includeMergetagOption" onClick="SetFieldProperty('gfeincludeMergetagField', this.checked);" /> Include in GFEF "ALL" type merge tags <?php gform_tooltip('form_field_gfeincludeMergetag_value') ?>
        </li>
		<br/>
        <?php
    }
}


//Add setting to fields of type         //https://docs.gravityforms.com/gf_field_list/
if (is_array(get_option('gfe_pluginowl_licensed'))) {
	add_action('gform_editor_js', 'gfe_editor_encrypt_script');
} else {
	add_action('gform_editor_js', 'gfe_editor_encrypt_script_locked');
}
function gfe_editor_encrypt_script_locked(){
    ?>
    <script type='text/javascript'>
		fieldSettings["text"] += ", .encrypt_setting";
		fieldSettings["textarea"] += ", .encrypt_setting";
		fieldSettings["date"] += ", .encrypt_setting";
		fieldSettings["name"] += ", .encrypt_setting";
		fieldSettings["number"] += ", .encrypt_setting";
		fieldSettings["email"] += ", .encrypt_setting";
		fieldSettings["phone"] += ", .encrypt_setting";
		fieldSettings["website"] += ", .encrypt_setting";
		fieldSettings["address"] += ", .encrypt_setting";
		fieldSettings["select"] += ", .encrypt_setting";
		fieldSettings["radio"] += ", .encrypt_setting";
		fieldSettings["multiselect"] += ", .encrypt_setting";
		fieldSettings["checkbox"] += ", .encrypt_setting";
		fieldSettings["list"] += ", .encrypt_setting";
        fieldSettings["time"] += ", .encrypt_setting";
		
		fieldSettings["text"] += ", .gfeoffvalue_setting";
		fieldSettings["textarea"] += ", .gfeoffvalue_setting";
		fieldSettings["date"] += ", .gfeoffvalue_setting";
		fieldSettings["name"] += ", .gfeoffvalue_setting";
		fieldSettings["number"] += ", .gfeoffvalue_setting";
		fieldSettings["email"] += ", .gfeoffvalue_setting";
		fieldSettings["phone"] += ", .gfeoffvalue_setting";
		fieldSettings["website"] += ", .gfeoffvalue_setting";
		fieldSettings["address"] += ", .gfeoffvalue_setting";
		fieldSettings["select"] += ", .gfeoffvalue_setting";
		fieldSettings["radio"] += ", .gfeoffvalue_setting";
		fieldSettings["multiselect"] += ", .gfeoffvalue_setting";
		fieldSettings["checkbox"] += ", .gfeoffvalue_setting";
		fieldSettings["list"] += ", .gfeoffvalue_setting";
        fieldSettings["time"] += ", .gfeoffvalue_setting";

        //binding to the load field settings event to initialize options
        jQuery(document).bind("gform_load_field_settings", function(event, field, form){
			jQuery("#field_gfeoffvalue_value").attr("checked", field["gfeoffvalueField"] == true);
        });
    </script>
    <?php
}
function gfe_editor_encrypt_script(){
    ?>
    <script type='text/javascript'>
        fieldSettings["text"] += ", .encrypt_setting";
		fieldSettings["textarea"] += ", .encrypt_setting";
		fieldSettings["date"] += ", .encrypt_setting";
		fieldSettings["name"] += ", .encrypt_setting";
		fieldSettings["number"] += ", .encrypt_setting";
		fieldSettings["email"] += ", .encrypt_setting";
		fieldSettings["phone"] += ", .encrypt_setting";
		fieldSettings["website"] += ", .encrypt_setting";
		fieldSettings["address"] += ", .encrypt_setting";
		fieldSettings["select"] += ", .encrypt_setting";
		fieldSettings["radio"] += ", .encrypt_setting";
		fieldSettings["multiselect"] += ", .encrypt_setting";
		fieldSettings["checkbox"] += ", .encrypt_setting";
		fieldSettings["list"] += ", .encrypt_setting";
        fieldSettings["time"] += ", .encrypt_setting";
		
		fieldSettings["text"] += ", .hidevalue_setting";
		fieldSettings["textarea"] += ", .hidevalue_setting";
		fieldSettings["date"] += ", .hidevalue_setting";
		fieldSettings["name"] += ", .hidevalue_setting";
		fieldSettings["number"] += ", .hidevalue_setting";
		fieldSettings["email"] += ", .hidevalue_setting";
		fieldSettings["phone"] += ", .hidevalue_setting";
		fieldSettings["website"] += ", .hidevalue_setting";
		fieldSettings["address"] += ", .hidevalue_setting";
		fieldSettings["select"] += ", .hidevalue_setting";
		fieldSettings["radio"] += ", .hidevalue_setting";
		fieldSettings["multiselect"] += ", .hidevalue_setting";
		fieldSettings["checkbox"] += ", .hidevalue_setting";
		fieldSettings["list"] += ", .hidevalue_setting";
        fieldSettings["time"] += ", .hidevalue_setting";
		
		fieldSettings["text"] += ", .gfeoffvalue_setting";
		fieldSettings["textarea"] += ", .gfeoffvalue_setting";
		fieldSettings["date"] += ", .gfeoffvalue_setting";
		fieldSettings["name"] += ", .gfeoffvalue_setting";
		fieldSettings["number"] += ", .gfeoffvalue_setting";
		fieldSettings["email"] += ", .gfeoffvalue_setting";
		fieldSettings["phone"] += ", .gfeoffvalue_setting";
		fieldSettings["website"] += ", .gfeoffvalue_setting";
		fieldSettings["address"] += ", .gfeoffvalue_setting";
		fieldSettings["select"] += ", .gfeoffvalue_setting";
		fieldSettings["radio"] += ", .gfeoffvalue_setting";
		fieldSettings["multiselect"] += ", .gfeoffvalue_setting";
		fieldSettings["checkbox"] += ", .gfeoffvalue_setting";
		fieldSettings["list"] += ", .gfeoffvalue_setting";
        fieldSettings["time"] += ", .gfeoffvalue_setting";
		
		fieldSettings["text"] += ", .delayedencrypt_setting";
		fieldSettings["textarea"] += ", .delayedencrypt_setting";
		fieldSettings["date"] += ", .delayedencrypt_setting";
		fieldSettings["name"] += ", .delayedencrypt_setting";
		fieldSettings["number"] += ", .delayedencrypt_setting";
		fieldSettings["email"] += ", .delayedencrypt_setting";
		fieldSettings["phone"] += ", .delayedencrypt_setting";
		fieldSettings["website"] += ", .delayedencrypt_setting";
		fieldSettings["address"] += ", .delayedencrypt_setting";
		fieldSettings["select"] += ", .delayedencrypt_setting";
		fieldSettings["radio"] += ", .delayedencrypt_setting";
		fieldSettings["multiselect"] += ", .delayedencrypt_setting";
		fieldSettings["checkbox"] += ", .delayedencrypt_setting";
		fieldSettings["list"] += ", .delayedencrypt_setting";
        fieldSettings["time"] += ", .delayedencrypt_setting";
		
		fieldSettings["text"] += ", .decrypt_setting";
		fieldSettings["textarea"] += ", .decrypt_setting";
		fieldSettings["date"] += ", .decrypt_setting";
		fieldSettings["name"] += ", .decrypt_setting";
		fieldSettings["number"] += ", .decrypt_setting";
		fieldSettings["email"] += ", .decrypt_setting";
		fieldSettings["phone"] += ", .decrypt_setting";
		fieldSettings["website"] += ", .decrypt_setting";
		fieldSettings["address"] += ", .decrypt_setting";
		fieldSettings["select"] += ", .decrypt_setting";
		fieldSettings["radio"] += ", .decrypt_setting";
		fieldSettings["multiselect"] += ", .decrypt_setting";
		fieldSettings["checkbox"] += ", .decrypt_setting";
		fieldSettings["list"] += ", .decrypt_setting";
        fieldSettings["time"] += ", .decrypt_setting";
		
		
		fieldSettings["text"] += ", .gfedecryptowneralso_setting";
		fieldSettings["textarea"] += ", .gfedecryptowneralso_setting";
		fieldSettings["date"] += ", .gfedecryptowneralso_setting";
		fieldSettings["name"] += ", .gfedecryptowneralso_setting";
		fieldSettings["number"] += ", .gfedecryptowneralso_setting";
		fieldSettings["email"] += ", .gfedecryptowneralso_setting";
		fieldSettings["phone"] += ", .gfedecryptowneralso_setting";
		fieldSettings["website"] += ", .gfedecryptowneralso_setting";
		fieldSettings["address"] += ", .gfedecryptowneralso_setting";
		fieldSettings["select"] += ", .gfedecryptowneralso_setting";
		fieldSettings["radio"] += ", .gfedecryptowneralso_setting";
		fieldSettings["multiselect"] += ", .gfedecryptowneralso_setting";
		fieldSettings["checkbox"] += ", .gfedecryptowneralso_setting";
		fieldSettings["list"] += ", .gfedecryptowneralso_setting";
        fieldSettings["time"] += ", .gfedecryptowneralso_setting";
		
		
		fieldSettings["text"] += ", .gfedecryptowner_setting";
		fieldSettings["textarea"] += ", .gfedecryptowner_setting";
		fieldSettings["date"] += ", .gfedecryptowner_setting";
		fieldSettings["name"] += ", .gfedecryptowner_setting";
		fieldSettings["number"] += ", .gfedecryptowner_setting";
		fieldSettings["email"] += ", .gfedecryptowner_setting";
		fieldSettings["phone"] += ", .gfedecryptowner_setting";
		fieldSettings["website"] += ", .gfedecryptowner_setting";
		fieldSettings["address"] += ", .gfedecryptowner_setting";
		fieldSettings["select"] += ", .gfedecryptowner_setting";
		fieldSettings["radio"] += ", .gfedecryptowner_setting";
		fieldSettings["multiselect"] += ", .gfedecryptowner_setting";
		fieldSettings["checkbox"] += ", .gfedecryptowner_setting";
		fieldSettings["list"] += ", .gfedecryptowner_setting";
        fieldSettings["time"] += ", .gfedecryptowner_setting";
        
        fieldSettings["html"] += ", .gfe_includeMergtag_setting";

        //binding to the load field settings event to initialize options
        jQuery(document).bind("gform_load_field_settings", function(event, field, form){
            jQuery("#field_encrypt_value").attr("checked", field["encryptField"] == true);
			jQuery("#field_hidevalue_value").attr("checked", field["hidevalueField"] == true);
			jQuery("#field_gfeoffvalue_value").attr("checked", field["gfeoffvalueField"] == true);
			jQuery("#field_delayedencrypt_value").attr("checked", field["delayedencryptField"] == true);
			jQuery("#field_decrypt_user_value").val(field["decryptFieldUsers"]);
			jQuery("#field_gfedecryptowneralso_value").attr("checked", field["gfedecryptowneralsoField"] == true);
			jQuery("#field_gfedecryptowner_value").attr("checked", field["gfedecryptownerField"] == true);
            jQuery("#field_includeMergtag_value").attr("checked", field["gfeincludeMergetagField"] == true);
        });
    </script>
    <?php
}

//GForm Field Settings Tooltips
add_filter('gform_tooltips', 'gfef_all_gfef_tooltips');
function gfef_all_gfef_tooltips($tooltips)  {
    $tooltips['form_field_encrypt_value'] = esc_html__("<h6>Encryption</h6><p>This option turns on database encryption for new submitted/updated values of this field, and allows for user/role based decrypted access through the admin interface.<br/>Turning this on will also hide existing unencrypted database values in admin from unauthorized users, but does not encrypt existing database field data. To encrypt existing database field values please use the encrypt/decrypt tool on the options setings page.</p><p><b><span style='color:red'>CAUTION: YOU ARE RESPOSIBLE FOR ANY LOST OR DAMAGED DATA.</span></p><p>This requires encryption to be on in <a href=" . admin_url( 'options-general.php?page=gravity-forms-encrypted-fields' ) . ">settings->GF Encrypted Fields</a>. Full instructions are in settings page.</b></p><p>It is imperitive that you DO NOT change this setting when affected form entries are being edited / updated. Turning this option on or off when restricted form data is being updated may result in the submitted data being overwritten with the restricted data display if the editing user does not have view permissions when editing!</p>");
    
    $tooltips['form_field_hidevalue_value'] = esc_html__("<h6>Hide Field Value</h6><p>This data safe option will turn off encryption of new submitted data for this field, gives user/role based view access and simply hides the field value in admin screen for unauthorized users.</p><p><b><span style='color:red'>CAUTION: YOU ARE RESPOSIBLE FOR ANY LOST OR DAMAGED DATA.</span></p><p>See <a href=" . admin_url( 'options-general.php?page=gravity-forms-encrypted-fields' ) . ">settings->GF Encrypted Fields</a> for full instructions.</b></p><p>It is imperitive that you DO NOT change this setting when affected form entries are being edited / updated. Turning this option on or off when restricted form data is being updated may result in the submitted data being overwritten with the restricted data display if the editing user does not have view permissions when editing!</p><p>Any previously submitted data that is already encrypted when this is turned on will still be encrypted and should be properly decrypted for users with permission, even though new submitted data will only be hidden, and not be encrypted when this is on.</p>");
    
    $tooltips['form_field_gfeoffvalue_value'] = esc_html__("<h6>Off</h6><p>This turns encrypt and hide field value off.</p>");
    
    $tooltips['form_field_delayedencrypt_value'] = esc_html__("<h6>Process Feeds/Add-Ons before encrypting</h6><p>This option delays encryption until AFTER the data has been processed by most add-ons and feeds allowing you to initially process the data through the add-ons and feeds (either during the original submission or an updated entry) normally/unencrypted and then immediately encrypt the data in the database after those processes are complete. The total delay time is roughly equivalent to the time it take to process the submission or update the entry.</p><p>'Encrypt field value' must be ON to use this.</p><p>When using this option, any unencrypted data in this field within entries will NOT be hidden in admin, although the unencrypted values will still be hidden in normal merge tag output. To encrypt previously existing database field values please use the '<a href='/wp-admin/options-general.php?page=gravity-forms-encrypted-fields/#encrypt-decrypt-form'>Encrypt/Decrypt Form Entries</a>' tool.</p><p><i>Please note that if you use this for WordPress User registration (or other WordPress stored) feed data, it is passed and stored unencrypted in the WordPress core tables for use by WordPress core, so if you are storing private/sensitive data unencrypted there it will not matter if it is also stored encrypted in the Gravity Forms tables. For this reason we strongly recommend that private/sensitive user/or other WordPress stored data should not be passed in the feed and stored by WordPress as user or other data, and instead stored only in Gravity Forms with encryption where the WordPress users can be given access to their own stored data and update/delete it through plugins such as Gravity View.</i></p>");
    
    $tooltips['form_field_decrypt_user_value'] = "<h6>User/Role View Permission</h6><p>Enter comma separated usernames and/or roles (use role slug) that should have access to view this encrypted field data as normally readable. If entering the slug for a Wordpress role all users of that role will have read permission for this field unless they are restricted by other permission settings. If left blank, all users can view the encrypted field data as readable. For no user access, enter 'lockdown' anywhere in the list.</p><p><b>See <a href=" . admin_url( 'options-general.php?page=gravity-forms-encrypted-fields' ) . ">settings->GF Encrypted Fields</a> for full instructions.</b></p><p>It is imperitive that you DO NOT change this setting when affected form entries are being edited / updated. Turning this option on or off when restricted form data is being updated may result in the submitted data being overwritten with the restricted data display if the editing user does not have view permissions when editing!</p><p>This is intended for users with only 'gravityforms_view_entries' permissions, and is NOT secure for users with gravityforms form editing permissions, as they can just add their own username here. To restrict form editing users, use the 'Limit User/Role View Permission Lists', 'User Lockout List', and 'User/Role Access List' under settings->GF Encrypted Fields.</p><p>" . gfef_list_all_roles() . "</p>";
    
    $tooltips['form_field_gfedecryptowneralso_value'] = "<h6>Original Submitting User View Permission</h6><p>If you check this box, the original logged in submitting user will also be given view permission to this field data as if their username was included in the 'User/Role View Permission' list. This however ONLY applies to the specific entries that the user has submitted, and does NOT grant them view permission to this field data for all entries.</p><p>This option does NOT limit view permissions to only the original submiting user like 'User Owned Field', but adds them in addition to the standard 'User/Role View Permission' list and the user is still subject to being denied view permission by higher level view permission rules such as the user being listed in the 'User Lockout List' or 'lockdown' listed in the 'User/Role View Permission' list above.</p><p>To only give the original submitting user access here and still leave view permissions intact for users/roles on the 'User Access List' for this field you can use this option and additionally enter a non-existant/non-possible username above (ex: n0user^?&-#$! ) to restrict all others from the individual field data if they are not already restricted globally by the 'User Lockout List'.</p><p style='color:red;'><b>Please be aware that if the original logged in user ALWAYS has view permission to this field data on thier own entries, that for logged in users ALL merge tag generated data on submission for this field such as confirmations and notifications for this form will be decrypted and readable since the submitting user has view permission to the field data UNLESS the Merge Tag Restricted Display Filter is left ON (NOT bypassed). In almost ALL use cases the Merge Tag Restricted Display Filter should be left ON (NOT bypassed) to prevent this from occuring, and decrypted merge tags can be used where needed in confirmations and/or notifications to give decrypted field data on submission.</b></p>";
    
    $tooltips['form_field_gfedecryptowner_value'] = "<h6>User Owned Field</h6><p>If you check this box, data encryption for this field will be turned on and only the logged in user who originally submitted the data while logged in will be able to view it as readable. This still applies even if this option is later turned off for a field. If a user who is not logged in submits data, it will still be encrypted and normal User View Permissions will apply, but non logged in users will NOT own the field data. This requires encryption to be on in <a href=" . admin_url( 'options-general.php?page=gravity-forms-encrypted-fields' ) . ">settings->GF Encrypted Fields</a>, and overrides all other User View Permissions.</p><p>If other users are able to update this data, the original user will still retain ownership.</p><p>If encryption is removed from this field for an entry, the user ownership is removed as well and normal view permissions will apply.</p><p style='color:red;'><b>Please be aware that if the original logged in user ALWAYS has view permission to this field data on thier own entries, that for logged in users ALL merge tag generated data on submission for this field such as confirmations and notifications for this form will be decrypted and readable since the submitting user has view permission to the field data UNLESS the Merge Tag Restricted Display Filter is left ON (NOT bypassed). In almost ALL use cases the Merge Tag Restricted Display Filter should be left ON (NOT bypassed) to prevent this from occuring, and decrypted merge tags can be used where needed in confirmations and/or notifications to give decrypted field data on submission.</b></p>";
    
    $tooltips['form_field_gfeincludeMergetag_value'] = "<h6>GFEF Merge Tag Include</h6><p>This will include the html label and content in your Gravity Forms Encrypted Fields 'ALL' type merge tags for this form.</p>";
    
    return $tooltips;
}

/*FORM EDITOR AUGMENT*/
add_filter('gform_field_content', 'gfef_form_editor_augment', 10, 2);	
function gfef_form_editor_augment ($field_content, $field) {
	if ($field->is_form_editor()) {
		if ($field->encryptField == true){
			$field_content = '<img src="' . plugin_dir_url(__FILE__) . 'images/locked-blue.png" height="12" width="12" style="position:absolute; left:6px; top:31px;">' . $field_content;
			return $field_content;
		}
		if ($field->hidevalueField == true){
			$field_content = '<img src="' . plugin_dir_url(__FILE__) . 'images/hidden-blue.png" height="12" width="12" style="position:absolute; left:6px; top:31px;">' . $field_content;
			return $field_content;
		}
		else {
			return $field_content;
		}
	}
	else {
		return $field_content;
	}
}

/*CREATE SETTINGS MENU*/
//encrypt settings password
if (get_option('gfe_settings_lock') && strlen(get_option('gfe_settings_lock')) >= 8 && strlen(get_option('gfe_settings_lock')) <= 16) {
	if (get_option('gfe_settings_lock') === get_option('gfe_settings_lock_verify')) {
		delete_option('gfe_settings_lock_verify');
		delete_site_option('gfe_settings_lock_verify');
		$pass_hash = password_hash(get_option('gfe_settings_lock'), PASSWORD_BCRYPT);
		update_option('gfe_settings_lock', $pass_hash);
		add_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menulocked');
	} else {
		add_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menu');
	}
	
	
}
if (get_option('gfe_settings_lock') && strlen(get_option('gfe_settings_lock')) <= 7) {
	remove_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menulocked', 9);
	add_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menu');
} 
if (strlen(get_option('gfe_settings_lock')) >= 32){
	$gfef_lock = get_option('gfe_settings_lock');
	$gfef_key  = get_option('gfe_settings_key');
	if (password_verify($gfef_key, $gfef_lock) || !get_option('gfe_settings_lock')) {
		add_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menu');
	} else {
		add_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menulocked');
	}
} 
if (!get_option('gfe_settings_lock')) {
	add_action('admin_menu', 'gfe_gravity_forms_encrypted_fields_menu');
}

//menu locked
function gfe_gravity_forms_encrypted_fields_menulocked() {
	//create new top-level menu
	add_options_page('gravity Forms Encrypted Fields Settings', 'GF Encrypted Fields', 'edit_users', 'gravity-forms-encrypted-fields', 'gravity_forms_encrypted_fields_settings_pagelocked');

	//call register settings function
	add_action( 'admin_init', 'register_gravity_forms_encrypted_fields_settings' );
}

//menu unlocked
function gfe_gravity_forms_encrypted_fields_menu() {
	//create new top-level menu
	add_options_page('gravity Forms Encrypted Fields Settings', 'GF Encrypted Fields', 'edit_users', 'gravity-forms-encrypted-fields', 'gravity_forms_encrypted_fields_settings_page');

	//call register settings function
	add_action( 'admin_init', 'register_gravity_forms_encrypted_fields_settings' );
}

function register_gravity_forms_encrypted_fields_settings() {
	//register our settings
	register_setting('gravity_forms_encrypted_fields_settings-license-group', 'gfe_pluginowl_licensed');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_pluginowl_remove_license');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encryption_method');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_delete_options');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_admin_only');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encryption_bypass');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_restricted');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_hidevalue');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_custom_data_search');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_show_encryption');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_decrypt_merge_tags');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_masking');
    register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_delete_ip');
    register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_delete_signature');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_delete_field_data');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_delete_entry');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_delete_file_uploads');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_attach_file_uploads');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_mergefilter');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_user_search_permission_list');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_limit_user_view_permission_list');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_user_lockout_list');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_user_lockout_override_list');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_website_key');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_website_key_regen');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encryption_key');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encryption_key_override');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_settings_lock');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_norecover_pass');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_global_encryption_on');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_global_encryption_on_off');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_global_encryption_encrypt_hide');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form_entries');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form_fields');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form_entry_paging');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form_paging_offset');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form_encrypt_all');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_form_ubf');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt_user');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_encrypt_decrypt');
	register_setting('gravity_forms_encrypted_fields_settings-group', 'gfe_settings_lock_verify');
	register_setting('gravity_forms_encrypted_fields_settings-key-group', 'gfe_settings_key');
}

//settings page locked
function gravity_forms_encrypted_fields_settings_pagelocked() {
?>
	<div class="wrap gfe-admin-page">
    <?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/GFEFicon80x80.jpg" height="80" width="80" style="display:inline-block; float:left; margin-right: 10px;">'; ?>
    <h1>Gravity Forms Encrypted Fields</h1>
    <p style="margin-top:0px;">by <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Plugin Owl</a></p><br/> 
		<form method="post" action="options.php" autocomplete="invalid">
        <?php settings_fields('gravity_forms_encrypted_fields_settings-key-group'); ?>
        <?php do_settings_sections('gravity_forms_encrypted_fields_settings-key-group'); ?>
        <?php if (get_option('gfe_settings_key')){echo ('<p style="color:red;">INCORRECT PASSWORD</p>');delete_option('gfe_settings_key');delete_site_option('gfe_settings_key');}?>
        <table class="form-table">
            <tr valign="top">
                    <th scope="row">Settings Page LOCKOUT Password</th>
                    <td><input type="text" name="gfe_settings_key" value="" style="width:100%; max-width: 600px;" maxlength="32" autocomplete="off"/>
                        <div id="gfe-settings-page-instructions" style="max-width:600px;">
                            <p><?php echo ' <img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="14" width="14">';?> Access to this page is restricted. Enter password to unlock the setings page.</p>
                        </div>
                    </td>
                </tr>
            </table>
            <?php submit_button("Unlock");?>
        </form>
    </div>
<?php
}

//settings page unlocked
function gravity_forms_encrypted_fields_settings_page() {
	//API LICENSING
	$pluginowl_license 			= get_option('gfe_pluginowl_licensed');
	$pluginowl_remove_license	= get_option('gfe_pluginowl_remove_license');
	$pluginowl_license_check 	= false;
	$pluginowl_license_status 	= 'NOT ACTIVE';
	$pluginowl_license_date		= current_time('Y/m/d H:i:s', 1);
	$pluginowl_license_request	= false;
	$pluginowl_license_status_message = 'None';
	if (is_array($pluginowl_license)) {
		$pluginowl_license_check 	= isset($pluginowl_license[0]) ? $pluginowl_license[0] : false;
		$pluginowl_license_date		= isset($pluginowl_license[1]) ? $pluginowl_license[1] : $pluginowl_license_date;
	}
	if ($pluginowl_license) {
		$pluginowl_license_request = wp_remote_request('https://www.pluginowl.com/wp-json/pluginowl-licensing/v1/license-manager', array(
			'method' => 'POST',
			'body'   => array(
				'pluginowl_license_API' 		  	=> 'API_REQUEST',
				'pluginowl_license_purchase_code' 	=> $pluginowl_license_check ? $pluginowl_license_check : $pluginowl_license,
				'pluginowl_license_website_name'  	=> get_bloginfo('name'),
				'pluginowl_license_web_address'		=> get_bloginfo('url'),
				'pluginowl_license_activation_date' => $pluginowl_license_date,
				'pluginowl_license_product_id' 		=> '.36eNVchaa0J5b0wb5nwvmjyUVHCX6zOqQP8kw.9GDPSWKMJ/AH8a$01$y2$',
				'pluginowl_remove_license' 			=> $pluginowl_remove_license ? $pluginowl_remove_license : ''
			)
		));
	}
	if ($pluginowl_license_request) {
		$pluginowl_license_response = wp_remote_retrieve_body($pluginowl_license_request);
		if (!is_wp_error($pluginowl_license_response)) {
			$pluginowl_license_response 		= json_decode($pluginowl_license_response);
			$pluginowl_response_status 		 	= $pluginowl_license_response->status;
			$pluginowl_license_status_message 	= $pluginowl_license_response->status_message;
			$pluginowl_license_return			= property_exists($pluginowl_license_response, 'license') ? $pluginowl_license_response->license : false;
			$pluginowl_license_activation_date	= property_exists($pluginowl_license_response, 'activation_date') ? $pluginowl_license_response->activation_date : false;
			$pluginowl_license_web_address		= property_exists($pluginowl_license_response, 'web_address') ? $pluginowl_license_response->web_address : false;
			$pluginowl_license_site_verify		= $pluginowl_license_web_address == get_bloginfo('url') ? true : false;
			if (!$pluginowl_license_site_verify && $pluginowl_response_status == 200) {
				$pluginowl_license_status_message 	= 'Invalid Website: website not registered';
				$pluginowl_response_status			= '400';
			}
			if ($pluginowl_response_status == 200 && $pluginowl_license_site_verify && ($pluginowl_license_return === $pluginowl_license || $pluginowl_license_return === $pluginowl_license_check)) {
				$pluginowl_new_license = array($pluginowl_license_return, $pluginowl_license_activation_date);
				update_option('gfe_pluginowl_licensed', $pluginowl_new_license);
				update_option('gfe_pluginowl_licensed_save', $pluginowl_new_license);
				if ($pluginowl_license_status_message === 'License Deregistered'){
					delete_option('gfe_pluginowl_licensed');
					delete_option('gfe_pluginowl_licensed_save');
					delete_option('gfe_pluginowl_remove_license');
					$pluginowl_license_status_message = '<p>License for ' . get_bloginfo('url') . ' Deregistered.</p><br/>';
				}
			} else if (!$pluginowl_license_status_message) {
				$pluginowl_license_status_message = 'Failed to connect. Please try again';
			} else {
				delete_option('gfe_pluginowl_licensed');
				delete_option('gfe_pluginowl_remove_license');
			}
		}
	}
	$pluginowl_license 	= get_option('gfe_pluginowl_licensed');
	if (!is_array($pluginowl_license) && (!get_option('gfe_encryption_method') || (get_option('gfe_encryption_method') && gfef_get_salt()))) {
		?>
		<div class="wrap gfe-admin-page" style="position:relative;">
			<?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/GFEFicon80x80.jpg" height="80" width="80" style="display:inline-block; float:left; margin-right: 10px;">'; ?>
			<h1 style="display: inline;">Gravity Forms Encrypted Fields</h1>
			<p style="margin-top:0px;">by <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Plugin Owl</a></p>
			<p style="margin-top:0px;"><a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Check out our other plugins!</a></p><br/>
			<script type='text/javascript'>
				function toggle_visibility(id) {
					 var e = document.getElementById(id);
					 if(e.style.display == 'block')
						e.style.display = 'none';
					 else
						e.style.display = 'block';
				 }
			</script>
			<form method="post" action="options.php" autocomplete="invalid">
				<?php settings_fields('gravity_forms_encrypted_fields_settings-license-group'); ?>
				<?php do_settings_sections('gravity_forms_encrypted_fields_settings-license-group'); ?>
				<table class="form-table">
					<tr valign="top">
						<th scope="row">LICENSE REGISTRATION</th>
						<td>
							<input type="text" name="gfe_pluginowl_licensed" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__((is_array($pluginowl_license) ? $pluginowl_license[0] : get_option('gfe_pluginowl_licensed_save')) ? get_option('gfe_pluginowl_licensed_save')[0] : false);} ?>" style="border: 2px solid #ddd; border-radius: 7px; width:100%; max-width: 600px;" autocomplete="off"/>
							<div id="pluginowl-license-request-page-instructions" style="max-width:600px;">
								<?php
								if ($pluginowl_license_request) {
									if (!is_wp_error($pluginowl_license_response)) {
										if ($pluginowl_license_status_message != 'Invalid Purchase Code: 0') {
											echo '<span style="color:red;">' . $pluginowl_license_status_message . '</span>';
										}
									} else {
										echo '<p>Connection Error.</p>';
									}
								}
								?>
								<p>Enter your valid Envato <b>purchase code</b> for this plugin to register the plugin license.</p><br/>
								<p><i>(The purchase code can be found in your profiles "downloads" by logging in at <a href="http://www.codecanyon.net" target="blank" rel="nofollow noopener">codecanyon.net</a>)<br/>
								If you had a web developer or other third party purchase this plugin for you please contact them for the purchase code.</i></p><br/>
								<p>To purchase an additional plugin license, visit <a href="https://codecanyon.net/item/gravity-forms-encrypted-fields/18564931" target="blank" rel="nofollow noopener">here</a>.</p><br/>
								<p>Your are allowed activation of the plugin on a <b>single</b> live website and a single test / development site for the registered main live site.</p>
								<p>If for any reason you must change this websites site url after activating you MUST deactivate the license first then reactivate after changing the website url.</p><br/>
							</div>
							<p>For more information on Envato Licensing please see <a href="https://codecanyon.net/licenses/standard" target="blank" rel="nofollow noopener">here.</a></p><br/>
							<p><i>Plugin settings access, field encryption options in the form editor, and all Decrypted Merge Tags are disabled.</i></p>
						</td>
					</tr>
				</table>
				<?php submit_button('Submit Purchase Code');?>        
			</form>
			<?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/owl-small.png" height="30" width="30" style="display:inline-block; float:left;">'; ?>
			<p><a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Plugin Owl</a></p>
		</div>
		<?php
	} else {
		$pluginowl_license_status = 'ACTIVE';
		///END LICENSING API
		
		// begin create salt
		if (gfef_get_salt() === false && !get_option('gfe_website_key')) {
			gfef_create_salt(false);
			gfef_delete_regen_salt();
			delete_option('gfe_website_key_regen');
		}
		//auto regen salt
		if (gfef_get_salt() == md5(wp_salt('nonce')) || get_option('gfe_website_key') == md5(wp_salt('nonce'))) {
			update_option('gfe_website_key_regen', 'auto');
			gfef_delete_regen_salt();
		} 
		// begin replace salt
		if (get_option('gfe_website_key')) {
			gfef_create_salt(esc_html__(get_option('gfe_website_key')));
			if (get_option('gfe_website_key') != md5(wp_salt('nonce'))) {
				gfef_create_regen_salt(esc_html__(get_option('gfe_website_key')));
			}
			update_option('gfe_website_key_regen', 'auto');
		}
		
		//get gfe version 
		function gfe_get_plugin_version() {
			$plugin_data = get_plugin_data(__FILE__);
			$plugin_version = $plugin_data['Version'];
			return $plugin_version;
		}
		//test environment for encryption
		function gfe_check_encryption_function() {
			if(function_exists('mcrypt_encrypt') && extension_loaded('mcrypt') || function_exists('openssl_encrypt') && extension_loaded('openssl')) {
				echo esc_html__('YES');
			} else {
				echo esc_html__('NO');
			}
		}
		function gfe_check_encryption_type($checking) {
			if (get_option('gfe_encryption_method')) {
				$gfe_method = get_option('gfe_encryption_method');
				if ($checking === 1) {
					if ($gfe_method == 1 || $gfe_method == 2) {
						echo esc_html__('YES');
					}
				} 
				if ($checking === 2) {
					if ($gfe_method == 1) {
						echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/check.png" height="14" width="14">' . esc_html__(' OpenSSL ON');
					} 
					if ($gfe_method == 2) {
						echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/check.png" height="14" width="14">' . esc_html__(' Mcrypt ON');
					}
				} 
			} else {
				if ($checking === 1) {
					echo esc_html__('NONE');
				}
				if ($checking === 2) {
					echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/x.png" height="14" width="14">' . esc_html__(' NO Encryption Type Selected');
				}
			}
		}
		function gfe_check_encryption() {
			$use_mcrypt 	= apply_filters('gform_use_mcrypt', function_exists('mcrypt_encrypt'));
			$use_openssl 	= function_exists('openssl_encrypt') && extension_loaded('openssl');

			if($use_openssl){
				echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/check.png" height="14" width="14"> ' . esc_html__('OpenSSL Encryption Supported!');
			} else {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('OpenSSL Encryption NOT Supported! Requires OpenSSL install on server.');
			}
			echo '<br/>';
			if($use_mcrypt){
				echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/check.png" height="14" width="14"> ' . esc_html__('Mcrypt Encryption Supported!');
			} else {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('Mcrypt Encryption NOT Supported! Requires mcrypt install on server.');
			}
		}
		function gfe_check_php() {
			if (version_compare( phpversion(), '5.6.0', '>=')) {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('PHP Version Supported!');
			} else {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('PHP Version Not Supported! Requires 5.6.0+');
			}
		}
		function gfe_check_wp_version() {
			if (version_compare(get_bloginfo('version'), '4.6.1', '>=')) {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('Wordpress Version Supported!');
			} else {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('Wordpress Version Not Supported! Requires 4.6.1+');
			}
		}
		function gfe_check_gf_version() {
			if (version_compare(GFCommon::$version, '2.0.7', '>=')) {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('Gravity Forms Version Supported!');
			} else {
				echo '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('Gravity Forms Version Not Supported! Requires 2.0.7+');
			}
		}
		function gfe_check_website_key($num) {
			if (gfef_get_salt() !== false && $num === 1) {
				return 'YES';
			} else if (gfef_get_salt() === false && $num === 1) {
				return 'NO';
			}
			if (gfef_get_salt() !== false && $num === 2) {
				$message = false;
				if (gfef_get_salt() == md5(wp_salt('nonce')) || get_option('gfe_website_key') == md5(wp_salt('nonce'))) {
					$message = '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('Auto unique website key generated and will automatically regenerate after plugin updates.');
				} 
				if ((get_option('gfe_website_key') || gfef_get_salt() != md5(wp_salt('nonce'))) && get_option('gfe_website_key') != md5(wp_salt('nonce'))) {
					$message = '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('A custom website key is being used and will attempt to automatically regenerate after plugin updates. You must check the custom website key has properly regenerated on this settings page immediately after any plugin update or reinstallation, or follow the manual plugin update instruction in the plugins readme.txt file to preserve the website key on upgrade/reinstallation..');
				}
				return $message;
			} else if (gfef_get_salt() === false && $num === 2) {
				return '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('STOP! Leave empty and save settings now to autogenerate the unique website key.');
			}
		}
		function gfe_check_encryption_key($num) {
			if (get_option('gfe_encryption_key') && $num === 1) {
				return 'YES';
			} else if (!get_option('gfe_encryption_key') && $num === 1) {
				return 'NO';
			}
			if (get_option('gfe_encryption_key') && $num === 2  && !get_option('gfe_encryption_bypass')) {
				return '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ' . esc_html__('Encryption password active.');
			} else if (!get_option('gfe_encryption_key') && $num === 2 && !get_option('gfe_encryption_bypass')) {
				return '<img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ' . esc_html__('Enter an encryption password.');
			} else if ($num === 2 && get_option('gfe_encryption_bypass')) {
				return '<img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="12" width="12"> ' . esc_html__('Not used: Encryption off.');
			}
		}
		function gfe_encryption_on($num) {
			if (get_option('gfe_encryption_bypass') && $num === 1) { 
				$gfe_encryption_status = 'NO';
			} else if (!get_option('gfe_encryption_bypass') && $num === 1) {
				$gfe_encryption_status = 'YES';
			} 
			if (get_option('gfe_encryption_bypass') && $num === 2) { 
				$gfe_encryption_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="14" width="14"> ENCRYPTION OFF</p>';
			} else if (!get_option('gfe_encryption_bypass') && $num === 2) {
				$gfe_encryption_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="14" width="14"> ENCRYPTION ON</p></div>';
			} 
			return $gfe_encryption_status;
		}
		function gfe_merge_tag_filter_on($num) {
			if (get_option('gfe_mergefilter') && $num === 1) { 
				$gfe_merge_tag_filter_status = 'NO';
			} else if (!get_option('gfe_mergefilter') && $num === 1) {
				$gfe_merge_tag_filter_status = 'YES';
			} 
			if (get_option('gfe_mergefilter') && $num === 2) { 
				$gfe_merge_tag_filter_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="14" width="14"> MERGE TAG FILTER OFF</p>';
			} else if (!get_option('gfe_mergefilter') && $num === 2) {
				$gfe_merge_tag_filter_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> MERGE TAG FILTER ON</p></div>';
			} 
			return $gfe_merge_tag_filter_status;
		}
		function gfe_page_lock_error() {
			if (get_option('gfe_settings_lock_verify') || ((get_option('gfe_settings_lock') && strlen(get_option('gfe_settings_lock')) >= 8 && strlen(get_option('gfe_settings_lock')) <= 16) && get_option('gfe_settings_lock') !== get_option('gfe_settings_lock_verify')) || (get_option('gfe_settings_lock') && strlen(get_option('gfe_settings_lock')) <= 7)) {
				echo '<p style="color:red;">PAGE IS NOT LOCKED! Settings Page LOCKOUT Passwords MUST MATCH and MUST BE 8-16 normal ASCII charachters or page will NOT lock.</p>';
				delete_option('gfe_settings_lock');
				delete_site_option('gfe_settings_lock');
				delete_option('gfe_settings_lock_verify');
				delete_site_option('gfe_settings_lock_verify');
			}
		}
		function gfef_not_deregistered_notice() {
			?>
			<div class="notice notice-error is-dismissible">
				<p><strong>The plugin license was NOT deactivated. Please try again.</strong></p>
			</div>
			<?php
		}
		if (get_option('gfe_pluginowl_remove_license')) {
			echo gfef_not_deregistered_notice();
			delete_option('gfe_pluginowl_remove_license');
		}


		?>
		<style>
			input[type="text"], 
			textarea {
				border-radius: 7px;
				border: 2px;
			}
			input[type="text"] {
				width:100%;
				border: 2px solid #ddd;
			}
			button {
				border: 2px solid #00feff;
				background: none;
				background-color: #ffffff;
				border-radius: 7px;
				padding: 5px;
				width: 100%;
				height: 40px;
				text-align: center;
				cursor: pointer;
				transition-duration: .25s;
			}
			button:hover {
				border: 2px solid #666666;
			}
			textarea.redtextarea {
				width: 100%;
				border: 2px solid red;
				border-radius: 7px;
			}
			textarea.greytextarea {
				width: 100%;
				border: 2px solid #dddddd;
				border-radius: 7px;
			}
			input.redtext {
				width: 100%;			
				border: 2px solid red;
				border-radius: 7px;
			}
			table th.settings {
				background-color:#FFFFFF;
				padding: 10px;
				text-align: center;
			}
			table tr.settingstr {
				border-top: 1px solid #666666;
			}
			table.form-table {
				max-width: 830px;
			}
			.center {
				 text-align: center;
			}
			table.encryptiontest tr:nth-child(even) {
				background-color: #eeeeee;
			}
			table.gfesystemcheck tr:nth-child(even) {
				background-color: #eeeeee;
			}
			table.form-table td {
				padding-right: 0;
			}
			.notes {
				font-size: 8px !important;
			}
		</style>
		<div class="wrap gfe-admin-page" style="position:relative;">
		<?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/GFEFicon80x80.jpg" height="80" width="80" style="display:inline-block; float:left; margin-right: 10px;">'; ?>
		<h1 style="display: inline;">Gravity Forms Encrypted Fields</h1><span> ver <?php echo gfe_get_plugin_version(); ?></span>
		<p style="margin-top:0px;">by <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Plugin Owl</a></p>
		<p style="margin-top:0px;"><a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Check out our other plugins!</a></p><br/>
		<p><?php
		if (!get_option('gfe_encryption_method')) {
			echo '<div style="max-width:580px; border: 1px solid #000000; padding: 10px; background-color: #FFFFFF;">
				<p style="color: red; font-style: bold;"><span style="font-size: 40px;">!!! STOP !!!</span><br/>NOTICE: YOU MUST FOLLOW THIS PLUGINS README FILE INSTRUCTIONS IF UPGRADING FROM A VERSION PREVIOUS TO 3.0 TO VERSION 3.0+</p>
				<p>Version 3.0+ bring significant changes to the encryption used and also strengthens the data security over previous versions.</p>
				<p> If you did not decrypt ALL previous entries before upgrading from ver< 3.0 to ver 3.0+ according to this versions readme file upgrade instructions. Please reinstall your previous version according to its readme file upgrade instructions and then refer to the this versions readme file upgrade instructions to proceed with decrypting ALL old entries before upgrading to version 3.0+ after upgrading.  These entries will be re-encrypted under new encryption in ver 3.0+ </p><br/>
				<p>If this is a brand new install you do NOT need to do anything, and can simply continue with setup by clicking the "Click Here For Full Setup Instructions" button below to read and follow the setup instructions.</p>
			</div><br/>';
			//set hidden displays on new install
			if (!get_option('gfe_restricted')) {
				update_option('gfe_restricted', 'Encrypted Field Restricted');
			}
			if (!get_option('gfe_hidevalue')) {
				update_option('gfe_hidevalue', 'Hide Field Value Restricted');
			}
		}
		?></p>
		<?php
		// add/remove form encryption
		if (get_option('gfe_encrypt_decrypt') && get_option('gfe_encrypt_decrypt_form')) {
			$encrypt_decrypt				= get_option('gfe_encrypt_decrypt') ? esc_html__(get_option('gfe_encrypt_decrypt')) : false;
			$encrypt_decrypt_form 			= get_option('gfe_encrypt_decrypt_form') ? intval(esc_html__(get_option('gfe_encrypt_decrypt_form'))) : false;
			$encrypt_decrypt_entries		= get_option('gfe_encrypt_decrypt_form_entries') ? esc_html__(get_option('gfe_encrypt_decrypt_form_entries')) : false;
			$encrypt_decrypt_fields			= get_option('gfe_encrypt_decrypt_form_fields') ? esc_html__(get_option('gfe_encrypt_decrypt_form_fields')) : false;
			$encrypt_decrypt_paging			= get_option('gfe_encrypt_decrypt_form_entry_paging') ? intval(esc_html__(get_option('gfe_encrypt_decrypt_form_entry_paging'))) : false;
			$encrypt_decrypt_paging_offset	= get_option('gfe_encrypt_decrypt_form_paging_offset') ? intval(esc_html__(get_option('gfe_encrypt_decrypt_form_paging_offset'))) : false;
			$gfe_current_user 				= wp_get_current_user();
			$encrypt_decrypt_user			= $gfe_current_user->user_login;
			update_option('gfe_encrypt_decrypt_user', $encrypt_decrypt_user);
			gfef_add_remove_encryption($encrypt_decrypt, $encrypt_decrypt_form, $encrypt_decrypt_entries, $encrypt_decrypt_fields, $encrypt_decrypt_paging, $encrypt_decrypt_paging_offset);
		}
		// global form encryption process
		if (get_option('gfe_global_encryption_on')) {
			gfef_global_encryption(get_option('gfe_global_encryption_on'));
		}
		// page locking error
		gfe_page_lock_error();
		?>
		<form method="post" action="options.php" autocomplete="invalid">
			<?php settings_fields('gravity_forms_encrypted_fields_settings-group'); ?>
			<?php do_settings_sections('gravity_forms_encrypted_fields_settings-group'); ?>
			<div class="gfef-sticky-save" style="position:fixed; top:20px; right:5px;"><?php submit_button();?></div>
			<div style="
				position: relative;
				max-width: 100%;
				background-color: #FFFFFF;
				border: 2px solid #666666;
				border-radius: 7px;
				padding: 15px;
				margin: 0;
				max-width: 795px;">
				<p><b><span style="color:red;">NOTICE:</span> You are responsible for and accept full resposibility for any loss of data through use of this plugin software and accept all risk involved.<p>You accept full responsibility for any data security compliance, and any loss of any type incurred by yourself or any other persons or entities involved in the management and/or  ownership of this website or its related data.</p>
				<p>Your use of this plugin software signifies your release and discharge of this software or any of its authors, owners, or representative entities from any and all liability, claim, demand or action relating to the use of this software.</p></b>
			</div>
			<table class="form-table">
				<tr id="gfe-notice" valign="top">
					<th scope="row"></th>
					<td>
						
					</td>
				</tr>
				
				<tr valign="top">
					<th scope="row">SETUP / OPERATION<br/>INSTRUCTIONS</th>
					<td>
						<div id="gfe-instructions" style="
						display: block;
						width: 100%;
						max-width: 600px;">
							<p><b>Click the "Click Here For Full Setup and Operation Instructions" button below to read and follow the setup instructions in full.</b></p>
							<script type='text/javascript'>
								function toggle_visibility(id) {
									 var e = document.getElementById(id);
									 if(e.style.display == 'block')
										e.style.display = 'none';
									 else
										e.style.display = 'block';
								 }
							</script>
							<p><a href='#'><button id="instructionsToggle" type="button" onClick="toggle_visibility('instructionsFull');">Click Here For Setup and Operation Instructions</button></a></p>
							<div id="instructionsFull" style="display:none; max-width: 100%; background-color: #FFFFFF; border: 2px solid #666666; border-radius: 7px; padding: 15px;                margin: 20px 0;">
								<p><b>GETTING STARTED:</b></p>
								<p><span style="color:red;">Read and follow these instructions in full</span> to learn about the operation of the plugin and follow the numbered <b>SETUP</b> instructions below to setup and test your sites Gravity Forms data encryption.</p>
								<p>As you set up each option or setting, read the instructions, and help dialogs for before using/changing the option or setting to learn about its functionality and how to use it.</p><br/>
								<p>Additional written and video tutorials are available <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-docs/" target="blank" rel="nofollow noopener">here</a>.</p><br/>
								<p>It is <b>STRONGLY</b> recommended that you back up your database before proceeding and that you <b>DO NOT</b> initially set up encryption on a live form, but either test on a development site or make a copy of your form for testing on a private page until you understand how to use the plugin and have tested the encryption successfully.</p><br/>
								<p>This plugin encrypts data at rest in the database at the time of form submission (or on entry update if the field data is changed) and displays both encrypted and non encrypted submitted field data properly whether or not encryption is turned on for a field at any time. </p><br/>
								<p>Switching encryption on or off AFTER data is submitted to a field WILL NOT encrypt or decrypt previously submitted data in the database, unless it is changed and updated after encryption is turned on or off, and could result some entry data being encrypted and other entry data left not encrypted for the same field across different entries. However when encryption is turned ON for a field, any previously submitted and unencrypted entry data will still be blocked/hidden from users without view permissions using the "hide field value restricted display". This indicates that while the data value is being hidden in admin, it is NOT actually encrypted.</p><br/>
								<p>It is strongly recommended to decide on encrypting a field at its creation and leave it on permanently from there, while "hide field value" can be turned on or off at any time.</p><br/>
								<p>This plugin can also optionally simply hide field data values in admin from individual users without permission. This option uses no encryption, but can be great for sites that just need a solution to hide form field data from some users.</p><br/>
								<p>This plugins encryption and view permissions operate transparently to normal Gravity Forms operation. This means that once setup is complete and newly submitted (or manually encrypted) field data is saved encrypted in the database, the field data will be automatically decrypted and normally readable for users/roles with view permissions when viewing in all admin interfaces and export options. This means that you should NOT ever expect to see encrypted stings such as "GFEncrypt: 7w72gGhfgRZkdnZmQ2dz09" in the admin interface. Encrypted/hidden field data should always either be returned as normally readable for users with view permissions, or should return the restricted display for the type of data restriction occurring (encrypted/hidden) for users without view permission to that specific field data. So if you can still read encrypted/hidden field data as normal, it is because you have the user or role view permissions to do so.</p><br/>
								<p>The standard Gravity Forms merge tags will NOT give you readable data for encrypted fields and will always print the "Encrypted Field Restricted Display" for that encrypted/hidden field data. Use this plugins "Decrypted Merge Tags" to print out readable field data in confimations, notifications, or wherever else readable decrypted output of encrypted field data is needed from a merge tag. This inlcudes such areas as the "Send To :Enter Email->Send to Email:" address field if you are sending notification emails to an email address field that is encrypted (See example <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-decrypted-merge-tag-examples/" target="blank" rel="nofollow noopener">here</a>). The numbered setup instructions below will guide you through setting up your decrypted merge tags for use.<br/>Pending your security concerns, instead of sending out decrypted data in notification emails you should consider the method of creating users who have certain field view permissions to the encrypted/hidden data and ONLY have "view entries" privileges in WordPress and then requiring them to log in to view entries. Using this method the sensitive data is not sent out via e-mail and the notifications can simply send out the link to the entry (using the "Entry URL merge tag") and a user would need to authenticate through WordPress login each time to view the entry data.<br/>Also to be considered instead of sending out unencrypted data to other data systems is to use the built in <a href="/wp-admin/admin.php?page=gf_settings&subview=gravityformswebapi" target="blank" rel="nofollow noopener">Gravity Forms WEB API</a>. Using the WEB API the other system can securely authenticate with your website over SSL and pull entry data straight from the Website as Unencrypted when using a User with view permissions as the impersonated user.</p>
								<br/>
								<p>While this plugin contains many options for data view permissions that can work together to create more complex permission systems for multi user sites, you do not have to use ANY view permission settings to encrypt data in the database. Just ready the system and turn on any fields encryption and those fields new submission data will be stored encrypted and returned as readable to everyone in all admin interfaces and export options.</p>
								<p><br/></p>
								<p><b>SETUP</b></p>
								<p><b>1.</b> Ensure your system meets the first 4 requirements for:<br/>-Server Encryption Support<br/>-PHP Version<br/>-Wordpress Version<br/>-Gravity Forms Version<br/>in the below <a href="#" onClick="$('html, body').animate({scrollTop: $('#gfe-system-check').offset().top - 33}, 1000);">system check</a>.</p>
								<br/>
								<p><b>2.</b> Follow "<a href="#" onClick="$('html, body').animate({scrollTop: $('#encryption-type').offset().top - 33}, 1000);">Encryption Type</a>" setup instructions below.</p>
								<br/>
								<p><b>3.</b> Enter a strong custom <a href="#" onClick="$('html, body').animate({scrollTop: $('#encryption-password').offset().top - 33}, 1000);">encrytption password</a> and Save Changes again.<br/><b>DO NOT</b> enter website key, a <b>UNIQUE AND SECURE</b> one will be autogenerated for you automatically. Check the website key is using the UNIQUE AND SECURE AUTO KEY by clicking on the settings intructions and checking that the "UNIQUE AND SECURE AUTO KEY" matches the "Key Currently Being Used". If for any reason these do not match, change the key to match the auto key. ALWAYS use the auto key for setup. Virtually all key issues we help users with are caused due to not using the auto key. Once the password is saved and auto key is generated, any fields with encryption turned on will begin to be saved to the database encrypted under the given website key/password combination on submission or update of an entry.</p>
								<p><b>Be sure to safely store a copy of your password and the autogenerated website key. Do NOT change the auto website key.</b></p>
								<br/>
								<p><b>4.</b> If you are going to only hide admin field values and not use encryption at all, turn on the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#encryption-bypass').offset().top - 33}, 1000);">Encryption Bypass</a>" below.</p>
								<br/>
								<p><b>5.</b> In the Gravity Forms form editor, use the form fields "Advanced" tab encryption options to turn on the database encryption or hide field value option per individual field (or optionally use the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#global-encryption-switch').offset().top - 33}, 1000);">Global Form Encryption Switch</a>" on this page to turn encryption or "hide field value" on for all supported fields in a specified form at once).<br/>Once a field's encryption or hide field value is turned on and the form is updated you will see a small lock by encrypted fields and a small blocked eye by hidden fields for quick reference in the form editor.</p>
								<br/>
								<p>If the field needs to be processed by an add-on or feed on submission please read the additional notes in the instructions below.</p><br/>
								<p><i>If this is a single user setup you can skip to #9 below although it is recommended to read #6-8 to be aware of the functionality.</i></p>
								<br/>
								<p><b>6.</b> By default, ALL users that can view form entries have view permissions to an encrypted field's data unless a field has anything entered into its "User View Permission" setting in the Gravity Forms form editor in the fields "Advanced" tab. Once any usernames/roles are entered into a field's "User View Permission" setting, only those users/roles will have view permisions to the field's encrypted or hidden data, and all other users not listed will be restricted unless they have an overriding view permission. The "User View Permission" is per individual field and hovering over the help icon there will detail how it works as well as point to additional global permissions for more control.</p>
								<br/>
								<p><b>7.</b> You optionally can use the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#limit-user-lists').offset().top - 33}, 1000);">Limit User/Role View Permission Lists</a>" list below to enter comma separated user names to globally restrict what user names are valid when entered into any fields "User View Permission" list.</p>
								<br/>
								<p><b>8.</b> You can optionally use the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#user-lockout-list').offset().top - 33}, 1000);">User Lockout List</a>" below to enter comma separated user names to globally BLOCK individual user view permissions for ALL encrypted or hidden field values, regardless of individual fields "User View Permission" settings. To quickly lock out all users enter "lockdown" in the "User Lockout List".</p>
								<br/>
								<p><b>9.</b> You can optionally use the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#user-access-list').offset().top - 33}, 1000);">User/Role Access List</a>" below to enter comma separated user names to globally ALLOW individual users/roles view permissions for ALL encrypted or hidden field values, regardless of individual fields "User View Permission" settings and "User Lockout List" settings.</p>
								<p><b>NOTE:</b>To quickly only give a single user/role ALL view permissions and lock everyone else out, enter "lockdown" in the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#user-lockout-list').offset().top - 33}, 1000);">User Lockout List</a>" below, and enter the username/role slug of the user/role you are giving view ALL permissions to in the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#user-access-list').offset().top - 33}, 1000);">User/Role Access List</a>" below.</p>
								<br/>
								<p><b>10.</b> You can optionally use the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#native-search').offset().top - 33}, 1000);">User/Role Encrypted Field Native Search Permission</a>" setting below to give users/roles the ability to search for encrypted field values in the Gravity Forms entries view.</p>
								<br/>
								<p><b>11.</b> When setting up notifications, confirmations, or other areas where Gravtiy Forms merge tags are used, be aware that the standard gravity forms merge tags will only print the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#encrypted-restricted').offset().top - 33}, 1000);">Encrypted Restricted Display</a>" for any encrypted or hidden field data. This also means that any functionality trying to use a standard Gravity Forms merge tag for field data that is encrypted/hidden will NOT function. This plugin has special Decrypted Merge Tags that can access encrypted/hidden field data to fill this role.</p>
								<br/>
								<p>If you need merge tag output of encrypted/hidden field data as decrypted and readable in notifications, confirmations, Gravity View, or anywhere else Gravity Forms merge tags are accepted (inlcuding such areas as the the "TO:" email address if you are sending notifications to an email field that is encrypted), use the Decrypted Merge Tags by first unlocking them (individually or globally) on this settings page. This process ensures that the sending out or use of encrypted or hidden field data is intentional. Once unlocked you can either insert the decrypted/encrypted tags directly from the standard <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-decrypted-merge-tag-examples/" target="blank" rel="nofollow noopener">Gravity Forms merge tag drop downs "Custom" section</a>, or manually enter them in wherever Gravity Forms merge tags are accepted.</p>
								<br/>
                                <p>By default, section breaks are included in the "ALL" type decrypted merge tags. You can also add individual HTML field's label and content to the forms "ALL" type decrypted tag output by selecting the "GFEF Merge Tag Include" option in the advanced tab of the HTML field in the form editor.</p>
                                <br/>
								<p>If you have any existing forms that you have now started encrypting field data for, any notifications, confirmations, or other functionality trying to print encrypted or hidden field data using the standard gravity forms merge tags will need to be updated to use Decrypted Merge Tags for the data to still be readable/functional. Complete instructions and examples for using the decrypted merge tags are on this settings page <a href="#" onClick="$('html, body').animate({scrollTop: $('#decrypted-merge-tags').offset().top - 33}, 1000);">here</a>, and a video tutorial is also available <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-docs/" target="blank" rel="nofollow noopener">here</a>. </p>
								<br/>
								<p><b>12.</b> Save changes if not already done then ensure your system meets the below <a href="#" onClick="$('html, body').animate({scrollTop: $('#gfe-system-check').offset().top - 33}, 1000);">system check</a> requirements for ALL settings.</p>
								<br/>
								<p><b>13. TESTING</b></p>
								<p>When 1-12 are complete, backup your database if not done already, and do some test entries in a test environment if possible. Check results with various dummy users to be sure your setup is functioning as intended before going live. Additional options available below may be used or disabled for your sites needs as well.</p><br/>
								<p><b>14. VERIFYING DATA IS ENCRYPTED</b></p>
								<p>Once setup is complete and newly submitted (or manually encrypted via the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#encrypt-decrypt-form').offset().top - 33}, 1000);">Encrypt/Decrypt Form Entries</a>" tool) field data is saved encrypted in the database, if you can still read encrypted/hidden field data as normal, it is because you have the view permissions to do so. If you want to verify the field data is actually encrypted in the database you can use one of the following methods:
								<br/>- Use "<a href="#" onClick="$('html, body').animate({scrollTop: $('#gfe-test-verify').offset().top - 33}, 1000);">ENCRYPTION VERIFICATION MODE</a>" below. (shows the actual encrypted strings stored in the database)
								<br/>- Log into your database and view the direct data. (shows actual encrypted strings stored in the database)
								<br/>- Remove your view permissions temporarily. (shows the restricted display for hidden and/or encrypted data)
								<br/>- Log in with a user without view permissions. (shows the restricted display for hidden and/or encrypted data)</p>
								<br/>
								<p><b>15. FINISHING UP</b></p>
								<p>Setup and testing is now complete. Continue reading the usage instructions below to set up auto updates and more, and review the additional options available on this settings page for additional access controls, Field Output Masking, {all_fields} Merge Tag Exclude/Include Options, entry/file auto deletion, removing IP, Deleting Entries, Files, or Specific Field Data After Submission, and more. You may also want to check out our companion plugins for Gravity Forms <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">here</a> which add many additional incredibly useful features to Gravity Forms.</p>
								<br/>
								<p><b>UNDERSTANDING THE VIEW PERMISSIONS FLOW</b></p>
								<p>There are different places to give or resrict view permissions to encrypted/hidden data and the view permissions system flows as follows:</p><br/>
								<p>1. Individual Field Permissions (assigned per field in the fields encryption settings)</p>
								<p><i>The individual fields "User/Role View Permission" setting is blank by defualt and gives individual field view permisions to all users. Once any username or role is placed into the setting it restricts individual field view permisions to only usernames listed and/or users within roles listed.</i></p><br/>
								<p>2. Global User Lockout List -> overrides above (assigned on this plugins settings page)</p>
								<p><i>The “User Lockout List” is global and overrides the individual field "User/Role View Permission" setting and locks out users even if they are listed in the individual field setting or their role is listed there.</i></p>
								<br/>
								<p>3. Global User Access List -> overrides all above  (assigned on this plugins settings page)</p>
								<p><i>The “User Access List” is global and overrides both the individual field "User/Role View Permission" setting and the “User Lockout List”. You can quickly assign limited access GLOBALLY instead of per field by putting “lockdown” in the “User Lockout List” (to globally restrict everybody else), and then only list any users/roles that should have GLOBAL access to all encrypted/hidden fields in the “User Access List”</i></p>
								<br/>
								<p>4. User Owned Field -> overrides all above and only ever gives access to logged in user who originally submitted data (assigned per field in the fields encryption settings)</p>
								<p><i>The "User Owned Field" setting is per individual field, and it does not matter what other view permissions are set anywhere. The original logged in user who submitted the data ..and only them, will be given access.</i></p>
								<br/>
								<p><b>EDITING ENCRYPTED FORM DATA</b></p>
								<p>To edit encrypted or hidden data, just edit the form entry as usual using the entry detail editor in Gravity Forms. Any users who can edit entries but cannot read hidden or encrypted data can still enter new data over it from the entry edit screen. When the entry is updated the updated encrypted fields data will be updated as entered and stored encrypted.</p>
								<br/>
								<p><b>ENCRYPTING/DECRYPTING PREVIOUSLY SUBMITTED ENTRY DATA</b></p>
								<p>To encrypt/decrypt previously existing database field values please use the "<a href="#" onClick="$('html, body').animate({scrollTop: $('#encrypt-decrypt-form').offset().top - 33}, 1000);">Encrypt/Decrypt Form Entries</a>" tool on this page below.</p>
								<br/>
								<p><b>UPDATING THE PLUGIN</b></p>
								<p>Always keep a backup of the current plugin directory before updating, and remember to re-enter the website key immediately after an update if you are using a custom key. The auto key automatically regenerates itself and does not require this step. Using a custom website key instead of the auto genreated one is strongly NOT recommended.</p>
								<p><b>Be sure to safely store a copy of your password and the autogenerated website key (or custom website key if you are forced to use one).</b> Using the auto website key it will regenerate itself after any plugin update or reinstall, but if you change your WordPress security keys or migrate this website to a different WordPress installation (..unless the installation is a clone or uses the same security keys), the autogenerated key will be different and you will have to replace it with the current autogenerated key to continue to access and save data under the current auto key. If  you must use a custom website key (..such as continuing to use an old auto key after migrating the website to a different WordPress install), you need to be sure to check the same custom website key has regenerated itself on this settings page immediately after any plugin update or reinstallation, or follow the manual plugin update instruction in the plugins readme.txt file to preserve the website key on upgrade/reinstallation.</p>
								<p>To auto update the plugin please download and install the free <a href="https://envato.com/market-plugin/" rel="nofollow noopener">Envato Market plugin</a> and set it up in a flash using the "Envato Market" item that will appear in the WordPress admin menu to automatically recieve available update notifications and simple click to update functionality for this plugin in the wordpress admin interface. Developers should use the "Single Item Tokens" for the plugin if you have purchased this plugin using your account on behalf of the client.</p>
								<p>If you are using a manual </p>
								<p>To manually update the plugin, follow the plugins readme.txt file in the <br/>INSTALLATION->Upgrade section. The readme.txt file is located inside the main .zip file of the plugin which can be unzipped to show contents. Please refer to your operating system for instructions on unzipping a .zip file.</p>
								<br/>
								<p><b>USING WITH GRAVITY PDF</b></p>
								<p>Please see <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-docs/" target="blank" rel="nofollow noopener">here</a> for setting up PDFs with decrypted field data. A basic template is provided.</p>
								<br/>
								<p><b>ADDITIONAL NOTES:</b></p>
								<p>- Available Supported Field Types:<br/>single line text, paragraph text, date, name, number, email, phone, website, address, drop down, radio buttons, multi select, checkboxes, list.</p>
								<br/>
								<p>- ADD-ONS/FEEDS<br/>Please note that any data that needs to be passed forward from a form on submission/update to use in other functionality such as payment or product information, mailchimp email address, or other add-on/feed fields can be encrypted AFTER the add-on/feed has been procesed by using the "Process Feeds/Add-Ons before encrypting" option in the form editor under the fields advanced tab encryption options. Please note though that if you "Process Feeds/Add-Ons before encrypting" and the add-on/feed also stores this data in your DB (such as user registration) it will be unencrypted even though the Gravity Forms entry copy of it will be encrypted. This is only a safe option if the feed processes/sends the data but does not store it in the database locally. Additionally, Gravity Forms itself can pass data forward to other forms/functionality through merge tags and that data will be blocked by the merge tag filter, so using the custom decrypted merge tags can serve to pass forward decrypted data when desired.</p>
								<p>User Registration fields CANNOT be encrypted because the data is handed over to wordpress core which does not know what to do with encrypted field data. Using "Process Feeds/Add-Ons before encrypting" will cause Gravity Forms to store it encrypted but WordPress core will store it unencrypted. If you are storing sensitive data associated with a user that WordPress core does not need to access, it is a good idea to not pass it to user registration at all and simply store it as normal Gravity Forms form data with the users username/email all encrypted. You can then search and export that associated user data using Gravity Forms functionality. The user can also access and edit/update that associated data through a plugin like Gravity View.</p>
								<br/>
								<p><b>- </b>This plugin uses split and scrambled encryption keys, and puts safeguards in place to block all unauthorized access to its files and this administration screen.<br/>The weakest areas for security are likely your database/ftp/wordpress login security (weak passwords and users on unsecured networks) and other wordpress users given high level permissions. Please also understand that if you have no Settings Page LOCKOUT Password set, any other users given the admin level ability to edit_users may be able to do whatever they like administratively since they can change roles and permissions, and can then access this page to give themselves access to any encrypted data.</p>
								<br/>
								<p><b>- </b>If you change the key or password you will not be able to view data saved under them until the key and password are changed back.</p><br/>
								<p><b>NOTICE:</b> This plugin fills one necessary component of data protection. The usage of other basic protections such as SSL, VPS, User capability restrictions, and strong admin user password enforcement alongside this plugin are strongly recommended. You may be subject to implementing additional data protection policies and procedures depending on the sensitivity level and type of the information you are collecting. Visit <a href="https://www.gravityhelp.com/documentation/article/security/" target="blank" rel="nofollow noopener">here</a> for additional security practices using Gravity Forms in general. </p><br/>
								<p><b>DEVELOPER NOTES</b></p>
								<p>Developer functions and documentation can be viewed <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-docs/" target="blank" rel="nofollow noindex">here</a>.</p>
								<br/>
							</div>
						</div>
					</td>
				</tr>
				<tr id="gfe-videos-resources" valign="top">
					<th scope="row">VIDEO TUTORIALS AND RESOURCES</th>
					<td>
						<p><a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-docs/" target="blank" rel="nofollow noopener" ><button id="videosandresources" type="button">Click Here for Video Tutorials and Resources</button></a></p>
					</td>
				</tr>
				<tr id="gfe-licensing" valign="top">
					<th scope="row">LICENSING</th>
					<td>
						<p><a href='#'><button id="licensingToggle" type="button" onClick="toggle_visibility('licensing-info');">Click Here for Licensing Information</button></a></p><p></p>
						<div id="licensing-info" style="
							position: relative;
							max-width: 100%;
							background-color: #FFFFFF;
							border: 2px solid #666666;
							border-radius: 7px;
							padding: 15px;
							margin: 0;
							display:none;">
							<p><b>LICENSE INFORMATION</b></p>
							<p><?php echo '<b>Status:</b> ' . $pluginowl_license_status . '<br/>' . $pluginowl_license_status_message; ?></p>
							<p><b>ITEM USAGE</b></p>
							<p>You may install this Plugin on a <b>single</b> live website and a single test/development site for the live site.<br/>For additional installations you must <a href="https://codecanyon.net/item/gravity-forms-encrypted-fields/18564931" target="blank" rel="nofollow noopener">purchase an additional license</a>. To transfer this purchase code to another website you can deregister this current license active site by selecting the deregister option below and updating the registration.</p>
							<p>For more information on Envato Licensing click <a href="https://codecanyon.net/licenses/standard" target="_blank" rel="nofollow noopener">here</a>.</p>
							<br/>
							<p><b>IMPORTANT</b></p>
							<p>When an active site is deregistered ALL users will lose view permissions to existing encrypted and hidden data in ALL interfaces, plugin settings are inaccessible, and field encryption settings as well as all decrypted merge tags are disabled. If the site is no longer going to use the plugin for encryption, any essential encrypted data should be decrypted BEFORE deregistering the site and/or uninstallation/deactivation of the plugin. Data can be decrypted using the "Encrypt/Decrypt Form Entries" tool at the botom of this settings page.</p>
							<br/>
							<p style="color:red;"><input type="checkbox" name="gfe_pluginowl_remove_license" value="1" <?php checked(1, get_option('gfe_pluginowl_remove_license'), true); ?> /> Deregister License For This Website</p>
							<p><?php submit_button("Update License Registration"); ?></p>
						</div>
					</td>
				</tr>
				<tr id="gfe-system-check" valign="top">
					<th scope="row">SYSTEM CHECK</th>
					<td>
						<p><a href='#'><button id="licensingToggle" type="button" onClick="toggle_visibility('systemchecktoggle');">Click Here for System Check</button></a></p>
						<div id="systemchecktoggle" style="max-width:600px; display:none;">
							<table class="gfesystemcheck"
							style="
							width: 100%;
							max-width:600px;
							background-color: #FFFFFF;
							border: 2px solid #666666;
							border-radius: 7px;
							padding: 0px;
							margin: 0;
							font-size: 16px;
							line-height: 30px">
								<tr valign="top">
									<td>Server Encryption Support:</td>
									<td><strong> <?php echo gfe_check_encryption_function(); ?></strong></td>
									<td><?php echo gfe_check_encryption(); ?></td>
								</tr>
								<tr valign="top">
									<td>PHP Version:</td>
									<td><strong><?php echo phpversion(); ?></strong></td>
									<td><?php echo gfe_check_php(); ?></td>
								</tr>
								<tr valign="top">
									<td>Wordpress Version:</td>
									<td><strong><?php echo get_bloginfo( 'version' ); ?></strong></td>
									<td><?php echo gfe_check_wp_version(); ?></td>
								</tr>
								<tr valign="top">
									<td>Gravity Forms Version:</td>
									<td><strong><?php echo GFCommon::$version; ?></strong></td>
									<td><?php echo gfe_check_gf_version(); ?></td>
								</tr>
								<tr valign="top">
									<td>Website Key:</td>
									<td><strong><?php echo gfe_check_website_key(1); ?></strong></td>
									<td><?php echo gfe_check_website_key(2); ?></td>
								</tr>
								<tr valign="top">
									<td>Encryption Password:</td>
									<td><strong><?php echo gfe_check_encryption_key(1); ?></strong></td>
									<td><?php echo gfe_check_encryption_key(2); ?></td>
								</tr>
								<tr valign="top">
									<td>Encryption Type:</td>
									<td><strong><?php echo gfe_check_encryption_type(1); ?></strong></td>
									<td><?php echo gfe_check_encryption_type(2); ?></td>
								</tr>
								<tr valign="top">
									<td>Encryption Turned On:</td>
									<td><strong><?php echo gfe_encryption_on(1); ?></strong></td>
									<td><?php echo gfe_encryption_on(2); ?></td>
								</tr>
								<tr valign="top">
									<td>Merge Tag Filter On:</td>
									<td><strong><?php echo gfe_merge_tag_filter_on(1); ?></strong></td>
									<td><?php echo gfe_merge_tag_filter_on(2); ?></td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
				<tr id="gfe-test-verify" valign="top">
					<th scope="row">ENCRYPTION TESTING<br/>AND VERIFICATION</th>
					<td>
						<p><button id="gfe-test-idToggle" type="button" onClick="toggle_visibility('gfe-test');" >Click Here For ENCRYPTION TESTING AND VERIFICATION</button></p>
						<div id="gfe-test" style="max-width:600px; display:none;">
							<p>This test uses current website key / encryption password config.</p>
							<table class="encryptiontest"
							   style="
								width: 100%;
								max-width: 600px;
								background-color: #FFFFFF;
								border: 2px solid #666666;
								border-radius: 7px;
								padding: 0px;
								margin: 0;
								font-size: 12px;
								line-height: 10px;">
								<tr><td style="width:150px;" class="center">ENCRYPTION TYPE: </td><td><p><?php
								$gfe_type = get_option('gfe_encryption_method');
								if ($gfe_type == 1) {
									echo 'Open SSL';
								} else if ($gfe_type == 2) {
									echo 'Mcrypt';
								} else {
									echo 'Encryption type not selected'; 
								}
								?></p></td></tr>
								<tr><td class="center">SUBMITTED DATA: </td><td><p><?php $gfe_test = 'my personal info 123-45-6789'; echo $gfe_test; ?></p></td></tr>
								<tr><td class="center">CUSTOM DATA:<?php submit_button("Submit");?></td><td><input type="text" id="gfe_custom_data_search" name="gfe_custom_data_search" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_custom_data_search'));} ?>"/><p>Optionally enter custom data see resulting encrypted data below.</p></td></tr>	
								<tr><td class="center">SAMPLE ENCRYPTED DATA STORED IN DATABASE:<br/><p class="notes"></p></td><td><p style="word-break:break-word;"><?php
									$gfe_test_encrypted = null;
									$use_mcrypt 		= apply_filters('gform_use_mcrypt', function_exists( 'mcrypt_encrypt'));
									$use_openssl		= function_exists('openssl_encrypt') && extension_loaded('openssl');
									$gfe_type			= get_option('gfe_encryption_method');

									if (get_option('gfe_custom_data_search') && is_admin() && current_user_can('edit_users')){
										 $gfe_test = get_option('gfe_custom_data_search');
									}
									$gfe_test_encrypted = gfef_encrypt($gfe_test, null);

									if ($gfe_test_encrypted === $gfe_test && !get_option('gfe_encryption_bypass')) { 
										$gfe_test_encrypted = $gfe_test_encrypted . '<div style="background-color:#fed4d4; padding:0px 10px;"><p style="text-align: center;"><span style="color:#de0101;"><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> NOT ENCRYPTED! VIEW SYSTEM CHECK</span></p></span>';
									} else if ($gfe_test_encrypted === $gfe_test && get_option('gfe_encryption_bypass')) { 
										$gfe_test_encrypted = $gfe_test_encrypted . '<div style="background-color:#e6f8eb; padding:0px 10px;"><p style="text-align: center;"><span style="color:#4ecd33;"><img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="12" width="12"> ENCRYPTION TURNED OFF</span></p></span>';
									} else if (substr($gfe_test_encrypted, 0, 11) === 'GFEncrypt: '){
										$gfe_test_encrypted = $gfe_test_encrypted . '<div style="background-color:#e6f8eb; padding:0px 10px;"><p style="text-align: center;"><span style="color:#4ecd33;"><img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="14" width="14"> ENCRYPTION SUCCESSFUL</span></p></div>';
									}					 
									echo $gfe_test_encrypted; 
								 ?></p</td>
								</tr>
								<tr><td class="center">SAMPLE DECRYPTED DATA:<br/><p class="notes">USERS WITH PERMISSION SEE THIS IN ADMIN</p></td><td><p><?php
									$gfe_test_encrypted = null;
									$gfe_test_decrypted = null;
									$use_mcrypt 		= apply_filters('gform_use_mcrypt', function_exists( 'mcrypt_encrypt'));
									$use_openssl		= function_exists('openssl_encrypt') && extension_loaded('openssl');
									$gfe_type			= get_option('gfe_encryption_method');
									$gfe_test_encrypted = gfef_encrypt($gfe_test, null);
									$gfe_test_decrypted = gfef_decrypt($gfe_test_encrypted, null);

									if ($gfe_test_encrypted === $gfe_test && $gfe_test_decrypted === $gfe_test) { 
										$gfe_test_decrypted = $gfe_test_decrypted . '<div style="background-color:#e6f8eb; padding:0px 10px;"><p style="text-align: center;"><span style="color:#4ecd33;"><img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> ORIGINAL VALUE RETURNED</span></p></div>';
									} else if (substr($gfe_test_encrypted, 0, 11) === 'GFEncrypt: ' && $gfe_test_decrypted === $gfe_test){
										$gfe_test_decrypted = $gfe_test_decrypted . '<div style="background-color:#e6f8eb; padding:0px 10px;"><p style="text-align: center;"><span style="color:#4ecd33;"><img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="14" width="14"> DECRYPTION SUCCESSFUL</span></p></div>';
									} else if (substr($gfe_test_encrypted, 0, 11) === 'GFEncrypt: ' && $gfe_test_decrypted !== $gfe_test && get_option('gfe_encryption_key_override')){
										$gfe_test_decrypted = '<div style="background-color:#fed4d4; padding:0px 10px;"><p style="text-align: center;"><span style="color:#de0101;"><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ENCRYPTION PASSWORD OVERRIDE IS ON.</span></p><p><span style="color:#de0101;">ENCRYPTION IS FUNCTIONING BUT TEST DATA CANNOT BE DECRYPTED UNDER THE CURRENT ENCRYPTION OVERRIDE PASSWORD.</span></p><p><span style="color:#de0101;">REMOVE THE OVERRIDE TO TEST DECRYPTION WITH THE CURRENT ACTIVE ENCRYPTION PASSWORD.</span></p></div>';
									} else {
										$gfe_test_decrypted = '<div style="background-color:#fed4d4; padding:0px 10px;"><p style="text-align: center;"><span style="color:#de0101;"><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> DECRYPTION ERROR! REVIEW SYSTEM CHECK ABOVE</span></p></div>';
									}
									echo $gfe_test_decrypted; ?></p></td>
								</tr>
								<tr><td class="center">ENCRYPTED FIELD<br/>RESTRICTED DISPLAY:<br/><p class="notes">USERS WITHOUT PERMISSION SEE THIS IN ADMIN IF ENCRYPTED</p></td><td><p><?php
									if (get_option('gfe_restricted')) {
										echo esc_html__(get_option('gfe_restricted'));
									} else {
										echo '<div style="background-color:#fed4d4; padding:0px 10px;"><p style="text-align: center;"><span style="color:#de0101;"><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> ENCRYPTED FIELD RESTRICTED DISPLAY is not set. Restricted encrypted field views will be blank.</span></p></span>';
									}	
								?></p></td></tr>
								<tr><td class="center">HIDE FIELD VALUE<br/>RESTRICTED DISPLAY:<br/><p class="notes">USERS WITHOUT PERMISSION SEE THIS IN ADMIN IF HIDDEN</p></td><td><p><?php
									if (get_option('gfe_hidevalue')) {
										echo esc_html__(get_option('gfe_hidevalue'));
									} else {
										echo '<div style="background-color:#fed4d4; padding:0px 10px;"><p style="text-align: center;"><span style="color:#de0101;"><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> HIDE FIELD VALUE RESTRICTED DISPLAY is not set. Restricted hidden field views will be blank.</span></p></span>';
									}	
								?></p></td></tr>
								<tr id="gfefEVM" style="background-color: #ffe4ee;"><td  class="center" style="border-radius: 7px;"><span style="color:red;">ENCRYPTION VERIFICATION MODE</span></td><td style="border-radius: 7px;"><p><input type="checkbox" name="gfe_show_encryption" value="1" <?php checked(1, get_option('gfe_show_encryption'), true); ?> /><p><span style="color:red;"><b>Only use when site is either not live or is in maintenance mode and any form entry or editing is not in session. Do not adjust any other settings while using this mode. Failure to adhere to these guidelines could result in possible data loss:</span><br/> Temporarily</b> turn this on to reveal any raw encrypted database data in ALL entry viewing interfaces and exports to quickly verify encryption. <span style="color:red;"><br/><b>DO NOT LEAVE THIS ON.</b></p></span></p><br/>		
								</td></tr>
							</table>
						</div>
					</td>
				</tr>
				<tr valign="top" style="border-top: 2px solid red;">
					<th class="settings" scope="row"><span style="color:red;">CAUTION !</span></th>
					<td>
						<div id="gfe-administration-instructions" style="
								width: 100%;
								max-width: 575px;
								background-color: #ffffff;
								border: 2px solid red;
								border-radius: 7px;
								padding: 10px;
								margin: 0;
								font-size: 12px;
								line-height: 10px;">
							<p><span style="color:red;"><b>ADMINISTRATIVE AREA BELOW</b></span></p>
							<p>Please use caution when editing the settings below, and BACK THESE SETTINGS UP so if you need to restore them you can easily.</p><p><b>It is imperitive that you DO NOT change any below settings or encryption / "hide field  data" options for a form field when any affected form entries are being edited / updated. Turning these options on or off when restricted form data is updated may result in the restricted data being overwritten with the restricted data display if the editing user does not have view permissions!</b></p><p>Any data written under a given key / password combination, can ONLY be read under the same combination, and may not be visible in form entries until the correct key / password combination is restored. It is HIGHLY reccommeded that you set your password and website key once and leave them alone forever, unless there should be some absolutely unavoidable need to change them.</p><br/>
							<p>This page and its options are visible to ADMIN/SUPER ADMIN or users with edit_users permissions only.</p>
							<p>Do not use any values equal to 0 for settings.</p>
						</div>
					</td>
				</tr>
				<tr id="encryption-type" class="settingstr" valign="top">
					<th class="settings" scope="row" >Encryption Type<?php if (!get_option('gfe_encryption_method')) {echo '<br/><p style="color: red; font-style: bold;">STOP! READ NOTICE</p>';} ?></th>
					<td>
						<?php
						if (!get_option('gfe_encryption_method')) {
							echo '<div style="max-width:580px; border: 2px solid #000000; padding: 10px; background-color: #FFFFFF;">
								<p style="color: red; font-style: bold;"><span style="font-size: 40px;">!!! STOP !!!</span><br/>NOTICE: YOU MUST FOLLOW THIS PLUGINS README FILE INSTRUCTIONS IF UPGRADING FROM A VERSION PREVIOUS TO 3.0 TO VERSION 3.0+</p>
								<p>Version 3.0+ bring significant changes to the encryption used and also strengthens the data security over previous versions.</p>
								<p> If you did not decrypt ALL previous entries before upgrading from ver <3.0 to ver 3.0+ according to this versions readme file upgrade instructions. Please reinstall your previous version according to its readme file upgrade instructions and then refer to the this versions readme file upgrade instructions to proceed with decrypting ALL old entries before upgrading to version 3.0+ after upgrading.  These entries will be re-encrypted under new encryption in ver 3.0+ </p><br/>
								<p>If this is a brand new install you do NOT need to do anything, and can simply select your encryption type and continue with setup</p>
							</div><br/>';
						} 
						?>
						<?php if (!get_option('gfe_encryption_method')) {echo '<p style="color: red; font-style: bold;">STOP! READ NOTICE ABOVE</p>';} ?><input type="radio" name="gfe_encryption_method" value="1" <?php checked(1, get_option('gfe_encryption_method'), true); ?>> <b>OpenSSL</b>  (Strongly Recommended)<br/>
						<?php if (!get_option('gfe_encryption_method')) {echo '<p style="color: red; font-style: bold;">STOP! READ NOTICE ABOVE</p>';} ?><input type="radio" name="gfe_encryption_method" value="2" <?php checked(2, get_option('gfe_encryption_method'), true); ?> <?php echo apply_filters('gform_use_mcrypt', function_exists('mcrypt_encrypt')) ? '' : 'disabled'; ?>> <b>Mcrypt</b>  <?php echo version_compare( phpversion(), '7.2.0', '>=') ? '<span style="color:red;">(NOT COMPATIBLE with your core PHP version (' . phpversion() . '). See setting instructions.)</span> ' : '(Depricated in PHP 7.2+)'; ?>
						<div id="gfe-encryption-method-instructions" style="max-width:600px;">
							<p><?php echo gfe_check_encryption(); ?></p><br/>
							<p>Select the Encryption type you would like to use.<br/>(OpenSSL is strongly recommended if it is available)</p>
							<p><button id="gfe-encryption-type-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-encryption-type-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-encryption-type-instructionsToggle" style="display:none">
								<p>Data encrypted under one encryption type cannot be read under the other.</p>
								<p><b>If switching encryption types it is strongly advised to use the "Encrypt/Decrypt Form Entries" tool to decrypt all past entries, and then switch encryption types and re encrypt them with the new encryption type.</b></p><br/>
								<p>NOTES:<br/>
								- Mcrypt is scheduled be depricated from PHP core as of ver 7.2+, but may still be available if using an MCrypt add-on.<br/>
								- OpenSSL is strongly recommended and may be required if you are currently running PHP 7.2+, or will be in the future.</p>
							</div>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Delete Plugin Options on Removal</th>
					<td><input type="checkbox" name="gfe_delete_options" value="1" <?php checked(1, get_option('gfe_delete_options'), true); ?> />
						<?php
						if (!get_option('gfe_delete_options')) { 
							$gfe_delete_options_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> Plugin options will currently be saved when you remove the plugin. This allows for safe removal and reinstallation of an upgraded or previous version without re-entering all setup options.</p><p> Be sure to back up your website key! This will have to be regenerated on update or removal and reinstallation and may change depending on changes you have made to your wordpress install. You can change it back with your copy if needed after update or reinstall.</p>';
						} else if (get_option('gfe_delete_options')){
							$gfe_delete_options_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="14" width="14"> <span style="color:red;">CAUTION!</span> All plugin options will currently be deleted when this plugin is removed. You should disable this if you are just removing to upgrade to a newer version.</p>';
						}?> 
						<div id="gfe_delete_options" style="max-width:600px;">
							<?php echo $gfe_delete_options_status; ?>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Admin Area Only Viewing *</th>
					<td><input type="checkbox" name="gfe_admin_only" value="1" <?php checked(1, get_option('gfe_admin_only'), true); ?> />
						<?php
						if (!get_option('gfe_admin_only')) { 
							$gfe_admin_only_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="14" width="14"> Encrypted field data can currently be viewed as readable on any front end data displays by logged in users with permission. Data is also recurrently retrievable via the Gravity Forms WEB API as readable. To restrict viewing to admin pages only, turn on this option.</p><p><b>*</b> Due to the large variety of ways that Gravity Forms data could possibly be shown on the front end of the site, this may not work with your sites front end display. Only plugins or code that uses the Gravity Forms get/save field API for front end display will be compatible. Please thouroughly test your system for functionality.</p>';
						} else if (get_option('gfe_admin_only')){
							$gfe_admin_only_status = ' <p><img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="14" width="14"> Encrypted and hidden field data can currently only be viewed in admin pages as readable by logged in users with permission, and the Gravity Forms WEB API does NOT have decrypted access. To enable front end encrypted field data viewing for logged in users with permission, turn off this option.</p><p><b>*</b> Due to the large variety of ways that Gravity Forms data could possibly be shown on the front end of the site, this may not work with your sites front end display. Only plugins or code that uses the Gravity Forms get/save field API for front end display will be compatible. Please thouroughly test your system for functionality.</p>';
						}?> 
						<div id="gfe-admin-only-instructions" style="max-width:600px;">
							<?php echo $gfe_admin_only_status; ?>
						</div>
					</td>
				</tr>
				<tr id="encryption-bypass" class="settingstr" valign="top">
					<th class="settings" scope="row">Encryption Bypass</th>
					<td><input type="checkbox" name="gfe_encryption_bypass" value="1" <?php checked(1, get_option('gfe_encryption_bypass'), true); ?> />
						<?php
						if (get_option('gfe_encryption_bypass')) { 
							$gfe_encryption_status = ' <p><span><img src="' . plugin_dir_url(__FILE__) . 'images/unlocked.png" height="14" width="14"> ENCRYPTION IS OFF</span></p>';
						} else if (!get_option('gfe_encryption_bypass')){
							$gfe_encryption_status = ' <p><span style="color:#4ecd33;"><img src="' . plugin_dir_url(__FILE__) . 'images/locked.png" height="14" width="14"> ENCRYPTION IS ON</span></p></div>';
						} 
						echo $gfe_encryption_status;
						?>
						<div id="gfe-bypass-instructions" style="max-width:600px;">
							<p>This data safe option will turn off / bypass ALL actual data encryption and still allow for hiding field values in admin with user viewing permission restrictions for fields with "hide field value" turned on.</p>
							<p><button id="gfe-encryption-bypass-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-encryption-bypass-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-encryption-bypass-instructionsToggle" style="display:none">
								<p>If you are going to use this, it should ideally be turned on right after install so no encryption can be used.</p>
								<p>If you want to only hide values on some fields while using encryption on others you can leave encryption on and select to either use encryption or hide values per individual field in the form field advanced options.</p>  
							</div>
						</div>
					</td>
				</tr>
				<tr id="merge-tag-filter" class="settingstr" valign="top">
					<th class="settings" scope="row">Merge Tag Filter Bypass</th>
					<td><input type="checkbox" name="gfe_mergefilter" value="1" <?php checked(1, get_option('gfe_mergefilter'), true); ?> />
						<div id="gfe-mergefilter-instructions" style="max-width:600px;">
						<?php
							if (get_option('gfe_mergefilter')) { 
								$gfe_mergefilter_status = ' <p><span style="color:red;"><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="14" width="14"> MERGE TAG RESTRICTED DISPLAY FILTER IS OFF</span></p><p>Turn this bypass option off to replace encrypted or hidden field values in merge tags with the encrypted field restricted display for ALL users in merge tag generated content such as confirmations or notifications.</p><p>If this is left on and a user with field viewing permission resends notifications or fills out a form that triggers notifications or confirmations or other merge tag results the encrypted and hidden data that the triggering user has permission to view will be readable to everyone in the resulting notifications and confirmations or other resulting merge tag output.</p><p>When the filter is not bypassed, this option requires that either encryption or hide field values is currently turned on for fields in order to hide output in merge tags. Any previously encrypted data for a field with encryption and hide field value currently turned off will still be decrypted and readable if user triggering the merge tag content has view permissions.<br/>To prevent this and/or exclude any fields from the {all_fields} merge tag entirely, use the {all_fields} Merge Tag Exclude/Include Options" below.</p>';
							} else if (!get_option('gfe_mergefilter')){
								$gfe_mergefilter_status = ' <p><span style="color:#4ecd33;"><img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> MERGE TAG RESTRICTED DISPLAY FILTER IS ON </span></p><p><b>LEAVE THIS ON</b> unless you have read the instructions.</p><br/>';
							} 
							echo $gfe_mergefilter_status;
						?>
						<button id="gfe-mergefilter-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-mergefilter-instructionsToggle');">Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-mergefilter-instructionsToggle" style="display:none;">
								<?php
									if (!get_option('gfe_mergefilter')){
										$gfe_mergefilter_status = '<p>This filter replaces encrypted or hidden field values with the encrypted field restricted display in merge tags for ALL users, and is on by default to prevent users with encrypted or hidden field view permissions from generating merge tag results (such as notifications and confirmations) with decrypted and unhidden field data.</p><br/><p><b>DO NOT TURN THIS FILTER BYPASS ON TO TRY TO GET CONSTANT DECRYTPED DATA IN NORMAL GRAVITY FORMS MERGE TAGS.</b> If you want to print certain encrypted or hidden field data through merge tags as readable all the time regardless of who fills out a form, ..or if you would like to have merge tags print the data as readable only if the user has field permissions, leave this filter ON and use the available "Decrypted Merge Tags" option below.</p><br/><p>The merge tag filter requires that either encryption or hide field values is turned on for fields in order to hide the field value output in merge tags with restricted displays. Any previously encrypted data for a field with encryption or hide field value currently turned off will still be decrypted and readable by everyone in notifications and confirmations or wherever the merge tags are used if the user triggering the merge tag content generation(fills out form or resends notifications ect.) has view permissions to that field.<br/>To prevent this and/or exclude any fields from the {all_fields} merge tag entirely, use the {all_fields} Merge Tag Exclude/Include Options" below.</p>';
									} 
									echo $gfe_mergefilter_status;
								?>
							</div>
						</div>
					</td>
				</tr>
				<tr id="merge-tag-include-exclude" class="settingstr" valign="top">
					<th class="settings" scope="row">{all_fields} Merge Tag Exclude/Include Options</th>
					<td>
						<div id="gfe-inc-exc-instructions" style="max-width:600px;">
							<p>IN ADDITION to the above restricted display filter option you may use this plugin's {all_fields} Merge Tag Exclude/Include Options" documented here to exclude encrypted or hidden or any other fields from your confirmations, notifications, or other gravity forms {all_fields} merge tag uses. You can also use these options to include HTML, Section Break, and Signatures in {all_fields} merge tag output.</p>
							<br/>
							<p><button id="gfe-inc-exc-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-inc-exc-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-inc-exc-instructionsToggle" style="display:none;">
								<p>1. To exclude/remove a field(s) from {all_fields} mergetags add 'exclude[ID]' option to the {all_fields} tag. 'ID' is field's id.
								<br/>2. If you are not using the {all_fields} tag in confirmations or notifications or otherwise for a form, simply do not include merge tags for fields you do not want displayed.
								<br/>3. The 'include[ID]' option allows including HTML fields / Section Break field descriptions / Signature images  in {all_fields} merge tag output in notifications and confirmations ect.
								<br/>4. Visit <a href="http://www.gravityhelp.com/documentation/page/Merge_Tags" target="blank" rel="nofollow noopener">http://www.gravityhelp.com/documentation/page/Merge_Tags</a> for a list of standard options.
								<br/>5. For gravity.pdf plugin exclusion use class "exclude" in field Custom CSS Class.
								</p>
								<p>
									<br/>Usage: {all_fields:include[ID],exclude[ID,ID]}
									<br/>Example: {all_fields:exclude[7,3]}
									<br/>Example: {all_fields:include[12]}
									<br/>Example: {all_fields:include[12],exclude[7,3]}
								</p>
							</div>              
						</div>
					</td>
				</tr>
				<tr id="decrypted-merge-tags" class="settingstr" valign="top">
					<th class="settings" scope="row">Decrypted Merge Tags<br/><span style="font-weight:normal">{gfef_decrypt_FIELD ID}<br/>{gfef_decrypt_ALL}<br/>{gfef_decrypt_ALL+}</span><br/> <br/>User Decrypted Merge Tags<br/><span style="font-weight:normal">{gfef_decrypt_user_FIELD ID}<br/>{gfef_decrypt_ALL_USER}<br/>{gfef_decrypt_ALL+_USER}</span><br/>  <br/>Encrypted Merge Tags<br/><span style="font-weight:normal">{gfef_encrypt_FIELD ID}<br/>*developer tool</span><br/> </th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_decrypt_merge_tags" value="<?php echo esc_html__(get_option('gfe_decrypt_merge_tags')); ?>" id="gfef-decrypted-merge-tags" /><?php echo  get_option('gfe_decrypt_merge_tags'); ?></textarea>
						<div id="gfe-decrypt-merge-tags-instructions" style="max-width:600px;">
							<p>Use the 3 types of custom <a href="https://docs.gravityforms.com/merge-tags/">merge tags</a> (shown to the left) to output decrytped or encrypted field data in notifications and confirmations. Tags must be "unlocked" here for them to function when used in the notifications, confirmations, or any other places Gravity Forms merge tags are accepted. Once unlocked you can either insert the decrypted/encrypted tags directly from the standard <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-decrypted-merge-tag-examples/" target="blank" rel="nofollow noopener">Gravity Forms merge tag drop downs "Custom" section</a>, or manually enter them wherever Gravity Forms field data merge tags are accepted.</p>
							<p>If this is a single admin or similar site, or if your admin environment does not need to control the specific decrypted merge tags admins can use, you can quickly unlock ALL available decrypted merge tags for use in ALL forms by clicking the button below and saving changes to add the Universal Unlocks to this setting. This will allow you to use them freely anywhere the standard Gravity Forms merge tags are accepted.</p>
							<p><input id="universal-inlock-insert" type="button" value="UNLOCK ALL DECRYPTED MERGE TAGS" onClick="insertText('gfef-decrypted-merge-tags', 'ALL:ALL+, ALL:ALL, ALL:ANY, ALL:ALL+:U, ALL:ALL:U, ALL:ANY:U, ALL:ANY:X');"></p>
							<script type="text/javascript">
								if (document.getElementById("gfef-decrypted-merge-tags").innerHTML == "ALL:ALL+, ALL:ALL, ALL:ANY, ALL:ALL+:U, ALL:ALL:U, ALL:ANY:U, ALL:ANY:X") {
									document.getElementById("universal-inlock-insert").style.display = 'none';
								}
						    	function insertText(elemID, text) {
									var elem = document.getElementById(elemID);
									if (!elem.innerHTML) {
										elem.innerHTML += text;
									} else if (elem.innerHTML == "ALL:ALL+, ALL:ALL, ALL:ANY, ALL:ALL+:U, ALL:ALL:U, ALL:ANY:U, ALL:ANY:X") {
										return;
									} else {
										elem.innerHTML += ", " + text;
									}
									document.getElementById("universal-inlock-insert").style.display = 'none';
						    	}
							</script>
							<p>Once merge tags are unlocked here they will become available in the Gravity Forms merge tag dropdown selectors.</p>
							<p>Read the INSTRUCTIONS below to learn about the Decrypted Merge Tag types and how to unlock them individually or universally as desired.</p>
							<p><button id="gfe-decrypt-merge-tags-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-decrypt-merge-tags-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-decrypt-merge-tags-instructionsToggle" style="display:none;">
								<p>Using these merge tags ONLY decrypts/encrypts for merge tag output and does not change permissions or encryption on the websites entry views.</p>
								<p>This plugins merge tags appear generally like this in some form: {gfef_CONTENT}. These custom merge tags are placed directly inline with your notification/confirmation content to print out entry data just like the standard Gravity Forms <a href="https://docs.gravityforms.com/merge-tags/">merge tags</a>. For information on how to use merge tags in general please refer to the <a href="https://docs.gravityforms.com/merge-tags/">Gravity Forms documentation.</a></p>
								<br/>
								<p>A video tutorial on decrytped merge tag use is available <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-videos/" rel="nofollow noopener" target="blank">here</a>.</p>
								<br/>
								<p>This plugins merge tag unlocks appear generally like this: 12:13:U  or 1:ALL+. These unlocks use the FORM ID as the first number, then use the FIELD ID or type of ALL tag, then use the specifier of U or X to designate user permission decryption or encrypted merge tags. These unlocks are placed in the settings here and unlock the specific tag they represent by FORM ID:FIELD ID/type of tag: and specifier.</p>
								<p>Once merge tags are unlocked here they will become available in the Gravity Forms merge tag dropdown selectors. Merge tags can also be manually entered where they are accepted if no drop down selector is available (Such as the "Send To :Enter Email->Send to Email:" field in gravity forms notifiation emails. See example <a href="https://www.pluginowl.com/gravity-forms-encrypted-fields-decrypted-merge-tag-examples/" target="blank" rel="nofollow noopener">here</a>).</p>
								<p>Placing these custom merge tags in a forms notifications/confirmations without unlocking it here will not function. This is to prevent users who can edit notifications/confirmations but cannot edit this plugins settings from sending out unauthorized decrypted data.</p>
								<p>There are 3 types of custom merge tags available. Decrypted Merge Tags, User Decrypted Merge Tags, and Encrypted Merge Tags. The Decrypted Merge Tags decrypt the data all the time. The User Decrypted Merge Tags only decrypt the data if the current user has view permissions to it. Encrypted Merge Tags output an encrypted output of the data.</p><br/>
								<p><b>IMPORTANT NOTES:</b></p>
								<p>When a specific field id is required in an unlock or merge tag, replace "FIELD ID" with the actual field id.</p>
								<p>When a specific form id is required in an unlock, replace "FORM ID" with the actual form id.</p>
								<p>Do not place merge tags in the unlock setting, and do not place unlocks in the notifications or confirmations. This will not work.</p>
								<p>The {gfef_decrypt_ALL+} tag is the closest replication for the standard Gravity Forms {all_fields} tag but it gives constant decrypted output for all fields.</p>
								<p>To quickly unlock ALL available merge tags for ALL forms there are available Universal Unlocks at the bottom of these INSTRUCTIONS.</p>
								<p>Fine tuned unlock control is also available per individual tag and form/field following the insrtuctions per tag.</p>
								<br/>
								<p><b>DECRYPTED MERGE TAGS</b></p>
								<p><i>These standard decrypted merge tag bypass ALL permissions and merge tag filtering and give a constant decrypted output.</i></p>
								<p>The <b>{gfef_decrypt_FIELD ID}</b> merge tag outputs decrypted and human readable data from a single field based on the FIELD ID used.</p>
								<p>To unlock the {gfef_decrypt_FIELD ID} tag for a specific form and field, enter comma separated FORM ID:FIELD ID values to allow for using the specified fields decrypted merge tag in the specified forms merge tag output.
								<br/>
								<p>example: entering 11:3, above will allow you to use {gfef_decrypt_3} as a valid merge tag to get decrypted data from the FIELD ID 3 in form 11 confirmations and notifications.</p>
								<p>You can enter FORM ID:ANY to unlock this tag for ANY FIELD ID used in merge tags within the specific FORM ID used.</p>
								<p>example: 11:ANY allows you to use ANY valid FIELD ID's from form 11 in the Decrypted Merge Tags for form 11 such as {gfef_decrypt_3} {gfef_decrypt_12} {gfef_decrypt_24}. If those fields exist in the specified form they will pull their data into the merge tag.</p>
								<p>You can enter ALL:ANY to unlock this tag for ANY FIELD ID for ALL forms.</p><br/>
								<p><b>Notes on Multi Part Fields</b></p>
								<p>When NOT using "ANY" for a FIELD ID and using {gfef_decrypt_FIELD ID} tags for multi part fields, you CAN ..and MUST specify which exact field input id's you want returned (such as first or last name, or city/state/street from an address.</p>
								<p>Example: 22:9.3, 22:9.6</p>
								<p>The above example entered into this setting here would allow for form ID 22 to use both {gfef_decrypt_9.3} and {gfef_decrypt_9.6} in its notifications/confirmations to decrypt and output both the first and last name of the name field if field ID 9 is a "name".
								<p>If you are using "ANY" for a FIELD ID, you can simply use the standard field ID without specifying an input ID and it will print out all inputs from the field ID.</p>
								<p>Example: 22:ANY</p><br/>
								<p>The above example entered into this setting here would allow for form ID 22 to use {gfef_decrypt_9} in its notifications/confirmations to decrypt and output both the first and last name of the name field if field ID 9 is a "name".</p><br/>
								<p>Both "ANY" and specific multi-part field ID's can be entered to unlock all of the above mutli part field example merge tags at the same time. Example: 22:ANY, 22:9.3, 22:9.6 .</p><br/>
								<p>Please see documentation <a href="https://docs.gravityforms.com/gf_field_checkbox/" target="blank" rel="nofollow noopener">here</a>, <a href="https://docs.gravityforms.com/gf_field_name/" target="blank" rel="nofollow noopener">here</a>, and <a href="https://docs.gravityforms.com/gf_field_address/#settings" target="blank" rel="nofollow noopener">here</a> for starters on identifying multiple part fields IDs and click the button below to reveal the most common cases.</p>
								<br/>
								<p><button id="multi_part_field_idToggle" type="button" onClick="toggle_visibility('multi_part_field_id');">Click Here For MULTI PART FIELD ID GUIDE</button></p>
								<div id="multi_part_field_id" style="display:none;">
									<p><b>ADDRESS</b><br/>
									street  = FIELD ID.1<br/>
									city    = FIELD ID.3<br/>
									state   = FIELD ID.4<br/>
									zip     = FIELD ID.5<br/>
									country = FIELD ID.6<br/><br/>

									<b>NAME</b><br/>
									prefix = FIELD ID.2<br/>	
									first  = FIELD ID.3<br/>
									last   = FIELD ID.6<br/>
									suffix = FIELD ID.8<br/><br/>

									<b>MULTI / CHECKBOXES</b><br/>
									box 1 = FIELD ID.1<br/>
									box 2 = FIELD ID.2<br/>
									ect.</p><br/>
								</div>
								<br/>
								<br/>
								<p>The <b>{gfef_decrypt_ALL}</b> merge tag outputs decrypted and human readable field data ONLY for ALL fields that have encrypted and/or hidden data in the form entry. The {gfef_decrypt_ALL} merge tags will not decrypt User Owned Fields unless the user generating the merge tag content owns the entries field data.</p>
								<p>To unlock the {gfef_decrypt_ALL} tag for a specific form, enter comma separated FORM ID:ALL values to allow for using the specified forms decrypted merge tag in the specified forms merge tag output.</p>
								<p>example: entering 11:ALL, above will allow you to use {gfef_decrypt_ALL} as a valid merge tag to get decrypted data for ALL fields (that have encrypted and/or hidden data) in form 11 confirmations and notifications.</p>
								<p>You can enter ALL:ALL to unlock this tag for ALL forms.</p>
								<br/>
								<p>The <b>{gfef_decrypt_ALL+}</b> merge tag outputs decrypted and human readable field data for ALL fields in the form entry. The decrypted output of the {gfef_decrypt_ALL+} merge tag bypasses ALL permissions (aside from user owned fields) and merge tag filtering and gives a constant decryted output. The {gfef_decrypt_ALL+} merge tags will not decrypt User Owned Fields unless the user generating the merge tag content owns the entries field data. The behavior of this merge tag closely replicates the standard Gravity Forms {all_fields} tag but it decrypts and shows all data.</p>
								<p>To unlock the {gfef_decrypt_ALL+} tag for a specific form, enter comma separated FORM ID:ALL+ values to allow for using the specified forms decrypted merge tag in the specified forms merge tag output.</p>
								<p>example: entering 11:ALL+, above will allow you to use {gfef_decrypt_ALL+} as a valid merge tag in form 11 confirmations and notifications.</p>
								<p>You can enter ALL:ALL+ to unlock this tag for use in ALL forms.</p>
								<br/>
								<br/>
								<p><b>USER DECRYPTED MERGE TAGS</b></p>
								<p><i>These user decrypted merge tags only give a decrypted output if the active user has view permissions to the specific field data.</i></p>
								<p>The <b>{gfef_decrypt_user_FIELD ID}</b> merge tag only outputs decrypted and human readable field data for the FIELD ID used if the current user has permissions to the field data. This is useful for use cases like "Gravity View" where you can use merge tags to populate front end data. If you use this on a page then the viewing user would need permisions to the field data or they will get the retricted display. <span style="color:red;">Warning!</span> If you use this in a notification and the user triggering the notifications going out (by filling out form or resending notifications) has view permissions to the field(s) the decrypted data will be sent out in the notification e-mail.</p>
								<p>To unlock the {gfef_decrypt_user_FIELD ID} tag for a specific form field, enter comma separated FORM ID:FIELD ID:U values to allow for using the specified fields decrypted merge tag in the specified forms merge tag output.<br/>
								example: entering 11:3:U, above will allow you to use {gfef_decrypt_user_3} as a valid merge tag to get view permissions based decrypted data from the FIELD ID 3 in form 11 confirmations and notifications.</p>
								<p>You can enter FORM ID:ANY:U to unlock this tag for ANY FIELD ID used in merge tags within a specific FORM ID.</p>
								<p>example: 11:ANY:U allows you to use any valid FIELD ID's in the User Decrypted Merge Tags for form 11 such as {gfef_decrypt_3} {gfef_decrypt_12} {gfef_decrypt_24}. If those fields exist in the form they will pull their data into the merge tag based on the current users permissions.</p>
								<p>You can enter ALL:ANY:U to unlock this tag for ANY FIELD ID for ALL forms.</p>
								<br/>
								<p>The <b>{gfef_decrypt_ALL_USER}</b> merge tag outputs field data only for any fields with encrypted and/or hidden data in the form entry and only shows them as decrypted and human readable if the current user has permissions to the field data. This is useful for use cases like "Gravity View" where you can use merge tags to populate front end data. If you use this on a page then the viewing user would need permisions to the field data or they will get the retricted display. <span style="color:red;">Warning!</span> If you use this in a notification and the user triggering the notifications going out (by filling out form or resending notifications) has view permissions to the field(s) the decrypted data will be sent out in the notification e-mail.</p>
								<p>To unlock the {gfef_decrypt_ALL_USER} tag for a specific form, enter comma separated FORM ID:ALL:U values to allow for using the specified forms decrypted merge tag in the specified forms merge tag output.</p>
								<p>example: entering 11:ALL:U, above will allow you to use {gfef_decrypt_ALL_USER} as a valid merge tag to get decrypted data from form 11 confirmations and notifications.</p>
								<p>You can enter ALL:ALL:U to unlock this tag for ALL forms.</p>
								<br/>
								<p>The <b>{gfef_decrypt_ALL+_USER}</b> merge tag outputs field data for all fields in the form entry and only shows them as decrypted and human readable if the current user has permissions to the field data. This is useful for use cases like "Gravity View" where you can use merge tags to populate front end data. If you use this on a page then the viewing user would need permisions to the field data or they will get the retricted display. The behavior of this merge tag closely replicates the standard Gravity Forms {all_fields} tag but allows for data the user has permissions to to be viewed where the normal {all_fields} tag would show a restricted display do to the merge tag filter.<span style="color:red;">Warning!</span> If you use this in a notification and the user triggering the notifications going out (by filling out form or resending notifications) has view permissions to the field(s) the decrypted data will be sent out in the notification e-mail.</p>
								<p>To unlock the {gfef_decrypt_ALL+_USER} tag for a specific form, enter comma separated FORM ID:ALL+:U values to allow for using the specified forms decrypted merge tag in the specified forms merge tag output.</p>
								<p>example: entering 11:ALL+:U, above will allow you to use {gfef_decrypt_ALL+_USER} as a valid merge tag for decrypted data from form 11 confirmations and notifications.</p>
								<p>You can enter ALL:ALL+:U to unlock this tag for ALL forms.</p>
								<br/>
								<br/>
								<p><b>ENCRYPTED MERGE TAGS</b></p>
								<p><i>These encrypted merge tags give an encrypted output of specific field data.</i></p>
								<p>The <b>{gfef_encrypt_FIELD ID}</b> merge tag outputs a single fields data as encrypted and non human readable for the FIELD ID used. The {gfef_encrypt_FIELD ID} merge tag is for developers to output an encrypted version of any field data in notifications and confirmations to be decrypted elsewhere by the data or email recipient. Data that is unencrypted will still have an encrypted version output by this merge tag. <b>Plugin Owl does NOT support or assist in the decryption of output encrypted fields on the recieving end of notifications or confirmations</b>, but simply supplies this ability for developers to be able to pass encrypted field strings through email notifications and develop their own proper decryption for the other side.</p>
								<p>To unlock the {gfef_encrypt_FIELD ID} tag for a specific form field, enter comma separated FORM ID:FIELD ID:X values to allow for using the specified fields encrypted merge tag in the specified forms merge tag output.<br/>
								example: entering 11:3:X, above will allow you to use {gfef_encrypt_3} as a valid merge tag for encrypted data from the field with ID 3 in form 11 confirmations and notifications.</p>
								<p>You can enter FORM ID:ANY:X to unlock this tag for ANY FIELD ID for a specific FORM ID.</p>
								<p>example: 11:ANY:X allows you to use any valid FIELD ID's in the Encrypted Merge Tags merge tags for form 11 such as {gfef_encrypt_3} {gfef_encrypt_12} {gfef_encrypt_24}. If those fields exist in the form they will pull their encrypted data into the merge tag.</p>
								<p>You can enter ALL:ANY:X to unlock this tag for ANY FIELD ID for ALL forms.</p>
								<br/>
								<br/>
								<p><b>Examples</b></p>
								<p><b>22:1, 21:3, 22:4:X, 21:ALL, 24:7:U, 26:ALL:U, ALL:ALL+</b></p>
								<p>The above example entered into this setting here will allow you to use the {gfef_decrypt_1} merge tag in form 22 notifications and confirmations (creates decrypted output of field 1), and the {gfef_decrypt_3} merge tag in form 21 notifications and confirmations (creates decrypted output of field 3), and the {gfef_encrypt_4} merge tag in form 22 notifications and confirmations (creates encrypted output of field 4), and the {gfef_decrypt_ALL} merge tag in form 21 notifications and confirmations (creates decrypted output of ALL encrypted and hidden fields in form 21), and the {gfef_decrypt_user_7} merge tag in form 24 notifications and confirmations (creates decrypted output of field 7 if the user has permission to the field), and the {gfef_decrypt_ALL_USER} merge tag in form 26 notifications and confirmations (creates decrypted output of ALL encrypted and hidden fields in form 26 if the user has permission to the fields). The last tag (ALL:ALL+) allows the {gfef_decrypt_ALL+} tag to be used for any form.</p>
								<br/>
								<p><b>UNIVERSAL UNLOCKS</b></p>
								<p>You can enter the following to quickly unlock ALL of the above custom tags for ALL forms and ANY FIELD IDs:<br/>
								ALL:ALL+, ALL:ALL, ALL:ANY, ALL:ALL+:U, ALL:ALL:U, ALL:ANY:U, ALL:ANY:X</p>
								<br/>
								<p>Please note that unlocking all decrypted merge tags of any type is not recommended if you are in a multi user admin environment where some admin users who can edit notifications, confirmations, or Gravity View content should not be able to view/export decrypted data through placing decrypted merge tags.</p>
							</div>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Field Output Masking<br/>and Permissions Bypass</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_masking" value="<?php echo esc_html__(get_option('gfe_masking')); ?>"  style="border: 2px; border-radius: 7px;"/><?php echo  get_option('gfe_masking'); ?></textarea>
						<div id="gfe-masking-instructions" style="max-width:600px;">
							<p>Enter formatted field masks to enable customized display output masking for specified forms and fields. This also overrides the standard restricted display and merge tag filter. Separate field masks with a comma. NO spaces in the mask.</p>
							<p><button id="gfe-masking-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-masking-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-masking-instructionsToggle" style="display:none;">
								<p><b>This feature is STRONGLY suggested to be used with <a href="https://www.gravityhelp.com/documentation/article/input-mask/" target="blank" rel="nofollow noopener">input masked fields</a> that are required to be formatted a certain way, or predefined selection fields so that you can predict what the output mask will actually show. Using this without a field input mask could very possibly reveal encrypted or hidden data.</b></p>
								<p>Field data that a user has access to or is unencrypted and/or unhidden will just display normally. You CANNOT use a mask to show User Owned Field data.</p><br/>
								<p><b>Format:</b> Form ID : Field ID : beginnning charachter count : end charachter count : optional use in merge tags : optional permissions bypass to display full decrypted output.</p><br/>
								<p>Example: 12:4:0:4:M:F</p><br/>
								<p><b>The mask must complete the above first 4 sections in order. Enter '0' when no charachters are wanted. The last 2 sections for merge tags or full value are optional and can be in any order AFTER the mandatory first 4 sections.</b></p>
								<p>To also use this masked output in merge tags (this will override the merge tag filter display if its on), add a last mask section with "M" in it to use the mask on the field in merge tags. Example:   12:7:2:4:M</p>
								<p>Restricted display output from above example if data is "hippopotamus": hi***amus</p><br/>
								<p><b>Single Field Permissions Bypass</b></p>
								<p>To use the FULL decrypted output and bypass ALL view permissions, add a last mask section with "F" in it. (*if you only want to show full value in merge tags for notifications ect. but still have view restrictions on the site, please use the custom decrypted merge tags above.)    Example:   12:7:0:0:F</p>
								<p>Output from above example if data is "hippopotamus": hippopotamus</p><br/>
								<p>Example:   12:7:2:4:M  restricted displays will show beginning 2 charachters and last 4 charachters of form 22 for field 7 on the website and in merge tags</p><br/>
								<p>Example:   3:14:0:4  restricted displays will show no beginning charachters and last 4 charachters of form 3 for field 14 only on the website and NOT in merge tags</p>
								<p>Restricted display output from above example if data is "12-34-1234": ***1234</p><br/>
								<p>Example:   12:7:2:4:M, 3:14:0:4  will do BOTH of the above examples</p>
								<p>You can use 'M" and "F" together to output full decrypted display in merge tags too.</p>
								<p>Examples: 22:14:0:4:F, 22:3:3:0:F:M, 22:10:0:3:M:F</p>
							</div>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Remove User IP Address From Form Submissions</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_delete_ip" value="<?php echo esc_html__(get_option('gfe_delete_ip')); ?>" /><?php echo  get_option('gfe_delete_ip'); ?></textarea>
						<div id="gfe_delete_ip-instructions" style="max-width:600px;">
							<p>Enter comma separated form ID's to have the users IP address automatically removed from those forms entry properties.</p>
							<p><button id="gfe-delete-ip-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-delete-ip-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-delete-ip-instructionsToggle" style="display:none">
								<p>The Users IP can still be stored and encrypted using a standard "single line text" field and selecting the default value to be "User IP Address" in the fields advanced tab. This allows you to not store unencrypted IPs on your website server.</p><br/>
								<p>Please note that if you have any functionality or plugins which rely on the users IP as an entry property to function, they will not function if you are removing the IP address here.</p><br/>
								<p>Example: 22,14,3<br/>(Removes the users IP address from entry properties for forms with ID 22, 14, and 3 after submission)</p>
								<p>If the form has a User Registration feed the IP will be removed after the user has been activated/updated.</p>
							</div>
						</div>
					</td>
				</tr>
                <tr class="settingstr" valign="top">
					<th class="settings" scope="row">Delete Signatures After Submission</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_delete_signature" value="<?php echo esc_html__(get_option('gfe_delete_signature')); ?>" /><?php echo  get_option('gfe_delete_signature'); ?></textarea>
                        <div id="gfe_delete_signature-instructions" style="max-width:600px;">
							<p>Enter comma separated FORM ID:NOTIFICATION NAMEs to have the forms signature files deleted from the server and automatically attached as physical file attachments to specified notifications that are sent on submission.</p><br/>
							<p><button id="gfe_attach_file_uploads-instructions-idToggle" type="button" onClick="toggle_visibility('gfe_delete_signature-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe_delete_signature-instructionsToggle" style="display:none;">                       
								<p>Example: 22:Admin Notification, 14:Johnny:Admin Notification, 3:UserNotification:Admin Notification:Email Sasha</p>
								<p>Explanation: The first item must always be the FORM ID then continue to add any notification names to have signature files attached for that FORM ID separated by ':' and then separate each full sequence with a comma.</p>
								<p>Uploaded siganture files will be attached and sent in notifications BEFORE any auto entry deletion or siganture file deletion. If you auto delete the entire entry the siganture files will not be availabe to resend on any notification resends.</p>
								<p><b>You MUST be sure that the total size of the resulting email going out with attachments is smaller than your sending or the recipiants recieving e-mail allowed size, or the e-mail will NOT be delivered and siganture files and entry could be auto deleted if using the above "Delete Entries After Submission" option. It is strongly reccommended that you constrain the upload size and total allowable uploads in any file upload fields to be sure that the total of the file size(s) in resulting email will be small enough to safely email every time to any recipients. You can check with your e-mail host and others as to a generally safe file size. We reccommend 7mb or less total email size including files.</b></p>
							</div>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Delete Individual Field Data After Submission</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_delete_field_data" value="<?php echo esc_html__(get_option('gfe_delete_field_data')); ?>" /><?php echo  get_option('gfe_delete_field_data'); ?></textarea>
						<div id="gfe_delete_field_data-instructions" style="max-width:600px;">
							<p>Enter comma separated FORM ID:Field ID(s) values to have the form's field data automatically deleted for matching form id:field ID's after notifications are sent on submission. The first number is the Form ID. The following numbers are the field IDs for fields on that form ID that should have data deleted after submission.</p>
							<p><button id="gfe-delete-field-data-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-delete-field-data-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-delete-field-data-instructionsToggle" style="display:none">
								<p>Use this to just send out notifications or process field data for other purposes and not have to store the submitted field data in your database.</p><br/>
								<p>Example: 22:1:4:15, 14:1:3:2, 3:1:35<br/>(Deletes field data from entries after submission from form ID 22 for fields 1, 4, and 15 ..form ID 14 for fields 1, 3, and 2 ..form ID 3 for fields 1, and 35)</p>
								<p>If the form has a User Registration feed the field data will be deleted after the user has been activated/updated.</p>
							</div>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Delete Entries After Submission</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_delete_entry" value="<?php echo esc_html__(get_option('gfe_delete_entry')); ?>" /><?php echo  get_option('gfe_delete_entry'); ?></textarea>
						<div id="gfe_delete_entry-instructions" style="max-width:600px;">
							<p>Enter comma separated form ID's to have both the forms entries any uploaded files automatically deleted after notifications are sent on submission.</p>
							<p>Use this to just send out notifications and not have to store the submitted entry data on your site while also keeping site size down and removing any uploaded files with potentially sensitive data such as a resume, from being stored on your website server.</p><br/>
							<p>Example: 22,14,3<br/>(Deletes entire entries and files from forms with ID 22, 14, and 3 after submission)</p>
							<p>If the form has a User Registration feed the entry will be deleted after the user has been activated/updated.</p>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Delete Only File Uploads After Submission</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_delete_file_uploads" value="<?php echo esc_html__(get_option('gfe_delete_file_uploads')); ?>"  style="border: 2px solid #ddd; border-radius: 7px;"/><?php echo  get_option('gfe_delete_file_uploads'); ?></textarea>
						<div id="gfe_delete_file_uploads-instructions" style="max-width:600px;">
							<p>Enter comma separated form ID's to have only the forms uploaded files automatically deleted after notifications are sent on submission.</p>
							<p><button id="gfe-delete-file-uploads-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-delete-file-uploads-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-delete-file-uploads-instructionsToggle" style="display:none">
								<p>Use this to keep any sensitive data in uploaded files such as a resume, from being stored on your website server. It also works for just keeping total website size down instead of continually storing all uploaded files.</p><br/>
								<p>Example: 22,14,3<br/>(Deletes files from forms with ID 22, 14, and 3 after submission)</p>
								<p>If the form has a User Registration feed the uploaded files will be deleted after the user has been activated/updated.</p>
								<p>Since the file will be deleted from the server, it NOT able to be viewed or downloaded by any created links to it. You can use the {all_fields} Merge Tag Exclude/Include Options to exlude the standard download link from showing up in {all_fields} notifications, and/or add the class "exclude" to the file upload field to have it not generate the download link in Gravity PDF plugin output.</p>
							</div>
						</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Attach File Uploads to Notification Emails.</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_attach_file_uploads" value="<?php echo esc_html__(get_option('gfe_attach_file_uploads')); ?>" /><?php echo  get_option('gfe_attach_file_uploads'); ?></textarea>
						<div id="gfe_attach_file_uploads-instructions" style="max-width:600px;">
							<p>Enter comma separated FORM ID:NOTIFICATION NAMEs to have the forms uploaded files automatically attached as physical file attachments to specified notifications that are sent on submission.</p><br/>
							<p><button id="gfe_attach_file_uploads-instructions-idToggle" type="button" onClick="toggle_visibility('gfe_attach_file_uploads-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe_attach_file_uploads-instructionsToggle" style="display:none;">                       
								<p>Example: 22:Admin Notification, 14:Johnny:Admin Notification, 3:UserNotification:Admin Notification:Email Sasha</p>
								<p>Explanation: The first item must always be the FORM ID then continue to add any notification names to have files attached to for that FORM ID separated by ':' and then separate each full sequence with a comma.</p>
								<p>Uploaded files will be attached and sent in notifications BEFORE any auto entry deletion or file deletion. If you auto delete file uploads or the entire entry the files will not be availabe to resend on any notification resends.</p>
								<p><b>You MUST be sure that the total size of the resulting email going out with attachments is smaller than your sending or the recipiants recieving e-mail allowed size, or the e-mail will NOT be delivered and files and entry could be auto deleted if using above "Delete File Uploads After Submission" or "Delete Entries After Submission" options. It is strongly reccommended that you constrain the upload size and total allowable uploads in any file upload fields to be sure that the total of the file size(s) in resulting email will be small enough to safely email every time to any recipients. You can check with your e-mail host and others as to a generally safe file size. We reccommend 7mb or less total email size including files.</b></p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="encrypted-restricted" class="settingstr" valign="top">
					<th class="settings" scope="row">Encrypted Field Restricted Display</th>
					<td><input type="text" name="gfe_restricted" style="border: 2px solid #ddd; border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_restricted'));} ?>" style="width:100%; max-width: 600px;" maxlength="32"/>
						<div id="gfe-restricted-instructions" style="max-width:600px;">
							<p>Enter what you would like to display to users who DO NOT have access permissions to view <b>encrypted</b> values.</p><br/>
							<p><button id="gfe-encrypted-restricted-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-encrypted-restricted-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-encrypted-restricted-instructionsToggle" style="display:none">
								<p>This will display for any data being stored encrypted, regardless of other settings even if encryption is later turned off for the field or "hide field data" is turned on instead.</p>
								<p>Please also use the "Merge Tag Restricted Display Filter" and {all_fields} Merge Tag Exclude/Include Options" above to ensure users with view permission do not send out encrypted and hidden field data as readable by triggering merge tag displays in notifications or confirmations ect. that use thier view permissions.</p>
								<p>Using a unique value here will allow users without permission to know when data has been entered, and is actually encrypted vs just hidden when viewed without permission.</p>
								<p>Delete any input and save changes to have the Encrypted Field Restricted Display make the field blank when a user is restricted. If you do this and you are restricted you will not be able to tell if there is either no data or you are being restricted.</p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="hidden-restricted" class="settingstr" valign="top">
					<th class="settings" scope="row">Hide Field Value Restricted Display</th>
					<td><input type="text" name="gfe_hidevalue" style="border: 2px solid #ddd; border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_hidevalue'));} ?>" style="width:100%; max-width: 600px;" maxlength="32"/>
						<div id="gfe-hidevalue-instructions" style="max-width:600px;">
							<p>Enter what you would like to display to users who DO NOT have access permissions to view <b>hidden</b> field values.</p>
							<p><button id="gfe-hidden-restricted-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-hidden-restricted-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-hidden-restricted-instructionsToggle" style="display:none">
								<p>This will only display when the database value is simply hidden in admin, and IS NOT encrypted in the database.</p>
								<p>Please also use the "Merge Tag Restricted Display Filter" and {all_fields} Merge Tag Exclude/Include Options" above to ensure users with view permission do not send out encrypted and hidden field data as readable by triggering merge tag displays in notifications or confirmations ect. that use thier view permissions.</p>
								<p>Using a unique value here will allow you to know what data is just hidden vs actually encrypted when viewed without permission. </p>  
								<p>Delete any input and save changes to have the Encrypted Field Restricted Display make the field blank when a user is restricted. If you do this and you are restricted you will not be able to tell if there is either no data or you are being restricted.</p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="native-search" class="settingstr" valign="top">
					<th class="settings" scope="row">User/Role Encrypted Field Native Search Permission<br/></th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_user_search_permission_list" value="<?php echo esc_html__(get_option('gfe_user_search_permission_list')); ?>" /><?php echo  get_option('gfe_user_search_permission_list'); ?></textarea>
						<div id="gfe-user-search-permission-list-instructions" style="max-width:600px;">
							<p>Enter comma separated list of usernames/roles (use role slug) that can natively search entries of encrypted field data on the entries list page.</p>
							<p>Native search finds exact values (not partial values contained within field data) only and this DOES INCLUDE finding values of multi part fields such as a first name/last name or city from a address.</p><br/>
							<p><button id="gfe-user-search-permission-list-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-user-search-permission-list-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-user-search-permission-list-instructionsToggle" style="display:none;">
								<p>Users not on this list who have permission to view encrypted fields can still search for that data but return of data without native search is unreliable.</p> <p>Users who do not have permission to view encrypted field data cannot search based on its human readable value.</p>
								<p>You can only use native search to search for data submitted under the current website key/password.</p>
								<p>To use give access to roles, use the role slug here just as you would enter a username. For example to give the role "Administrator" access you would enter its slug of "administrator".</p>
								<p><b>NOTICE: The ability to search for field data does not mean the data will display as readable if the user does not have permission to view the field data, but based on search criteria and results a user could determine what the data is regardless of its actuall display in results.</b></p>
								<br/><p><?php echo gfef_list_all_roles(); ?></p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="limit-user-lists" class="settingstr" valign="top">
					<th class="settings" scope="row">Limit User/Role View Permission Lists</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_limit_user_view_permission_list" value="<?php echo esc_html__(get_option('gfe_limit_user_view_permission_list')); ?>" /><?php echo  get_option('gfe_limit_user_view_permission_list'); ?></textarea>
						<div id="gfe-user-limit-permission-instructions" style="max-width:600px;">
							<p>Enter comma separated list of usernames/roles (use role slug) to limit the usernames and roles that <b>WILL BE VALID</b> when placed in ANY form fields advanced tab "User View Permission" list.</p>
							<p><button id="gfe-user-limit-permission-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-user-limit-permission-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-user-limit-permission-instructionsToggle" style="display:none;">
								<p>Use this to control users who have form editing permissions but DO NOT have access to this page's settings (edit_users permissions - this is normally ADMIN ONLY unless otherwise assigned to a user)  from adding unauthorized usernames or roles to fields "User View Permission" lists allowing unauthorized viewing of encryted or hidden data.</p>
								<p>If this is left blank, ALL usernames/roles in any fields "User View Permission" list will be accepted. If anything is entered here, only valid usernames/roles listed here AND in any fields "User View Permission" list will be given view permission for that field, and any unauthorized usernames or roles in the "User View Permission" lists will be ignored. If a fields "User View Permission" list is left blank it will still allow user permissions to ALL users regarless of validation restrictions here.</p>
								<p>This is a quick way to only ALLOW view permission for certain users/roles while still maintaning a level of per field control.</p>
								<p>To use give access to roles, use the role slug here just as you would enter a username. For example to give the role "Administrator" access you would enter its slug of "administrator".</p>
								<br/><p>Example: Johnny,Abby,administrator</p>
								<br/><p><?php echo gfef_list_all_roles(); ?></p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="user-lockout-list" class="settingstr" valign="top">
					<th class="settings" scope="row">User Lockout List</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_user_lockout_list" value="<?php echo esc_html__(get_option('gfe_user_lockout_list')); ?>" /><?php echo  get_option('gfe_user_lockout_list'); ?></textarea>
						<div id="gfe-user-lockout-instructions" style="max-width:600px;">
							<p>Enter comma separated list of usernames that <b>CANNOT read ALL encrypted / hidden field data even if username is on "User View Permission" list</b> in form field.</p>
							<p><button id="gfe-user-lockout-list-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-user-lockout-list-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-user-lockout-list-instructionsToggle" style="display:none">
								<p>Use this to globally lockout users who have form editing permissions but DO NOT have access to this page's settings (edit_users permissions - this is normally ADMIN ONLY unless otherwise assigned to a user)  from viewing any encryted data through any admin interface.</p>
								<p>Enter "lockdown" anywhere in list to quickly lockout ALL users.</p>
								<br/><p>Example: Johnny,Abby,Robert</p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="user-access-list" class="settingstr" valign="top">
					<th class="settings" scope="row">User/Role Access List</th>
					<td><textarea rows="4" style="width:100%; max-width:600px; border: 2px solid #ddd; border-radius: 7px;" name="gfe_user_lockout_override_list" value="<?php echo esc_html__(get_option('gfe_user_lockout_override_list')); ?>" /><?php echo  get_option('gfe_user_lockout_override_list'); ?></textarea>
						<div id="gfe-user-access-instructions" style="max-width:600px;">
							<p>Enter comma separated list of usernames/roles that <b>CAN read ALL encrypted / hidden field data even if username or lockdown is on "User Lockout List" list above, and/or username/role is not on "User View Permission" in field or lockdown is on "User View Permission" in field.</b></p>
							<p>This access list globally gives individual users/roles encrypted and hidden field access overriding every other view permission setting (except user owned fields).</p>
							<p><button id="gfe-user-access-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-user-access-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-user-access-instructionsToggle" style="display:none;">
								<p>You can use this in combination with the "User Lockout List" to quickly globally allow certain users/roles view permission to <b>ALL</b> encrypted or hidden fields While locking all others out, regardless of what is on any fields "User View Permission" list.</p>
								<p>For example: To quickly ONLY allow the user "User1" access to all hidden and encrypted fields simply enter "lockdown" in the "User Lockout List" and enter "User1" in this "User/Role Access List". Or to keep individual fields "User View Permission" active and just allow "User1" access to all hidden and encrypted fields regardless of individual field "User View Permission" list settings just enter "User1" in this "User/Role Access List".</p>
								<p>To use give access to roles, use the role slug here just as you would enter a username. For example to give the role "Administrator" access you would enter its slug of "administrator".</p>
								<br/><p>Example: Johnny,Abby,administrator</p>
								<br/><p><?php echo gfef_list_all_roles(); ?></p>
							</div>
						</div>
					</td>
				</tr>
				<tr id="gfef-website-key" class="settingstr" valign="top">
					<th class="settings" scope="row">Website Key</th>
					<td><input type="text" name="gfe_website_key" style="border: 2px solid #ddd; border-radius: 7px;" value="" style="width:100%; max-width: 600px;" maxlength="32" autocomplete="false"/>
						<div id="gfe-site-key-instructions" style="max-width:600px;">
							<p><?php 
								if (is_admin() && current_user_can('edit_users')) {
									$key_display = gfe_get_website_key();
									echo $key_display;
								}
								?><br/><?php echo gfe_check_website_key(2); ?></p><br/><b>USE THE AUTO GENERATED KEY.<br/>COPY THE KEY AND KEEP SAFE.</b></p>
							<p><button id="gfe-website-key-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-website-key-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
							<div id="gfe-website-key-instructionsToggle" style="display:none">
								<p><b>UNIQUE AND SECURE AUTO KEY</b>:<br/><?php echo gfef_echo_auto_salt(); ?></p>
								<p>Key Currently Being Used:<br/><?php echo $key_display; ?></p><br/>
								<p>ALWAYS use the auto key unless you absolutely must use a custom key to access data transferred from another WordPress Installation. Using a custom key is STRONGLY NOT recommended and requires you to either re-enter the custom website key on this settings page immediately after any plugin update or reinstallation, or follow the manual plugin update instruction in the plugins readme.txt file to preserve the custom website key on upgrade/reinstallation.</p>
								<br/><p> The auto key is your websites <b>UNIQUE AND SECURE</b> auto generated key to VIEW AND WRITE data with and it does NOT need to be changed for security. If not already present the key should generate once you save changes, and if you are using the auto generated key, it will be automatically and passively regenerated on plugin update or removal and reinstall (if plugin settings are saved on uninstall). Be sure to keep a copy of your key to replace the autogenerated one here if you're using a custom key or have migrated your wordpress installation or changed your WordPress installations security keys since the initial install of this plugin.</p>
							
								<p>Only the same website key / password combination can be used to transfer / recover data submitted / updated under them to Wordpress installations.<br/>It is strongly recommended that the auto generated key is used but you can enter a custom website key if necessary. If you are forced to use a custom key it also attempts to auto regenerate but should be checked here immediately each time after plugin update or removal and reinstall to be sure it was able to regenerate.</p>
								<p>Use normal ASCII charachters only.</p><br/>
								<p><button id="gfe_website_key_manual_instructionsToggle" type="button" onClick="toggle_visibility('gfe_website_key_manual_instructions');">Click Here For HELP TO MANUALLY GENERATE</button></p>
								<div id="gfe_website_key_manual_instructions" style="display:none;">
									<p>If the website key will not automatically generate or save your custom key, you likely have a web server write permissions issues within your WordPress installation. This is most likely due to security restrictions on your web server. If you cannot resolve the permissions issue, you can save the website key manually by following these instructions.</p>
									<p>Using a <b>SECURE</b> FTP/SSH client, open the "salt.php" file within this plugin. The normal path for this file is /wp-content/plugins/gravity-forms-encrypted-fields/includes/. On line 7 where it reads<br/> $salt = "[%%SALT%%]";<br/>   change this to <br/>$salt = "<?php gfef_echo_auto_salt(); ?>";</p>
									<p>Use copy and paste to avoid errors.</p></br/>
									<p>This manual entry above has been auto generated from your specific site, <b>is secure and unique to your WordPress installation only</b>, and does NOT need to be changed for security concerns. <b>If any changes must be made the entry must be of EQUAL CARACHTER LENGTH (32) and contain letters and numbers only ..NO SPECIAL CARACHTERS.</b> Remember to read the upgrade instructions in newer versions of the plugins .readme file and do not copy over this particular file/includes folder on upgrade to retain this setting.</p><br/>
								</div>
							</div>
						</div>
					</td>
					<?php 
						delete_option('gfe_website_key');
						delete_site_option('gfe_website_key'); 
					?>
				</tr>
				<tr id="encryption-password" class="settingstr" valign="top">
					<th class="settings" scope="row">Encryption Password</th>
					<td><input type="text" name="gfe_encryption_key" style="border: 2px solid #ddd; border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encryption_key'));} ?>" style="width:100%; max-width: 600px;" maxlength="32" autocomplete="false"/>
					<div id="gfe-user-password-instructions" style="max-width:600px;">
						<?php if (is_admin() && current_user_can('edit_users') && !get_option('gfe_encryption_key')){echo 
						'<p><img src="' . plugin_dir_url(__FILE__) . 'images/x.png" height="12" width="12"> You must enter an encryption password to WRITE and VIEW data with before data encryption will begin.<br/><b>COPY THIS PASSWORD AND KEEP SAFE.</b><br/>Only the same password / website key can be used to transfer/recover/search data saved under them to Wordpress installations.<br/>USE NORMAL ASCII CHARACHTERS ONLY</p>' 
						;} else if (is_admin() && current_user_can('edit_users') && get_option('gfe_encryption_key')){echo 
						'<p><img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> Encryption password active! </p><br/><b>COPY THIS PASSWORD AND KEEP SAFE.</b><br/><p>Encrypted fields will now be saved and viewable under this current website key / password combination. Only change the key if necessary! Use normal ASCII charachters only.</p>' ;} ?>
					</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Encryption Password Override</th>
					<td><input type="text" name="gfe_encryption_key_override" style="border: 2px solid #ddd; border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encryption_key_override'));} ?>" style="width:100%; max-width: 600px;" autocomplete="false"/>
					<div id="gfe-password-override-instructions" style="max-width:600px;">
						<?php if (is_admin() && current_user_can('edit_users') && !get_option('gfe_encryption_key_override')){echo 
						'<p>STOP! DO NOT USE THIS ON INITIAL SETUP!</p>
						<p>If you had to change your encryption password and did not re-encrypt old data under that password under your new password you can enter the decryption password for the old data to view it with without disrupting currently submitting data being written under your current password while you are using this VIEW ONLY OVERRIDE.
						<br/>This key cannot actually change any field data (unless used in combination with the "Encrypt/Decrypt Form Entries" tool as the override decryption password) and is only used for VIEWING encrypted field data under old passwords.</p>
						<p>The old data must have been encrypted using the website key currently being used. This is useful to view data only under a different password if the password had to be changed for any reason.<br/> Fields encrypted under your regular password will not be readable and may not show up while decrypting with a different password but will return to normal when the override is removed and decryption is using the normal password again.</p>' 
						;} else if (is_admin() && current_user_can('edit_users') && get_option('gfe_encryption_key_override')){echo 
						'<p><img src="' . plugin_dir_url(__FILE__) . 'images/check.png" height="14" width="14"> Encryption Password Override Active! </p><p></p><p>Encrypted fields will now be viewed using this current website key / password override combination. Use normal ASCII charachters only.</p>' ;} ?>
						<p>Any encrypted fields submitted or updated when this password override is active will still be encrypted using the current website key with the normal encryption password, and will be viewable under them once the override is removed.</p>
					</div>
					</td>
				</tr>
				<tr id="global-encryption-switch" class="settingstr" valign="top">
					<th class="settings" scope="row">Global Form Encryption Switch</th>
					<td>FORM ID:<input type="text" name="gfe_global_encryption_on" style="border: 2px solid #ddd; border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_global_encryption_on'));} ?>" style="width:100%; max-width: 600px;"/>
					<div id="gfe_global_encryption_on-encrypt-hide" style="max-width: 150px; border: 2px solid #ddd; border-radius: 7px; padding: 5px; margin-top: 5px">
					<input type="radio" name="gfe_global_encryption_encrypt_hide" value="1" <?php checked(1, get_option('gfe_global_encryption_encrypt_hide'), true); ?>> ENCRYPTION<br/>
					<input type="radio" name="gfe_global_encryption_encrypt_hide" value="2" <?php checked(2, get_option('gfe_global_encryption_encrypt_hide'), true); ?>> HIDE FIELD VALUE
					</div>
					<div id="gfe_global_encryption_on-on-off" style="max-width: 60px; border: 2px solid #ddd; border-radius: 7px; padding: 5px; margin-top: 5px">
					<input type="radio" name="gfe_global_encryption_on_off" value="1" <?php checked(1, get_option('gfe_global_encryption_on_off'), true); ?>> ON<br/>
					<input type="radio" name="gfe_global_encryption_on_off" value="2" <?php checked(2, get_option('gfe_global_encryption_on_off'), true); ?>> OFF
					</div>
					<div id="gfe_global_encryption_on-instructions" style="max-width:600px;">
						<p>Enter the numeric FORM ID for a form and select ENCRYPTION or HIDE FIELD VALUE and ON or OFF to turn encryption or hide field value on/off for ALL supported fields on the form. Save changes.</p>
						<p><button id="gfe-global-encryption-switch-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-global-encryption-switch-instructionsToggle');" >Click Here For INSTRUCTIONS</button></p>
						<div id="gfe-global-encryption-switch-instructionsToggle" style="display:none">
							<p>This only quickly turns encryption or hide field value on or off globally (for supported fields) for the singular form and DOES NOT encrypt or decrypt previous entries. After saving changes you may check the form in the form editor to confirm encryption or hide field value is turned on/off for all supported fields. Turning encryption on will turn off hide field value and turning hide field value on will turn off encryption the same as if you selected these options in the fields advanced tab within the form editor. However, turning off encryption will NOT turn off hide field value for fields, and turning off hide field value will NOT turn off encryption for fields.</p>
						</div>
					</div>
					</td>
				</tr>
				<tr id="encrypt-decrypt-form" class="settingstr" valign="top">
					<th class="settings" scope="row">Encrypt/Decrypt Form Entries<p><span style="color:red;">!!! CAUTION !!!</span></p></th>
					<td>
					<p><button id="gfe-form-decryption-section-idToggle" type="button" onClick="toggle_visibility('gfe-form-decryption-sectionToggle');">Click Here For FORM ENCRYPT/DECRYPT TOOL</button></p>
					<br/>
					<div id="gfe-form-decryption-sectionToggle" style="max-width:600px; border: 2px solid #666666; border-radius: 7px; padding: 10px; background-color: #FFFFFF; display: none;">
						<p><span style="color:red;">BACKUP YOUR DATABASE FIRST!<br/>DO NOT proceed without one or more current and reliable database backups.</span></p><br/>
						<p><span style="color:red;">READ THE TOOL INSTRUCTIONS BELOW IN FULL FIRST!<br/>DO NOT proceed without learning how the tool functions.</span></p>
						<p><button id="gfe-form-decryption-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-form-decryption-instructionsToggle');">Click Here For INSTRUCTIONS</button></p>
						<div id="gfe-form-decryption-instructionsToggle" style="display:none;">
							<p>This tool can encrypt or decrypt existing Gravity Forms entry data.</p><br/>
							<p>You can run encryption or decryption in batches of entries for a form by specifying the form and batch size, or you can process only specific entries by specifying entry IDs. You can also process only specific fields within the entries while running either by batch or targeting certain entries.</p><br/>
							<p><span style="color:red;">WHEN DECRYPTING</span>, You must be sure that any forms and entries and fields you enter here are decryptable and readable using the CURRENT 'Website Key' and 'Encryption Password/Encryption Password Override'. If you can read the decrypted data back in entry view normally then the current key/pass is correct for decrypting the data. If you cannot read the data normally due to incorrect current key/pass for the data you can take the forms offline temporarily and adjust the key/pass to whatever the data was encrypted under and check to be sure it is then decrypted and readable in entry view before proceeding.</p><br/>
							<p><span style="color:red;">If you attempt decryption with the wrong 'Website Key' or 'Encryption Password/Encryption Password Override' on encrypted data, your data will be LOST and you will have to restore the DB to your save to recover the data!</span></p><br/>
							<p>Encryption always uses the current 'Website Key' and 'Encryption Password' and DOES NOT use the 'Encryption Password Override'.</p><br/>
							<p>If you are DECRYPTING from an old key/pass to ENCRYPT under a new key/pass, you must set the key/pass/pass_override for proper DECRYPTION of selected form/entries/fields then change to the new key/pass and run ENCRYPTION on same entries/fields. If the old entries are under a different website key, you should take available forms down temporarily if you have to briefly change the website key to decrypt entries under that old website key so that any entries submitted while they are changed will not be encrypted under the old website key. If only the encryption password is different, you can use the "encryption password override" temporarily to use that old encryption password on DECRYTPION runs, and forms can stay active as they will still be ENCRYPTED under the current website key and encryption password.</p>
							<p>You can ONLY encrypt fields that have encryption available in the form editor, and by default only fields with encryption currently turned on in the form can be encrypted unless you select the "ALLOW ENCRYPTING FIELDS WITH ENCRYPTION CURRENTLY TURNED OFF IN FORM" option below. If field data is already encrypted it will be skipped. To change encryption key/pass you have to decrypt first, then encrypt with the new key/pass.</p><br/>
							<p>- Available Field Types: text, textarea, date, name, number, email, phone, website, address, dropdown, radio, multi select, checkbox, list, time.</p><br/>
							<p>Inputs with <span style="color:red;">*</span> are REQUIRED. Other inputs are optional.</p><br/>
							<p>Note: Removing encryption from a 'User Owned Field' will remove their ownership and normal view permissions will apply. You can re-encrypt either assigning user ownership again or without it. You can update user owned field data by simply typing over the field data in the entry editor and updating the entry. The new data will still be owned by the orginal submitting user.</p><br/>
							<p>Once you have entered the proper information, Save Changes and this option will attempt to add or remove encryption from the specified Form, Entries, and Fields.</p><p>A status report will be generated at the top of this page after saving changes based on the settings processed.</p><br/><p></p>
						</div><br/>
						<p><b>ENCRYPT / DECRYPT</b></p>
						<input type="text" id="gfe_encrypt_decrypt" name="gfe_encrypt_decrypt" value="" maxlength="7"/>
						<p><span style="color:red;">*</span> Enter 'encrypt' to perform encryption. Enter 'decrypt' to perform decryption.<br/>Do not include the quotations.</p><br/>
						<br/>
						<p><b>FORM ID</b></p>
						<input  type="text" id="gfe_encrypt_decrypt_form" name="gfe_encrypt_decrypt_form" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encrypt_decrypt_form'));} ?>" maxlength="32"/>
						<p><span style="color:red;">*</span> Enter ONE SINGLE FORM ID for the form with entries to encrypt/decrypt.</p>
						<p>example: 12</p>
						<p>(Specifies the form with ID of 12 for processing).</p><br/>
						<br/>
						<p><b>ENTRY IDs</b></p>
						<textarea class="greytextarea" rows="4" id="gfe_encrypt_decrypt_form_entries" name="gfe_encrypt_decrypt_form_entries"/><?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encrypt_decrypt_form_entries'));} ?></textarea>
						<p><b>Enter a comma separated list of entry IDs for the specified form to specify entries that should be encrypted/decrypted.</b> If left blank, ANY of the specified forms encrypted entries up to the 'BATCH SIZE' set will be decrypted from newest to last.</p>
						<p>example: 23,43,21   (would only get the forms entries with ID of 23, 43, and 21 for processing.</p>
						<p>If you use this option, the 'BATCH SIZE' and 'BATCH START POINT OFFSET' section below is ignored, but you should NOT enter more than 200 individual entries here at a time to avoid server timeout issues.</p><br/>
						<br/>
						<p><b>FIELD IDs</b></p>
						<textarea class="greytextarea" rows="4" id="gfe_encrypt_decrypt_form_fields" name="gfe_encrypt_decrypt_form_fields"/><?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encrypt_decrypt_form_fields'));} ?></textarea>
						<p><b>Enter a comma separated list of field IDs to limit which fields should be encrypted/decrypted.</b> If left blank, ANY of the specified forms fields (with encryption turned on in form - unless option to encrypt other fields with encryption turned off is on) will be encrypted during an encryption run, and any fields with Gravity Forms Encrypted Fields encrypted data (encryption can be turned on or off) will be decrypted during a decryption run.</p>
						<p>example: 23,43,21   (would only process form fields with IDs of 23, 43, or 21.</p>
						<p>This option will function to process only specific fields whether you are specifying entry IDs or processing by batch.</p><br/>
						<br/>
						<p><input type="checkbox" name="gfe_encrypt_decrypt_form_ubf" value="1" <?php checked(1, get_option('gfe_encrypt_decrypt_form_ubf'), true); ?> style="border:1px solid red;"/> <b>ENCRYPT ASSIGNING USER OWNED FIELDS</b></p>
						<p>Enable to assign original logged in submitting user ownership for any fields with "User Owned Field" turn on in the form during encryption. If disabled or the submitting user was not logged in, user owned fields will still be encrypted, but only regular (non user owned) field view permissions will apply.</p><br/>
						<br/>
						<p><input type="checkbox" name="gfe_encrypt_decrypt_form_encrypt_all" value="1" <?php checked(1, get_option('gfe_encrypt_decrypt_form_encrypt_all'), true); ?> style="border:1px solid red;"/> <b>ALLOW ENCRYPTING FIELDS WITH ENCRYPTION CURRENTLY TURNED OFF IN FORM</b></p>
						<p><span style="color:red;">CAUTION !</span> Enabling this option will allow encrypting fields for the given form that currently have encryption turned off in their advanced tab. This will result in ALL supported fields types for the form entries being encrypted if no Field IDs are specified, and will also allow for specifying Field IDs to be encrypted that currently have encryption turned off. Fields must still be of supported type.</p><br/>
						<br/>
						<div class="processing runs" style="background-color: #f2f2f2; padding: 10px; border: 2px solid #808080;  border-radius: 7px;">
							<p><span style="color:red;">*</span> If you are NOT specifying ENTRY IDs above you can enter a 'BATCH SIZE' number here to specify how many entries will be processed. If you ARE specifying ENTRY IDs above, the batch size will be ignored.</p><br/>
							<p><b>BATCH SIZE</b></p>
							<input type="text" id="gfe_encrypt_decrypt_form_entry_paging" name="gfe_encrypt_decrypt_form_entry_paging" style="border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encrypt_decrypt_form_entry_paging'));} ?>" style="width:100%; max-width: 590px; border: 1px solid red;" maxlength="3"/>
							<p>Enter the max number of entries to attempt to encrypt/decrypt for the form at a time.&nbsp(If left blank or 0 and no ENTRY IDs are specified, NO entries will be processed.)</p>
							<p>To help prevent server timeout issues, batches are limited to 200 or less entries. If you DO experience timeouts, lower the number of entries per run.</p>
							<p>Encryption/Decryption will start from the newest entry and work back through older entries this number of entries at a time.</p><br/>
							<p><b>BATCH START POINT OFFSET</b></p>
							<input type="text" id="gfe_encrypt_decrypt_form_paging_offset" name="gfe_encrypt_decrypt_form_paging_offset" style="border-radius: 7px;" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_encrypt_decrypt_form_paging_offset'));} ?>" style="width:100%; max-width: 590px; border: 1px solid red;"/>
							<p>Enter the number of entries (from newest to oldest) that the run will start at.</p>
							<p>This is NOT the entry ID you wish to start at.</p>
							<p>Example: to start processing entries 100 entries back from the newest, enter: 100</p>
							<p>This is NOT required, and if left blank processing will start from the newest entry to older.</p>
							<p>Encryption/Decryption will start from the newest entry offset back by this number and work back through older entries at the 'BATCH SIZE' number of entries at a time.</p>
							<p>To target only specific entries, please use comma seperated ENTRY IDs above instead.</p><br/>
						</div>
					</div>
					</td>
				</tr>
				<tr class="settingstr" valign="top">
					<th class="settings" scope="row">Settings Page LOCKOUT Password<p><span style="color:red;">!!! CAUTION !!!</span></p></th>
					<td>
					   <p><button id="gfe-settings-lock-instructions-idToggle" type="button" onClick="toggle_visibility('gfe-settings-lock-instructionsToggle');">Click Here For LOCKOUT SETTINGS</button></p>
					   <div id="gfe-settings-lock-instructionsToggle" style="display:none;">
					   <br/>
						   <input class="redtext" type="text" id="gfe_settings_lock" name="gfe_settings_lock" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_settings_key'));} ?>" maxlength="16" autocomplete="false"/>
						   Password
						   <input class="redtext" type="text" id="gfe_settings_lock_verify" name="gfe_settings_lock_verify" value="<?php if (is_admin() && current_user_can('edit_users')){echo esc_html__(get_option('gfe_settings_key'));delete_option('gfe_settings_key');delete_site_option('gfe_settings_key');} ?>" maxlength="16" autocomplete="false"/>
						   Verify Password
						   <?php gfe_page_lock_error(); ?>
							<br/>
							<div id="gfe-settings-lock-instructions" style="max-width:600px;">
								<p><b>Enter the same valid password twice here to keep all current settings and lock this settings page from other admins. MUST BE 8-16 normal ASCII charachters or page will NOT lock.</b><br/>
								<p>This settings page will be replaced with a page that will require this same Settings Page LOCKOUT Password to unlock the settings page again. The password will need to be entered for each time the page settings is accessed.</p><p>It is important that if you password lock the settings page you write down and store the Settings Page LOCKOUT Password safely.</p>
								<p>If you lose the password you will have to uninstall the plugin then reinstall to enter your encryption page settings again to re set-up the plugin and access encrypted data again This would require you to have both your Website Key and Encryption Password.</p>
								<p> To unlock the page, delete the Settings Page LOCKOUT Password and save changes.</p><br/>
								<input type="checkbox" name="gfe_norecover_pass" value="1" <?php checked(1, get_option('gfe_norecover_pass'), true); ?> style="border:1px solid red;"/> <b>No password removal on plugin removal and reinstall?</b>
								<p>Check this box to KEEP this Settings Page LOCKOUT Password even if plugin is deleted and reinstalled. This will keep the Settings Page LOCKOUT Password even if 'Delete Plugin Options on Removal' is turned on. If this is not on the Settings Page LOCKOUT Password will be deleted on plugin removal and reinstall.</p>
								<p>This prevents any other admin level (with ability to manage plugins) users from getting around the Settings Page LOCKOUT Password but leaves <b>NO</b> recovery option for you should you both forget and lose your copy of the Settings Page LOCKOUT Password.</p>
								<p><b>CAREFULLY COPY AND STORE YOUR Settings Page LOCKOUT Password SAFELY BEFORE TURNING THIS ON.</b></p>
								<p><b>You are responsible for all password recovery.</b></p>
							</div>
						</div>
					</td>
				</tr>
			</table>  
			<?php submit_button();?>        
		</form>
		<?php echo '<img src="' . plugin_dir_url(__FILE__)  . 'images/owl-small.png" height="30" width="30" style="display:inline-block; float:left;">'; ?><p> <a href="https://codecanyon.net/user/pluginowl/portfolio" target="_blank" rel="nofollow noopener">Plugin Owl</a></p>
		</div>
	<?php } ?>
<?php }